//!A utility window for raycasting BCC grid data
// Author:	Steven Bergner
// Created:	Mar03

#ifndef _vuBCCRaycasterUtility_h_
#define _vuBCCRaycasterUtility_h_

#include "../vuBasicUtility.h"

#include "../../wxUIElements/vuTransferDialog.h"
#include "vuCamera.h"
#include "Volume/BCC/Unimodal/3d/1B/Intensity/Raycaster/raycaster.h"


class vuBCCRaycaster : public vuBasicUtility
{
public:
    //!Constructor
    vuBCCRaycaster();
    //!Destructor
    ~vuBCCRaycaster();

    //!Returns the type of vu Datafile that the utility works with
    static const char* getFileType();

    /*!Initializes the utility window.  A object is created and
       the volume data is read.  The window appears when finished.
    */
    bool init(const char* DataFile);

    virtual void DrawAgain ();
    virtual void DrawFromImage ();
    virtual vuImage* getCurrentImage ();
    virtual vuCamera* getCamera ();

public:
    //The following methods are overridden to add controls to the window.
    //!This method adds controls to the bottom of the window.
    virtual void addBottom(wxSizer *sizer);

protected:
    //!Initializes open gl for the utility.
    /*!The method calls the initgl() method so it can do the
       proper initialization.
    */
    bool glInit();

    /*!The method calls the render() method, setting it up to
       render to the window's gl canvas.
    */
    void onRender();
    //!Resizes the gl viewport and renders the volume.
    void glResize();
    //!Handles mouse commands from the user.
    /*!The mouse is the main interface between the user and the utility
       at the moment.  This method receives mouse events from the window,
       and carries out commands.
    */
    void onMouse(wxMouseEvent &ev);

    void OnButtonRender( wxCommandEvent& event);

    vu1 *getVolume() {return m_Data;};

private:
    //!The spectral raycaster owned by the utility.
    vu1512113 *m_Data;
    //!The zoom magnification of the splatter.
    float m_ViewScale;
    //!The transfer function to be applied to the splatter.
    vuTFDesign m_TFunc;
    /** The transfer function dialog. */
    vuTransferDialog m_TFuncDlg;

    DECLARE_EVENT_TABLE()
};

#endif
