#include "vuBCCRaycaster.h"
#include <wx/wx.h>
#include <wx/button.h>

//----------------------------------------------------------------------------
//------------------------- The vuBCCRaycasterBCC event table --------------------------
//----------------------------------------------------------------------------

enum
{
  idCANVAS,
  idRENDER,
  idLGTINT,
  idLGTCOL
};

BEGIN_EVENT_TABLE(vuBCCRaycaster, vuBasicUtility)
  EVT_BUTTON  (idRENDER, vuBCCRaycaster::OnButtonRender)
END_EVENT_TABLE();

//----------------------------------------------------------------------------
//------------------------- The constructor ----------------------------------
//----------------------------------------------------------------------------

vuBCCRaycaster::vuBCCRaycaster() : m_TFunc(4,256), m_TFuncDlg(this, m_TFunc)
{
    m_Data = 0;
    m_ViewScale = 1.0f;
}

//----------------------------------------------------------------------------
//------------------------- The destructor -----------------------------------
//----------------------------------------------------------------------------

vuBCCRaycaster::~vuBCCRaycaster()
{
    if (m_Data != 0) delete m_Data;
}

//----------------------------------------------------------------------------
//------------------------- public: getFileType() ----------------------------
//----------------------------------------------------------------------------

const char* vuBCCRaycaster::getFileType()
{
    return "15121";
}

//----------------------------------------------------------------------------
//------------------------- public: init() -----------------------------------
//----------------------------------------------------------------------------

bool vuBCCRaycaster::init(const char* DataFile)
{
    SetEvtHandlerEnabled(true);

    //Set up the window
    SetTitle("Raycaster BCC Volume Rendering");
    CreateStatusBar();

    //Create a volume data instance.
    m_Data = new vu1512113;
    m_Data->setFileName(DataFile);

    //Read in the data.
    bool success = m_Data->read();
    if (success)
    {
        m_glCanvas->SetSize(512,512);
        Fit();
    }
    else
    {
        wxMessageDialog dlg(this,m_Data->getErrorMessage(),"vuBCCRaycasterBCCVR",wxOK);
        dlg.ShowModal();
    }

    return success;
};

void vuBCCRaycaster::DrawAgain ()
{
    m_DrawPreview = false;
    m_Data->refresh = true;
    m_glCanvas->redraw();
}

void vuBCCRaycaster::DrawFromImage ()
{
	m_glCanvas->redraw ();
}

vuImage* vuBCCRaycaster::getCurrentImage ()
{
	return m_Data->getImage();
}

vuCamera* vuBCCRaycaster::getCamera ()
{
    return m_Data->getCameraPtr();
}

//----------------------------------------------------------------------------
//------------------------- public: addBottom() ------------------------------
//----------------------------------------------------------------------------

void vuBCCRaycaster::addBottom(wxSizer *sizer)
{

  sizer->Add( new wxButton(this, idRENDER, "Render"),
		 0,           // make horizontally unstretchable
		 wxALL,       // make border all around (implicit top alignment)
		 10 );        // set border width to 10    
}

//----------------------------------------------------------------------------
//------------------------- public: OnButtonRender() -------------------------
//----------------------------------------------------------------------------

void vuBCCRaycaster::OnButtonRender( wxCommandEvent& event)
{
    m_Data->setIsReRendering(true);
    m_DrawPreview = false;
    m_Data->refresh = true;
    m_glCanvas->redraw();
}

//----------------------------------------------------------------------------
//------------------------- protected: glInit() ------------------------------
//----------------------------------------------------------------------------

bool vuBCCRaycaster::glInit(void)
{
  /*
    if (m_Data == 0) return false;

    glClearColor(0.0f, 0.0f, 0.0f, 0.0f);

    glEnable(GL_LIGHTING);
    glEnable(GL_LIGHT0);
    glLightModeli(GL_LIGHT_MODEL_TWO_SIDE, GL_TRUE);
  */
  m_Data->initOpenGL();

  return true;
}

//----------------------------------------------------------------------------
//------------------------- protected: glRender() ----------------------------
//----------------------------------------------------------------------------

void vuBCCRaycaster::onRender()
{
  m_Data->setTransferFunc(m_TFunc);	// better once too often :-|

  glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  glOrtho(0,m_Data->getCamera().getWidth(),
	  0,m_Data->getCamera().getHeight(), -1, 1);
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();

    wxStopWatch watch;
    watch.Start();

    m_Data->render();

    watch.Pause();
    SetStatusText(wxString("Render Time: ") + vuString(watch.Time()).c_str() + "ms");
}

//----------------------------------------------------------------------------
//------------------------- protected: glResize() ----------------------------
//----------------------------------------------------------------------------

void vuBCCRaycaster::glResize()
{
    //Set the viewport.
    glViewport(0, 0, (GLint)m_glCanvas->getWidth(),(GLint)m_glCanvas->getHeight());
    m_Data->setImageSize(m_glCanvas->getWidth(),m_glCanvas->getHeight());
    
  /*
    //Find the largest dimension of the data.
    dword max = m_Data->getDim1Size();
    if (m_Data->getDim2Size() > max)
        max = m_Data->getDim2Size();
    if (m_Data->getDim3Size() > max)
        max = m_Data->getDim3Size();

    //Set the opengl projection matrix.
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    glOrtho((float)max/(-1.0f*m_ViewScale), (float)max/m_ViewScale,
            (float)max/(-1.0f*m_ViewScale), (float)max/m_ViewScale,
            10000.0f, -10000.0f);
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();
    
    //Set the opengl light info.
    float lpos[4] = {0.0, 0.0, 1024.0, 1.0};
    glLightfv(GL_LIGHT0, GL_POSITION, lpos);
  */
}

//----------------------------------------------------------------------------
//------------------------- protected: glOnMouse() ---------------------------
//----------------------------------------------------------------------------

void vuBCCRaycaster::onMouse(wxMouseEvent &ev)
{
  if(!m_Data) return;

  if (ev.LeftDClick()) {
    m_TFuncDlg.Show(true);
  }
}

