//!A utility window for using Steve's more general splatter.

/*!
   This class is a utility window wrapper for Steve's general splatter.
   This splatter is part of the vuVolume tree, and is meant to be as general
   as possible. (see the included header files).  The utility displays
   an OpenGL window which lets users rotate the object, zoom it, as well
   as edit the transfer function.  All these commands are done using the mouse.
   
   The class is a good example of a general vuGui utility.  It can be
   used as a model for building other utilities.  
*/

#ifndef _vuBCCMarchingTetrahedraUtility_h_
#define _vuBCCMarchingTetrahedraUtility_h_

#include "../vuBasicUtility.h"
#include "vuCamera.h"
#include "Volume/BCC/Unimodal/3d/1B/Threshold/MarchingTetrahedra/marchingtetrahedra.h"

class vuBCCMarchingTetrahedra : public vuBasicUtility
{
 public:
  //!Constructor
  vuBCCMarchingTetrahedra();
  //!Destructor
  ~vuBCCMarchingTetrahedra();

  //!Returns the type of vu Datafile that the utility works with
  static const char* getFileType();

  //!Initializes the mc utility.
  /*!Initializes the utility window.  An mc object is created and
    the volume data is read.  The window appears when finished.
  */
  bool init(const char* DataFile);

  virtual void DrawAgain ();
  virtual void DrawFromImage ();
  virtual vuImage* getCurrentImage ();
  virtual vuCamera* getCamera ();

 protected:
  //!Initializes open gl for the mc utility.
  /*!The method calls the mc initgl() method so it can do the
    proper initialization.
  */
  bool glInit(void);

  //!Calls on the mc class to render the volume.
  /*!The method calls the mc class render() method, setting it up to
    render to the window's gl canvas.
  */
  void glRender(void);
  //!Resizes the gl viewport and renders the volume.
  void glResize(void);
  //!Handles mouse commands from the user.
  /*!The mouse is the main interface between the user and the utility
    at the moment.  This method receives mouse events from the window,
    and carries out commands.
  */
  void glOnMouse(wxMouseEvent &ev);

 private:
  //!The mc class owned by the utility.
  vu1512121 *m_Data;
  //!A camera class for storing the user's current view.
  vuCamera m_Camera;
  //!The zoom magnification of the mc class.
  float m_ViewScale;
  
  
  //!The width of the window.
  int m_x;
  //!The height of the window.
  int m_y;
  
  DECLARE_EVENT_TABLE();
};
    
#endif
