#include "../../wxUIElements/vuGLCanvas.h"
#include <wx/wx.h>

#include "vuBCCMarchingTetrahedra.h"
#include "../../wxUIElements/vuTransferDialog.h"

//----------------------------------------------------------------------------
//------------------------- The vuBCCMarchingTetrahedra event table --------------------------
//----------------------------------------------------------------------------

enum
  {
    idCANVAS
  };

BEGIN_EVENT_TABLE(vuBCCMarchingTetrahedra, vuBasicUtility)
  END_EVENT_TABLE()

  //----------------------------------------------------------------------------
  //------------------------- The constructor ----------------------------------
  //----------------------------------------------------------------------------

  vuBCCMarchingTetrahedra::vuBCCMarchingTetrahedra(void)
{
  m_Data = 0;
  m_ViewScale = 1.0f;
}

//----------------------------------------------------------------------------
//------------------------- The destructor -----------------------------------
//----------------------------------------------------------------------------

vuBCCMarchingTetrahedra::~vuBCCMarchingTetrahedra(void)
{
  if (m_Data != 0) delete m_Data;
}

//----------------------------------------------------------------------------
//------------------------- public: getFileType() ----------------------------
//----------------------------------------------------------------------------

const char* vuBCCMarchingTetrahedra::getFileType(void)
{
  return "15121";
}

//----------------------------------------------------------------------------
//------------------------- public: init() -----------------------------------
//----------------------------------------------------------------------------

bool vuBCCMarchingTetrahedra::init(const char* DataFile)
{
  //Set up the window for the splatter.
  SetTitle("MarchingTetrahedra");
  CreateStatusBar();

  //Create a volume data instance.
  m_Data = new vu1512121;
  m_Data->setFileName(DataFile);

  //Read in the data.
  bool success = m_Data->read();
  if (success)
    {
      m_glCanvas->SetSize(512,512);
      Fit();
    }
  else
    {
      wxMessageDialog dlg(this,m_Data->getErrorMessage(),"vuBCCMarchingTetrahedra",wxOK);
      dlg.ShowModal();
    }

  return success;
}

void vuBCCMarchingTetrahedra::DrawAgain ()

{
}

void vuBCCMarchingTetrahedra::DrawFromImage ()

{
}

vuImage* vuBCCMarchingTetrahedra::getCurrentImage ()

{
	return NULL;
}

vuCamera* vuBCCMarchingTetrahedra::getCamera ()

{
	return &m_Camera;
}

//----------------------------------------------------------------------------
//------------------------- protected: glInit() ------------------------------
//----------------------------------------------------------------------------

bool vuBCCMarchingTetrahedra::glInit(void)
{
  if (m_Data == 0) return false;

  glClearColor(0.0f, 0.0f, 0.0f, 0.0f);

  glEnable(GL_LIGHTING);
  glEnable(GL_LIGHT0);
  glLightModeli(GL_LIGHT_MODEL_TWO_SIDE, GL_TRUE);

  //m_Data->initOpenGL();
  return true;
}

//----------------------------------------------------------------------------
//------------------------- protected: glRender() ----------------------------
//----------------------------------------------------------------------------

void vuBCCMarchingTetrahedra::glRender()
{
  wxStopWatch watch;
  watch.Start();

  glClear(GL_COLOR_BUFFER_BIT);

  glLoadIdentity();
  m_Camera.gluLookAt();
  glTranslatef((float)m_Data->getDim1Size()/(-2.0f),
	       (float)m_Data->getDim2Size()/(-2.0f),
	       (float)m_Data->getDim3Size()/(-2.0f));

  m_Data->setViewVectors(m_Camera.getLookAtVector(),
			 m_Camera.getUpVector(),
			 m_Camera.getRightVector());

  m_Data->resetNTriangles();
  m_Data->render();

  watch.Pause();
  SetStatusText(wxString("Render Time: ") + vuString(watch.Time()).c_str() + "ms" + " (" + vuString(m_Data->getNTriangles()).c_str() + " triangles)");
}

//----------------------------------------------------------------------------
//------------------------- protected: glResize() ----------------------------
//----------------------------------------------------------------------------

void vuBCCMarchingTetrahedra::glResize()
{
  //Set the viewport.
  glViewport(0, 0, (GLint)m_glCanvas->getWidth(),(GLint)m_glCanvas->getHeight());
    
  //Find the largest dimension of the data.
  dword max = m_Data->getDim1Size();
  if (m_Data->getDim2Size() > max)
    max = m_Data->getDim2Size();
  if (m_Data->getDim3Size() > max)
    max = m_Data->getDim3Size();

  //Set the opengl projection matrix.
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  glOrtho((float)max/(-1.0f*m_ViewScale), (float)max/m_ViewScale,
	  (float)max/(-1.0f*m_ViewScale), (float)max/m_ViewScale,
	  10000.0f, -10000.0f);
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();
    
  //Set the opengl light info.
  float lpos[4] = {0.0, 0.0, 1024.0, 1.0};
  glLightfv(GL_LIGHT0, GL_POSITION, lpos);
}

//----------------------------------------------------------------------------
//------------------------- protected: glOnMouse() ---------------------------
//----------------------------------------------------------------------------

void vuBCCMarchingTetrahedra::glOnMouse(wxMouseEvent &ev)
{
  if (ev.LeftDown() || ev.RightDown() || ev.MiddleDown())
    {
      //Store the click position.
      m_x = (int) ev.GetX();
      m_y = (int) ev.GetY();
    }
  else if (ev.LeftIsDown() && ev.Moving())
    {
      //Rotate the volume
      vuVector t = m_Camera.getPosition();
      float d = t.norm();

      m_Camera.translateXYZ(0.0f, 0.0f, d);
      m_Camera.rotateAboutUp(ev.GetX() - m_x);
      m_Camera.rotateAboutRight(ev.GetY() - m_y);
      m_Camera.translateXYZ(0.0f, 0.0f, -d);
      m_glCanvas->redraw();

      //Store the click position.
      m_x = (int) ev.GetX();
      m_y = (int) ev.GetY();
    }
  else if (ev.RightIsDown() && ev.Moving())
    {
      //Zoom the volume.
      m_ViewScale -= ((float)ev.GetY() - m_y)/500.0f;
      glResize();
      m_glCanvas->redraw();

      //Store the click position.
      m_x = (int) ev.GetX();
      m_y = (int) ev.GetY();
    }
  else if (ev.MiddleIsDown() && ev.Moving())
    {
      //TODO:change th

      if (ev.GetY() < m_y)
	{
	  // increment theshold
	  m_Data->incThreshold();
	}
      else
	{
	  // decrement threshold
	  m_Data->decThreshold();
	}

      m_Data->render();
      m_glCanvas->redraw();

      m_x = (int) ev.GetX();
      m_y = (int) ev.GetY();
    }
  //    else if (ev.LeftDClick())
  //    {
  //	  //Pop up the transfer function editor
  //	  vuTransferDialog dlg(this,m_TFunc);
  //
  //	  if (dlg.ShowModal() == wxID_OK)
  //	  {
  //	      m_TFunc = dlg.getTransferFunc();
  //	      m_Data->setTransferFunc(m_TFunc);
  //	      m_glCanvas->redraw();
  //	  }
  //    }
}
