//!A utility window for raycasting with a spectral colour model
// Author:	Thomas Theul
// Created:	Oct01
/*!
   Derived from vuSplat Utility.
*/

#ifndef _vuBCCFirstHitRaycasterUtility_h_
#define _vuBCCFirstHitRaycasterUtility_h_

#include "../vuBasicUtility.h"

#include "../../wxUIElements/vuTransferCanvas.h"
#include "vuCamera.h"
#include "Volume/BCC/Unimodal/3d/1B/Threshold/FirstHitRaycaster/firsthitraycaster.h"


class vuBCCFirstHitRaycaster : public vuBasicUtility
{
public:
    //!Constructor
    vuBCCFirstHitRaycaster();
    //!Destructor
    ~vuBCCFirstHitRaycaster();

    //!Returns the type of vu Datafile that the utility works with
    static const char* getFileType();

    /*!Initializes the utility window.  A object is created and
       the volume data is read.  The window appears when finished.
    */
    bool init(const char* DataFile);

    virtual void DrawAgain ();
    virtual void DrawFromImage ();
    virtual vuImage* getCurrentImage ();
    virtual vuCamera* getCamera ();

public:
    //The following methods are overridden to add controls to the window.
    //!This method adds controls to the bottom of the window.
    virtual void addBottom(wxSizer *sizer);

protected:
    //!Initializes open gl for the utility.
    /*!The method calls the initgl() method so it can do the
       proper initialization.
    */
    bool glInit();

    /*!The method calls the render() method, setting it up to
       render to the window's gl canvas.
    */
    void onRender();
    //!Resizes the gl viewport and renders the volume.
    void glResize();
    //!Handles mouse commands from the user.
    /*!The mouse is the main interface between the user and the utility
       at the moment.  This method receives mouse events from the window,
       and carries out commands.
    */
    void onMouse(wxMouseEvent &ev);

    void OnLightChangeIntensity( wxScrollEvent& event);
    void OnLightChangeColour( wxScrollEvent& event);
    void OnButtonRender( wxCommandEvent& event);

    vu1 *getVolume() {return m_Data;};

private:
    //!The spectral raycaster owned by the utility.
    vu1512122 *m_Data;
    //!The zoom magnification of the splatter.
    float m_ViewScale;
    //!The transfer function to be applied to the splatter.
    vuTFDesign m_TFunc;

    wxSlider *m_LightColour, *m_LightIntensity;

    //!The width of the window.
    int m_x;
    //!The height of the window.
    int m_y;
    
    DECLARE_EVENT_TABLE()
};

#endif
