#include "vuBCCFirstHitRaycaster.h"
#include "../../wxUIElements/vuTransferDialog.h"
#include <wx/wx.h>
#include <wx/button.h>

//----------------------------------------------------------------------------
//------------------------- The vuBCCFirstHitRaycasterBCC event table --------------------------
//----------------------------------------------------------------------------

enum
{
  idCANVAS,
  idRENDER,
  idLGTINT,
  idLGTCOL
};

BEGIN_EVENT_TABLE(vuBCCFirstHitRaycaster, vuBasicUtility)
  EVT_COMMAND_SCROLL(idLGTINT, vuBCCFirstHitRaycaster::OnLightChangeIntensity)
  EVT_COMMAND_SCROLL(idLGTCOL, vuBCCFirstHitRaycaster::OnLightChangeColour)
  EVT_BUTTON  (idRENDER, vuBCCFirstHitRaycaster::OnButtonRender)
END_EVENT_TABLE()

//----------------------------------------------------------------------------
//------------------------- The constructor ----------------------------------
//----------------------------------------------------------------------------

vuBCCFirstHitRaycaster::vuBCCFirstHitRaycaster() : m_TFunc(4,256)
{
    m_Data = 0;
    m_ViewScale = 1.0f;
}

//----------------------------------------------------------------------------
//------------------------- The destructor -----------------------------------
//----------------------------------------------------------------------------

vuBCCFirstHitRaycaster::~vuBCCFirstHitRaycaster()
{
    if (m_Data != 0) delete m_Data;
}

//----------------------------------------------------------------------------
//------------------------- public: getFileType() ----------------------------
//----------------------------------------------------------------------------

const char* vuBCCFirstHitRaycaster::getFileType()
{
    return "15121";
}

//----------------------------------------------------------------------------
//------------------------- public: init() -----------------------------------
//----------------------------------------------------------------------------

bool vuBCCFirstHitRaycaster::init(const char* DataFile)
{
    SetEvtHandlerEnabled(true);

    //Set up the window
    SetTitle("FirstHitRaycasterBCC Volume Rendering");
    CreateStatusBar();

    //Create a volume data instance.
    m_Data = new vu1512122;
    m_Data->setFileName(DataFile);

    //Read in the data.
    bool success = m_Data->read();
    if (success)
    {
        m_glCanvas->SetSize(512,512);
        Fit();
    }
    else
    {
        wxMessageDialog dlg(this,m_Data->getErrorMessage(),"vuBCCFirstHitRaycasterBCCVR",wxOK);
        dlg.ShowModal();
    }

    return success;
};

void vuBCCFirstHitRaycaster::DrawAgain ()
{
    m_DrawPreview = false;
    m_Data->refresh = true;
    m_glCanvas->redraw();
}

void vuBCCFirstHitRaycaster::DrawFromImage ()
{
	m_glCanvas->redraw ();
}

vuImage* vuBCCFirstHitRaycaster::getCurrentImage ()
{
	return m_Data->getImage();
}

vuCamera* vuBCCFirstHitRaycaster::getCamera ()
{
    return m_Data->getCameraPtr();
}

//----------------------------------------------------------------------------
//------------------------- public: addBottom() ------------------------------
//----------------------------------------------------------------------------

void vuBCCFirstHitRaycaster::addBottom(wxSizer *sizer)
{
  //Add some control elements
  sizer->Add( new wxStaticText( this, -1, "Colour", wxDefaultPosition, wxSize(50,30)),
	      1,            // make vertically stretchable
	      wxEXPAND,     // make horizontally stretchable
	      10 );         // set border width to 10
  
  sizer->Add( m_LightColour = new wxSlider(this, idLGTCOL, 50, 0, 100, 
					   wxDefaultPosition, wxSize(300,30), wxSL_HORIZONTAL, 
					   wxDefaultValidator, "slider"),
	      1,
	      wxALL,
	      10 );
  sizer->Add( new wxStaticText( this, -1, "Intensity", wxDefaultPosition, wxSize(50,30)),
	      1,            // make vertically stretchable
	      wxEXPAND,     // make horizontally stretchable
	      10 );         // set border width to 10
  
  sizer->Add( m_LightIntensity = new wxSlider(this, idLGTINT, 50, 0, 100, 
					      wxDefaultPosition, wxSize(300,30), wxSL_HORIZONTAL, 
					      wxDefaultValidator, "slider"),
	      1,
	      wxALL,
	      10 );

  sizer->Add( new wxButton(this, idRENDER, "Render"),
		 0,           // make horizontally unstretchable
		 wxALL,       // make border all around (implicit top alignment)
		 10 );        // set border width to 10    
}

//----------------------------------------------------------------------------
//------------------------- public: OnLightChangeIntensity() -----------------
//----------------------------------------------------------------------------

void vuBCCFirstHitRaycaster::OnLightChangeIntensity( wxScrollEvent& event)
{
  cout<<"intensity "<<event.GetPosition()<<endl;
}

//----------------------------------------------------------------------------
//------------------------- public: OnLightChangeColour() --------------------
//----------------------------------------------------------------------------

void vuBCCFirstHitRaycaster::OnLightChangeColour( wxScrollEvent& event)
{
  cout<<"colour "<<event.GetPosition()<<endl;
}

//----------------------------------------------------------------------------
//------------------------- public: OnButtonRender() -------------------------
//----------------------------------------------------------------------------

void vuBCCFirstHitRaycaster::OnButtonRender( wxCommandEvent& event)
{
    m_Data->setIsReRendering(true);
    m_DrawPreview = false;
    m_Data->refresh = true;
    m_glCanvas->redraw();
}

//----------------------------------------------------------------------------
//------------------------- protected: glInit() ------------------------------
//----------------------------------------------------------------------------

bool vuBCCFirstHitRaycaster::glInit(void)
{
  /*
    if (m_Data == 0) return false;

    glClearColor(0.0f, 0.0f, 0.0f, 0.0f);

    glEnable(GL_LIGHTING);
    glEnable(GL_LIGHT0);
    glLightModeli(GL_LIGHT_MODEL_TWO_SIDE, GL_TRUE);
  */
  m_Data->initOpenGL();

  return true;
}

//----------------------------------------------------------------------------
//------------------------- protected: glRender() ----------------------------
//----------------------------------------------------------------------------

void vuBCCFirstHitRaycaster::onRender()
{
  glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  glOrtho(0,m_Data->getCamera().getWidth(),
	  0,m_Data->getCamera().getHeight(), -1, 1);
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();

    wxStopWatch watch;
    watch.Start();

    m_Data->render();

    watch.Pause();
    SetStatusText(wxString("Render Time: ") + vuString(watch.Time()).c_str() + "ms");
}

//----------------------------------------------------------------------------
//------------------------- protected: glResize() ----------------------------
//----------------------------------------------------------------------------

void vuBCCFirstHitRaycaster::glResize()
{
    //Set the viewport.
    glViewport(0, 0, (GLint)m_glCanvas->getWidth(),(GLint)m_glCanvas->getHeight());
    m_Data->setImageSize(m_glCanvas->getWidth(),m_glCanvas->getHeight());
    
  /*
    //Find the largest dimension of the data.
    dword max = m_Data->getDim1Size();
    if (m_Data->getDim2Size() > max)
        max = m_Data->getDim2Size();
    if (m_Data->getDim3Size() > max)
        max = m_Data->getDim3Size();

    //Set the opengl projection matrix.
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    glOrtho((float)max/(-1.0f*m_ViewScale), (float)max/m_ViewScale,
            (float)max/(-1.0f*m_ViewScale), (float)max/m_ViewScale,
            10000.0f, -10000.0f);
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();
    
    //Set the opengl light info.
    float lpos[4] = {0.0, 0.0, 1024.0, 1.0};
    glLightfv(GL_LIGHT0, GL_POSITION, lpos);
  */
}

//----------------------------------------------------------------------------
//------------------------- protected: glOnMouse() ---------------------------
//----------------------------------------------------------------------------

void vuBCCFirstHitRaycaster::onMouse(wxMouseEvent &ev)
{
/* -- this is aready done in vuBasicUtility
    vuCamera *cam = getCamera();
    if (ev.LeftDown() || ev.RightDown())
    {
        //Store the click position.
        m_x = (int) ev.GetX();
        m_y = (int) ev.GetY();
    }
    else if (ev.LeftIsDown() && ev.Moving())
    {
        //Rotate the volume
        vuVector t = cam->getPosition();
        float d = t.norm();

        cam->translateXYZ(0.0f, 0.0f, d);
        cam->rotateAboutUp(ev.GetX() - m_x);
        cam->rotateAboutRight(ev.GetY() - m_y);
        cam->translateXYZ(0.0f, 0.0f, -d);
        //m_glCanvas->redraw();

        //Store the click position.
        m_x = (int) ev.GetX();
        m_y = (int) ev.GetY();
    }
    else if (ev.RightIsDown() && ev.Moving())
    {
        //Zoom the volume.
        m_ViewScale -= ((float)ev.GetY() - m_y)/500.0f;
        glResize();
        //m_glCanvas->redraw();

        //Store the click position.
        m_x = (int) ev.GetX();
        m_y = (int) ev.GetY();
    }
*/
}

