#ifndef _vuTransferDialog_h_
#define _vuTransferDialog_h_

#include "vuTransferCanvas.h"
#include <wx/dialog.h>
#include <wx/textctrl.h>
#include <wx/wx.h>

#define TFDLG_NLIGHTS		10	// maximum number of lights
#define TFDLG_MAX_INTENSITY	5	// maximal intensity
#define TFDLG_INTENSITY0	2

//!A dialog window editor for the vuTFDesign transfer function.

/*!
   This class is a wxWindows dialog window that lets user edit the vuTFDesign
   transfer function.  It is based on the vuTransferCanvas editor, and actually
   displays this canvas in edit mode.  The difference is that the editor is
   run in a dialog window which can be displayed like any other dialog window.
   The dialog window also attaches a user interface to the transfer function.

   The user interface for the editor shows users the info for each of the control
   nodes.  When they select a control node, the control node properties are
   displayed in relevant text boxes.  The user can thus see explicitly where
   the control node is, and can edit it specifically.  There are also text
   boxes for editing the opacity and colour smoothing properties.  Finally,
   if the user double clicks on a colour control node, a standard colour
   dialogue is popped up which lets the user choose a colour from the colour
   wheel.

   Finally, the dialog has OK and Cancel buttons which work as usual.  The
   dialog sets the proper return codes for these buttons so that the resultant
   transfer function can be treated appropriately (either accepted or ignored).
*/

class vuTransferDialog : public wxDialog
{
 public:

    enum
	{
	    idCANVAS = 100,
	    idUPDATE,
	    idLOADTF,
	    idSAVETF,
	    idLAST
	};
    
    //!Constructor for the dialog window.
    /*!This creates the dialog window and it's controls, but doesn't show it.
       Call the standard ShowModal() method to display it.

       \param parent The parent window showing the dialog.
       \param tf The transfer function to be displayed and edited by the dialog.
    */
    vuTransferDialog(wxWindow *parent, vuTFDesign &tf);

    //!Returns the transfer function as edited by the dialog window.
    /*!Call this method after showing the dialog window.  It returns
       the transfer function passed in the constructor as edited by
       the user.
    */
    const vuTFDesign& getTransferFunc() const;
    
    //!true if tfunc (or lights in vuTFDialogSpec) have been updated
    bool isUpdated() {return m_IsUpdated;};
    //!unsets updated flag
    void unsetUpdated() {m_IsUpdated=false;};

 protected:
    //!Updates the user interface when a control node has been selected.
    void OnSelect(wxCommandEvent &ev);
    //!Pops up a colour dialog when a colour control node has been opened.
    void OnOpen(wxCommandEvent &ev);
    //!Refreshes the user interface when control nodes have been edited.
    void OnUpdate(wxCommandEvent &ev);
    //!Sets the proper return codes for the ok button.
    void OnOK(wxCommandEvent &ev);
    /** Loads a transfer function */
    void OnLoadTF(wxCommandEvent &ev);
    /** Saves a transfer function */
    void OnSaveTF(wxCommandEvent &ev);
    /** Event handler for changes at the light sliders.
        All three sliders m_LightSlide[] map to this function. */
    void OnSlideLight( wxScrollEvent& event);
    //!Part of the wxWindows architecture -- there is no data to transfer.
    bool TransferDataToWindow() {return true;};
    //!Part of the wxWindows architecture -- there is no data to transfer
    bool TransferDataFromWindow() {return true;};
    /* Add the sliders for the light sources.
       This function is called after a new transfer function is loaded. */
    virtual void buildCustomSizer() {};
    /* Calls buildCustomSizer and refreshes Layout of the dialog. */
    void rebuildCustomSizer();
    /* Virtual function, opens spectral colour Dialog in vuTFDialogSpec */
    virtual void editSpecColour(dword id) {};
    
protected:
    //!triggers repaint event in parent window
    void repaintParent() const;
        
    //!The editing canvas for the transfer function.
    vuTransferCanvas *m_Canvas;
    /**This is the sizer for the additional control elements.  It is
       rebuilt after a transfer function is loaded and the number of
       lights might has changed. */
    wxBoxSizer *m_CustomSizer, *m_MainSizer;
    
    //!These are the textboxes for displaying control node properties.
    wxTextCtrl *tInte, *tOpac, *tr, *tg, *tb, *tOpacSmooth, *tColSmooth;
    
    //!Indicates whether spectral colours are to be designed or RGBa
    bool m_DoSpectral;

    //!Flag is on if tfunc was updated
    bool m_IsUpdated;
        
    DECLARE_EVENT_TABLE()
};

#endif




