#ifndef _vuTFDialogSpec_h_
#define _vuTFDialogSpec_h_

#include <wx/wx.h>
#include <wx/dialog.h>
#include <wx/textctrl.h>

#include "vuTransferCanvas.h"
#include "vuTransferDialog.h"
#include "vuTFunc/vuTFDesignSpec.h"
#include "vuSpecPalette.h"
#include "vuSpectral/SPalette.h"

//!A dialog window editor for the vuTFDesignSpec transfer function.
/*!This class is derived from vuTransferDialog. It extends the interface to
   allow manipulation of light sources and other features of the spectral transfer
   fuction.
 */

class vuTFDialogSpec : public vuTransferDialog
{
public:
    enum
	{
	    idLIGHT = vuTransferDialog::idLAST,
	    idLIGHTINT = idLIGHT + TFDLG_NLIGHTS,
	    idSETUPNODES,
	    idEDITPAL,
	};

    //!Constructor for the dialog window.
    /*!This creates the dialog window and it's controls, but doesn't show it.
       Call the standard ShowModal() method to display it.

       \param parent The parent window showing the dialog.
       \param tf The transfer function to be displayed and edited by the dialog.
    */
    vuTFDialogSpec(wxWindow *parent, vuTFDesignSpec &tf);
    /** Update the sliders from the weight settings in the transfer function.*/
    void updateSliders();

protected:
    /** Event handler for changes at the light sliders.
        All three sliders m_LightSlide[] map to this function. */
    void OnSlideLight( wxScrollEvent& event);
    /** sets up the nodes for building opacity triangles over the materials */
    void OnSetupNodes(wxCommandEvent &ev);
    /** open dialog for editing the palette */
#if wxMINOR_VERSION < 5 
    void OnEditPalette(void);
#else
    void OnEditPalette(wxCommandEvent&);
#endif

    /* Add the sliders for the light sources.
       This function is called after a new transfer function is loaded.
       Overrides vuTransferDialog::buildCustomSizer().
    */
    void buildCustomSizer();
    /* opens spectral colour Dialog (virtual) */
    void editSpecColour(dword id);

protected:
    //!The editing dialog for the spectral palette
    vuSpecPalette m_PaletteDlg;

    //!Sliders for the weights of the light sources and the overall intensity.
    wxSlider *m_LightSlider[TFDLG_NLIGHTS], *m_LightIntensity;
    //!The static names
    wxStaticText *m_LightName[TFDLG_NLIGHTS], *m_IName;

    /**Set != 0 if a call of OnSlideLight should not affect the other sliders
       This counter is incremented for every slider manipulated by the program,
       see OnSlideLight()
     */
    wxButton *m_mktri, *m_edpal;

    int m_NoSliderUpdates;
    //!actual number of lights
    dword m_NLights;

    DECLARE_EVENT_TABLE()
};

#endif
