#include "vuTFDialogSpec.h"
#include "vuColourRGBa.h"
#include <iostream.h>

//----------------------------------------------------------------------------
//------------------------- The vuTFDialogSpec event table -----------------
//----------------------------------------------------------------------------

#define LIGHT(n)	vuTFDialogSpec::idLIGHT+n
#define SLDRES		1000
//#define DO_OPACITY_SLIDE

BEGIN_EVENT_TABLE(vuTFDialogSpec, vuTransferDialog)
  EVT_COMMAND_SCROLL(LIGHT(0), vuTFDialogSpec::OnSlideLight)
  EVT_COMMAND_SCROLL(LIGHT(1), vuTFDialogSpec::OnSlideLight)
  EVT_COMMAND_SCROLL(LIGHT(2), vuTFDialogSpec::OnSlideLight)
  EVT_COMMAND_SCROLL(LIGHT(3), vuTFDialogSpec::OnSlideLight)
  EVT_COMMAND_SCROLL(LIGHT(4), vuTFDialogSpec::OnSlideLight)
  EVT_COMMAND_SCROLL(LIGHT(5), vuTFDialogSpec::OnSlideLight)
  EVT_COMMAND_SCROLL(LIGHT(6), vuTFDialogSpec::OnSlideLight)
  EVT_COMMAND_SCROLL(LIGHT(7), vuTFDialogSpec::OnSlideLight)
  EVT_COMMAND_SCROLL(LIGHT(8), vuTFDialogSpec::OnSlideLight)
  EVT_COMMAND_SCROLL(LIGHT(9), vuTFDialogSpec::OnSlideLight)
  EVT_COMMAND_SCROLL(vuTFDialogSpec::idLIGHTINT, vuTFDialogSpec::OnSlideLight)
  EVT_BUTTON(vuTFDialogSpec::idSETUPNODES, vuTFDialogSpec::OnSetupNodes)
  EVT_BUTTON(vuTFDialogSpec::idEDITPAL, vuTFDialogSpec::OnEditPalette)
END_EVENT_TABLE();

//----------------------------------------------------------------------------
//------------------------- The constructor ----------------------------------
//----------------------------------------------------------------------------

vuTFDialogSpec::vuTFDialogSpec(wxWindow *parent, vuTFDesignSpec &tf)
    : vuTransferDialog(parent, tf), m_PaletteDlg(this,tf.getPalette())
{
    m_LightIntensity = NULL; 
    m_IName = NULL;
    for(word nlight = 0; nlight < TFDLG_NLIGHTS; nlight++) {
	m_LightName[nlight] = NULL;
	m_LightSlider[nlight] = NULL;
    }
    
    m_mktri = m_edpal = NULL;
    rebuildCustomSizer();
    m_IsUpdated = true;
}

void vuTFDialogSpec::buildCustomSizer()
{
    vuTFDesignSpec& tf = (vuTFDesignSpec&)m_Canvas->getTransferFunc();
    m_NLights = tf.getNumLights();
    wxSize sliderSize(200,30);
    wxFlexGridSizer *lSizer = new wxFlexGridSizer(2);
    if(m_DoSpectral && m_NLights>0)
    {
	char lname[255];
	for(word nlight=0; nlight<m_NLights; nlight++)
	{
	    sprintf(lname,"Light %i",nlight+1);
	    if(!m_LightSlider[nlight])
	    {
		m_LightSlider[nlight] = new wxSlider(this, LIGHT(nlight),
						     SLDRES, 0, SLDRES,
						     wxDefaultPosition,
						     sliderSize,
						     wxSL_HORIZONTAL, 
						     wxDefaultValidator,
						     lname);
		m_LightName[nlight] = new wxStaticText(this,-1,lname);
	    }
	    if(nlight == 0)
		m_LightSlider[nlight]->SetValue(SLDRES);
	    else m_LightSlider[nlight]->SetValue(0);
	    //wxBoxSizer *lSizer = new wxBoxSizer(wxHORIZONTAL);
	    lSizer->Add(m_LightName[nlight], 0, wxALIGN_LEFT|wxALL,3);
	    lSizer->Add(m_LightSlider[nlight], 1, wxALIGN_RIGHT|wxALL, 3 );
	    //m_CustomSizer->Add(lSizer,0,wxALIGN_CENTER);
	}
	//int(SLDRES*TFDLG_INTENSITY0/TFDLG_MAX_INTENSITY);
	if(!m_LightIntensity)
	{
	    m_LightIntensity = new wxSlider(this, idLIGHTINT, SLDRES, 0,
					    SLDRES,
					    wxDefaultPosition, sliderSize,
					    wxSL_HORIZONTAL, 
					    wxDefaultValidator, lname);
	    m_IName = new wxStaticText(this,-1,"Intensity");
	}
	m_LightIntensity->SetValue(SLDRES/3);
	//wxBoxSizer *lSizer = new wxBoxSizer(wxHORIZONTAL);
	lSizer->Add(m_IName, 0,wxALIGN_LEFT|wxALL,3);
	lSizer->Add(m_LightIntensity, 1, wxALIGN_RIGHT|wxALL, 3 );
	m_CustomSizer->Add(lSizer,0,wxALIGN_CENTER);
    }
    if(!m_mktri)
	m_mktri = new wxButton(this,idSETUPNODES,"Make Triangles");
    m_CustomSizer->Add(m_mktri,0,wxALIGN_CENTER|wxALL,1);
    if(!m_edpal)
	m_edpal = new wxButton(this,idEDITPAL,"Edit Palette");
    m_CustomSizer->Add(m_edpal,0,wxALIGN_CENTER|wxALL,1);
    m_NoSliderUpdates = 0;  // slider handler should react
    //tf.setupMtlTriAlphaNodes();
    if(m_NLights) {
	wxScrollEvent sev(0,LIGHT(0));
	OnSlideLight(sev);
    }
}

void vuTFDialogSpec::updateSliders() {
    vuTFDesignSpec& tf = (vuTFDesignSpec&)m_Canvas->getTransferFunc();
    for(word l=0;l<m_NLights;l++)
    {
	float lightweight = tf.getLightNode(l).weight;
	m_LightSlider[l]->SetValue(int(lightweight*SLDRES));
    }
    m_LightIntensity->SetValue((int)(tf.getLightIntensity()*float(SLDRES)/TFDLG_MAX_INTENSITY));
//    m_Canvas->redraw();
}

//----------------------------------------------------------------------------
//------------------------- public: OnSlideLight() -----------------
//----------------------------------------------------------------------------

void vuTFDialogSpec::OnSlideLight(wxScrollEvent& event)
{
    if(m_NoSliderUpdates) {
	m_NoSliderUpdates--;
	return;
    }
    
    dword slId = event.GetId()-LIGHT(0);
    vuTFDesignSpec& tf = (vuTFDesignSpec&)m_Canvas->getTransferFunc();
    float lightweight[TFDLG_NLIGHTS];
    float summme = 0;
    for(dword l=0;l<m_NLights;l++) {
	if(slId == l)
	    lightweight[l] = m_LightSlider[l]->GetValue()/float(SLDRES);
	else
	    lightweight[l] = tf.getLightNode(l).weight;
	summme += lightweight[l];
    }

    float intensity = (m_LightIntensity->GetValue()/float(SLDRES))*TFDLG_MAX_INTENSITY;
    if(slId < m_NLights && slId >= 0)
    {
	float scale = 1;
	float addval = 0;
	if(summme > 0.0f)
	{
	    float rest = summme-lightweight[slId];
	    if(rest == 0)
		addval = (1-lightweight[slId])/(m_NLights-1);
	    else
		scale = (1-lightweight[slId])/rest;
	}
	for(word l=0;l<m_NLights;l++)
	{
	    if(l!=slId)
	    {
		lightweight[l] = (lightweight[l]*scale)+addval;
		m_NoSliderUpdates++;
		m_LightSlider[l]->SetValue(int(lightweight[l]*SLDRES));
	    }
	}
#ifdef DO_OPACITY_SLIDE
	const vuTFDesign::OpacityNode *on = m_Canvas->getActiveOpacity();
	if (on != 0) tf.setLightOpacityNode(slId,(*on).intensity);
	else tf.setLightOpacityNode(slId, -1);
#endif
    } 
    tf.setLightIntensity(intensity);
    tf.weightLights(lightweight);
    tf.setAlphaByLight();
    tf.generateFunction();
    m_Canvas->redraw();
    m_IsUpdated = true;
    repaintParent();
}

//----------------------------------------------------------------------------

void vuTFDialogSpec::OnSetupNodes(wxCommandEvent &ev)
{
    vuTFDesignSpec& tf = (vuTFDesignSpec&)m_Canvas->getTransferFunc();
    tf.setupMtlTriAlphaNodes();
    tf.generateFunction();
    m_Canvas->redraw();
    repaintParent();
}

//----------------------------------------------------------------------------
/** open dialog for editing the palette */
#if wxMINOR_VERSION < 5
void vuTFDialogSpec::OnEditPalette(void)
#else
void vuTFDialogSpec::OnEditPalette(wxCommandEvent& ev)
#endif
{
    vuTFDesignSpec& tf = (vuTFDesignSpec&)m_Canvas->getTransferFunc();
    tf.updatePalette();
    m_PaletteDlg.UpdateWidgets();
    if (m_PaletteDlg.ShowModal() == wxID_OK)
    {
		tf.updateFromPalette();
		if(m_NLights!=tf.getNumLights())
			rebuildCustomSizer();
    }
    tf.generateFunction();
    m_Canvas->redraw();
    m_IsUpdated = true;
    repaintParent();
}

void vuTFDialogSpec::editSpecColour(dword id)
{
    vuTFDesignSpec& tf = (vuTFDesignSpec&)m_Canvas->getTransferFunc();
    tf.updatePalette();
    m_PaletteDlg.UpdateWidgets();
    m_PaletteDlg.selectSpec(id,-1);
    if (m_PaletteDlg.ShowModal() == wxID_OK)
    {
	tf.updateFromPalette();
	if(m_NLights!=tf.getNumLights())
	    rebuildCustomSizer();
    }
    tf.generateFunction();
    m_Canvas->redraw();
    m_IsUpdated = true;
    repaintParent();
}

//----------------------------------------------------------------------------
//----------------------------------------------------------------------------
