/*!Creates a little subwindow showing the view directions of a spherical
   lightfield
*/
#ifndef _vuSphericViewWin_h_
#define _vuSphericViewWin_h_

#include "vuCamera.h"
#include "vuGLCanvas.h"
#include "../wxUtilities/vuBasicUtility.h"
#include "Volume/Lightfield/Unimodal/Spheric/spheric.h"

class vuSphericViewWin : public vuGLCanvas
{
 public:
    //!constructor
    /*! \param parent parent window 
       \param sixe_xy the desired size of preview window
    */
    vuSphericViewWin(vuBasicUtility *parent, int size_x, int size_y);
    //!destructor
    ~vuSphericViewWin();

    //! attaches a vuCamera that should be controled by the vuSphericViewWin
    /*! \param cam pointer to the camera that should be manipulated */
    void setVolume(vu1611_ST* vol);
    
    //! implementation of the virtual render function
    void render();
    
    //! our own init function
    bool glInit();

    //! mouse handler that performs the arc ball transformation
    void glOnMouse(wxMouseEvent &ev);
    
 protected:
    //! pointer to the window that owns this Preview (not used)
    vuBasicUtility *m_Parent;

    //! reference to the camere that should be controled by the previewer
    vu1611_ST      *m_Volume;

    void drawRepresentation(float sx, float sy, float sz);

#ifdef WIN32
    int m_x, m_y;
#endif

DECLARE_EVENT_TABLE()

};

#endif
