#include "vuSphericViewWin.h"
#include <math.h>
#include "vuLinAlg/vuMatrix.h"
#include "vuLinAlg/vuSpherical.h"

//----------------------------------------------------------------------------
//------------------------- vuPrewviewWin implementation ---------------------
//----------------------------------------------------------------------------

BEGIN_EVENT_TABLE(vuSphericViewWin, vuGLCanvas)
  EVT_MOUSE_EVENTS(vuSphericViewWin::glOnMouse)
END_EVENT_TABLE()

vuSphericViewWin::vuSphericViewWin(vuBasicUtility *parent, int size_x, int size_y)
  : vuGLCanvas(parent,-1,wxPoint(0,0),wxSize(size_x,size_y)), m_Parent(parent) 
{
  m_Volume = NULL;
}

vuSphericViewWin::~vuSphericViewWin()
{
}

void vuSphericViewWin::setVolume(vu1611_ST* vol)
{
  m_Volume = vol;
}

void vuSphericViewWin::render()
{
  if (m_Volume == NULL) {
    cerr << "vuSphericViewWin.render(): no camera set" << endl;
    return;
  }
  glClear(GL_COLOR_BUFFER_BIT);
  m_Volume->preview();
}

bool vuSphericViewWin::glInit()
{
  return true;
}

//----------------------------------------------------------------------------
//------------------------- protected: glOnMouse() ---------------------------
//----------------------------------------------------------------------------

void vuSphericViewWin::glOnMouse(wxMouseEvent &ev)
{
}

#if 0
      {

	vuVector look=m_Data->getCameraPtr()->getLookAtVector().makeUnit()*-1;

	vuMatrix    rotX  = vuMatrix().makeRotateX(90);
        vuVector    tmp   = rotX * look;
	vuSpherical sph   = vuSpherical(tmp);
	float       alpha = (-sph.getLongitude() * 180 / M_PI) + 270;
	float       beta  = -((sph.getLatitude() * 180 / M_PI) - 90);

	glMatrixMode(GL_MODELVIEW);
	glPushMatrix();
	glLoadIdentity();

	glRotatef(beta,  1.0f, 0.0f, 0.0f);
	glRotatef(alpha, 0.0f, 1.0f, 0.0f);

#if 0
	int width  = 500;
	int height = 500;
	cerr << "  look=" << look.getString() << endl;

	glLineWidth(1.0f);
	glColor3ub(255,255,255);

	glBegin(GL_LINES);
          glVertex2i(width/2 - 40, height/2);
          glVertex2i(width/2 -  5, height/2);
 
          glVertex2i(width/2, height/2 - 40);
          glVertex2i(width/2, height/2 -  5);

          glVertex2i(width/2 +  5, height/2);
          glVertex2i(width/2 + 40, height/2);

          glVertex2i(width/2, height/2 +  5);
          glVertex2i(width/2, height/2 + 40);
	glEnd();
#endif
	glPointSize(5.0);
	glColor3ub(255,0,255);
	glBegin(GL_POINTS);
	glVertex3f(look[0],look[1],look[2]);
	glEnd();


	glPointSize(2.0);

	glBegin(GL_POINTS);
	glColor3ub(255, 255, 0);

	dword i, cnt = m_Data->getNumberOfViews();

	for(i=0;i<cnt;++i) {
	  vuVector lookFrom = m_Data->getView(i)->getLookFrom().makeUnit();
	  if (look.dot(lookFrom) >= 0)
	    glVertex3f(lookFrom[0], lookFrom[1], lookFrom[2]);
	}
	glEnd();
	glPopMatrix();
      }
#endif
