#ifndef _wxUIElements_vuSimpleProgressHandler_h_
#define _wxUIElements_vuSimpleProgressHandler_h_

#include "vuSimpleTypes.h"
#include "General/vuMisc/vuProgressHandler.h"
#include <wx/wx.h>
#include <wx/progdlg.h>

/*!  Implements the protocol defined by vuProgressHandler -ms- */

class vuSimpleProgressHandler : public vuProgressHandler
{
 public:
  vuSimpleProgressHandler(wxWindow *parent, 
			  const wxString title   = "Progress Bar",
			  const wxString message = "",
			  int            style   = wxPD_AUTO_HIDE|
			                           wxPD_APP_MODAL|
                                                   wxPD_CAN_ABORT,
			  int            range   = 1000);

  /* Further style flags are: wxPD_REMAINING_TIME
                              wxPD_ELAPSED_TIME
                              wxPD_ESTIMATED_TIME
  */

  virtual ~vuSimpleProgressHandler();

  bool update(int newProgressValue,  const char* msg=NULL);

  void setRange(int range);
  int  getRange();
  int  getCurrentProgress();

 private:
  wxString          m_Title;
  wxString          m_Message;
  int               m_Style;
  wxWindow         *m_Parent;
  wxProgressDialog *m_Progress;
  int               m_Range;
  int               m_CurrentProgress;
};

#endif /* _wxUIElements_vuSimpleProgressHandler_h_ */
