#include "vuSimpleProgressHandler.h"

vuSimpleProgressHandler::vuSimpleProgressHandler(wxWindow *parent,
						 const wxString title,
						 const wxString message,
						 int   style,
						 int   range)
{
  if (range < 1) range = 1000;
  m_Title           = title;
  m_Message         = message;
  m_Parent          = parent;
  m_Style           = style;
  m_Range           = range;
  m_CurrentProgress = 0;
  m_Progress = new wxProgressDialog(title, message, range, parent, style);
}

vuSimpleProgressHandler::~vuSimpleProgressHandler()
{
  CHECKNDELETE(m_Progress);
}

void vuSimpleProgressHandler::setRange(int range)
{
  m_Range = range;
}

int vuSimpleProgressHandler::getRange()
{
  return m_Range;

}

int vuSimpleProgressHandler::getCurrentProgress()
{
  return m_CurrentProgress;
}

bool vuSimpleProgressHandler::update(int newProgressValue, const char* msg)
{
  m_CurrentProgress = newProgressValue;
  return m_Progress->Update(newProgressValue, msg);
}
