#ifndef _wxUIElements_vuSimpleFVRDialog_h_
#define _wxUIElements_vuSimpleFVRDialog_h_

#include "vuBasicSubViewer.h"
#include "vuSimpleFVRCanvas.h"
#include <wx/dialog.h>
#include <wx/textctrl.h>
#include <wx/wx.h>

#include "Volume/Regular/Unimodal/3d/1B/Intensity/SimpleFVR/vuSimpleFVR.h"

//!A sub viewer

/*!
*/

class vuSimpleFVRDialog : public vuBasicSubViewer
{
 public:
    vuSimpleFVRDialog(wxWindow *parent);
    ~vuSimpleFVRDialog();

    //! Sets the fourier volume which will be compared to the FVR
    void setFourierVolume(vuFourierVolume1 *volume);

    //! Sets the fourier filter 
    void setFourierFilter(vuFourierFilter *filter);

    //! Sets the camera
    void setCamera(vuCamera *camera);

    bool Show(bool flag=true);
 
 protected:
    //! returns an instance of vuSimpleFVRCanvas
    vuBasicSubViewerCanvas *getCanvas();
    void addLeftRight(wxSizer *sizer, wxWindow *control);

    //! load file button callback
    void OnButtonLoadFile(wxCommandEvent& event);

    //! close file button callback
    void OnButtonCloseFile(wxCommandEvent& event);

    //! render method choice callback
    void OnChoiceMethod(wxCommandEvent& event);

    //! windows close callback
    void OnClose(wxCloseEvent &event);

    //! equal size button callback
    void OnButtonEqualSize(wxCommandEvent& event);

    //! window resizing callback
    void OnSize(wxSizeEvent& event);

    //! fit scale and bias button callback
    void OnButtonFitScaleAndBias(wxCommandEvent& event);

    //! auto scale and bias checkbox callback
    void OnCheckboxAutoScaleAndBias(wxCommandEvent& event);

    //! image scale callback
    void OnSliderImageScale(wxScrollEvent& event);

protected:
    //! wxWindows GUI
    vuSimpleFVRCanvas *m_Canvas;
    wxChoice          *m_CHOICEmethod;
    wxButton          *m_BUTTONcloseFile;

    wxCheckBox        *m_CHECKBOXautoScaleAndBias;
    wxButton          *m_BUTTONfitScaleAndBias;
    wxSlider          *m_SLIDERimageScale;
    wxSlider          *m_SLIDERimageBias;

    //! the simple FVR
    vu1112119  *m_FVR;

    vuFourierFilter *m_FourierFilter;
    vuCamera        *m_Camera;
                
    DECLARE_EVENT_TABLE()
};

#endif /* _wxUIElements_vuSimpleFVRDialog_h_ */
