#include "vuSimpleFVRDialog.h"

#include <iostream>
#include "../vuUtilityWindow.h"
#include "../wxUtilities/vuBasicUtility.h"

#define WINDOW_TITLE "Simple FVR"

enum {
  idCANVAS,
  idLOAD,
  idCLOSE,
  idEQUALSIZE,
  idMETHOD,

  idIMAGESCALE,
  idIMAGEBIAS,
  idAUTOSCALEANDBIAS,
  idFITSCALEANDBIAS
};

//****************************************************************************
//************************* The vuSimpleFVRDialog event table ****************
//****************************************************************************

BEGIN_EVENT_TABLE(vuSimpleFVRDialog, vuBasicSubViewer)
  EVT_BUTTON(idLOAD,        vuSimpleFVRDialog::OnButtonLoadFile)
  EVT_BUTTON(idCLOSE,       vuSimpleFVRDialog::OnButtonCloseFile)
  EVT_BUTTON(idEQUALSIZE,   vuSimpleFVRDialog::OnButtonEqualSize)
  EVT_CHOICE(idMETHOD,      vuSimpleFVRDialog::OnChoiceMethod)

  EVT_BUTTON(idFITSCALEANDBIAS,    vuSimpleFVRDialog::OnButtonFitScaleAndBias)
  EVT_COMMAND_SCROLL(idIMAGESCALE, vuSimpleFVRDialog::OnSliderImageScale)
  EVT_COMMAND_SCROLL(idIMAGEBIAS,  vuSimpleFVRDialog::OnSliderImageScale)
  EVT_CHECKBOX(idAUTOSCALEANDBIAS, vuSimpleFVRDialog::OnCheckboxAutoScaleAndBias)
END_EVENT_TABLE()

//****************************************************************************
//************************* The constructor **********************************
//****************************************************************************

vuSimpleFVRDialog::vuSimpleFVRDialog(wxWindow *parent)
    : vuBasicSubViewer(parent, WINDOW_TITLE)
{
  m_FVR           = NULL;
  m_FourierFilter = NULL;
  m_Camera        = NULL;
  m_Canvas        = new vuSimpleFVRCanvas(this, idCANVAS);
  m_Canvas->SetSize(200,200);
}

vuSimpleFVRDialog::~vuSimpleFVRDialog()
{
  m_Canvas->setFVR(NULL);
  CHECKNDELETE(m_FVR);

  m_Canvas          = NULL;
  m_FourierFilter   = NULL;
  m_Camera          = NULL;
  m_BUTTONcloseFile = NULL;

  m_CHECKBOXautoScaleAndBias = NULL;
  m_BUTTONfitScaleAndBias    = NULL;
  m_SLIDERimageScale         = NULL;
  m_SLIDERimageBias          = NULL;
}

vuBasicSubViewerCanvas *vuSimpleFVRDialog::getCanvas()
{
  return m_Canvas;
}

void vuSimpleFVRDialog::addLeftRight(wxSizer *sizer, wxWindow *control)
{
  wxStaticBox      *borderBox   = NULL;
  wxStaticBoxSizer *borderSizer = NULL;
  wxFlexGridSizer  *flexGrid     = NULL;

  // --- file section ------------------------------------------------------
  borderBox   = new wxStaticBox(control, -1, "File", wxDefaultPosition,
				wxSize(-1,-1),wxCAPTION);
  borderSizer = new wxStaticBoxSizer(borderBox, wxVERTICAL);
  flexGrid    = new wxFlexGridSizer(2,5,5);

  flexGrid->Add(new wxButton(control, idLOAD, "load",
			     wxDefaultPosition,
			     wxSize(80,18)), 0, wxALIGN_CENTER);
  m_BUTTONcloseFile = new wxButton(control, idCLOSE, "close",
				   wxDefaultPosition, wxSize(80,18));
  m_BUTTONcloseFile->Disable();
  flexGrid->Add(m_BUTTONcloseFile, 0, wxALIGN_CENTER);

  borderSizer->Add(flexGrid);
  sizer->Add(borderSizer,0,wxEXPAND,5);
  sizer->Add(0,10);

  // --- scale and bias interface -------------------------------------------

  borderBox   = new wxStaticBox(control, -1, "Scale and Bias");
  borderSizer = new wxStaticBoxSizer(borderBox, wxVERTICAL);

  flexGrid = new wxFlexGridSizer(2,5,5);

  // image scale factor
  {
    m_SLIDERimageScale =
      new wxSlider(control, idIMAGESCALE, 0, 0, 10000,
		   wxDefaultPosition,  wxSize(130,20), wxSL_HORIZONTAL, 
		   wxDefaultValidator, "imageScaleSlider");
    m_SLIDERimageScale->SetValue(2550);
  }

  // image bias
  {
    m_SLIDERimageBias =
      new wxSlider(control, idIMAGEBIAS, 0, -1280, 1270,
		   wxDefaultPosition,  wxSize(130,20), wxSL_HORIZONTAL, 
		   wxDefaultValidator, "imageBiasSlider");
  }

  flexGrid->Add(80,1);
  flexGrid->Add(0, 1);

  flexGrid->Add(new wxStaticText(control,-1,"Scale:"),0,wxALIGN_RIGHT);
  flexGrid->Add(m_SLIDERimageScale,0,wxALL|wxALIGN_LEFT,1);

  flexGrid->Add(new wxStaticText(control,-1,"Bias:"),0,wxALIGN_RIGHT);
  flexGrid->Add(m_SLIDERimageBias,0,wxALL|wxALIGN_LEFT,1);

  m_BUTTONfitScaleAndBias =
    new wxButton(control, idFITSCALEANDBIAS, "fit",
		 wxDefaultPosition, wxSize(130,16));
  
  flexGrid->Add(new wxStaticText(control,-1,"Fit:"),0,wxALIGN_RIGHT);
  flexGrid->Add(m_BUTTONfitScaleAndBias, 0, wxALL|wxALIGN_LEFT,1);

  flexGrid->Add(new wxStaticText(control,-1,"Auto:"),0,wxALIGN_RIGHT);
  m_CHECKBOXautoScaleAndBias =
    new wxCheckBox(control, idAUTOSCALEANDBIAS, "",
		   wxDefaultPosition, wxSize(15,15));
  flexGrid->Add(m_CHECKBOXautoScaleAndBias);

  flexGrid->Add(0,3);
  flexGrid->Add(0,3);

  borderSizer->Add(flexGrid);

  sizer->Add(borderSizer);
  sizer->Add(0,10);

  // --- view section -------------------------------------------------------
  borderBox   = new wxStaticBox(control, -1, "view", wxDefaultPosition,
				wxSize(-1,-1),wxCAPTION);
  borderSizer = new wxStaticBoxSizer(borderBox, wxVERTICAL);
  flexGrid    = new wxFlexGridSizer(2,5,5);

  flexGrid->Add(80,5);
  flexGrid->Add(0,5);
  flexGrid->Add(new wxStaticText(control, -1, "Views:"), 0, wxALIGN_RIGHT);
  flexGrid->Add(new wxButton(control, idEQUALSIZE, "equal size"));
  flexGrid->Add(80,5);
  flexGrid->Add(0,5);

  borderSizer->Add(flexGrid);

  // comparison method
  {
    m_CHOICEmethod = 
      new wxChoice(control, idMETHOD, wxDefaultPosition, wxSize(130,20),
		   0, NULL, wxCAPTION, wxDefaultValidator, "Method");

    m_CHOICEmethod->Append("Spatial");
    m_CHOICEmethod->Append("Spatial Delta");
    m_CHOICEmethod->Append("Freq. Ampl.");
    m_CHOICEmethod->Append("Freq. Ampl. Delta");
    m_CHOICEmethod->Append("Freq. Phase");
    m_CHOICEmethod->Append("Freq. Phase Delta");
    m_CHOICEmethod->Append("Freq. Real");
    m_CHOICEmethod->Append("Freq. Real Delta");
    m_CHOICEmethod->Append("Freq. Imag.");
    m_CHOICEmethod->Append("Freq. Imag. Delta");

    m_CHOICEmethod->SetSelection(0);
  }

  borderSizer->Add(m_CHOICEmethod);
  sizer->Add(borderSizer,0,wxEXPAND,5);
  sizer->Add(0,10);
}

//! set the fourier volume which will be compared...
void vuSimpleFVRDialog::setFourierVolume(vuFourierVolume1 *volume)
{
  m_Canvas->setFourierVolume(volume);
}

void vuSimpleFVRDialog::setFourierFilter(vuFourierFilter *filter)
{
  m_FourierFilter = filter;
  if (m_FVR) m_FVR->setFilter(filter);
}

void vuSimpleFVRDialog::setCamera(vuCamera *camera)
{
  m_Camera = camera;
  if (m_FVR) m_FVR->setCamera(camera);
}

bool vuSimpleFVRDialog::Show(bool flag)
{
  if (flag) {
    m_Canvas->setFVR(m_FVR);
  }
  else
    m_Canvas->setFVR(NULL);

  return vuBasicSubViewer::Show(flag);
}

void vuSimpleFVRDialog::OnButtonLoadFile(wxCommandEvent& event)
{
  //open load dialog, ...
  wxFileDialog fd(this,"Choose a frequency volume file","","","*.fvr",wxOPEN);

  if(fd.ShowModal() == wxID_OK) {
    vuString fileName = fd.GetPath().c_str();

    m_Canvas->setFVR(NULL);
    CHECKNDELETE(m_FVR);

    m_FVR = new vu1112119();
    m_FVR->setWrap(3);

    if (m_Camera == NULL) {
      cerr << "vuSimpleFVRDialog.OnButtonLoadFile(): no camera set" << endl;
      return;
    }
    if (m_FourierFilter == NULL) {
      cerr << "vuSimpleFVRDialog.OnButtonLoadFile(): no fourierFilter set";
      cerr << endl;
      return;
    }

    cerr << "loading " << fileName.getLastPathComponent()<<"...";
    if (m_FVR->readFourierFromFile(fileName)) {
      m_FVR->setFilter(m_FourierFilter);
      m_FVR->setCamera(m_Camera);
      cerr << "vuSimpleFVRDialog::OnButtonLoadFile: not implemented properly" << endl;
      //      m_FVR->setScale((float)1/10);
      m_FVR->glResize(m_Canvas->getWidth(), m_Canvas->getHeight());
      m_Canvas->setFVR(m_FVR);

      // updating the window title
      {
	m_BUTTONcloseFile->Enable(true);
	wxString title = WINDOW_TITLE;
	title += " - ";
	title += fileName.getLastPathComponent().c_str();
	title += " [";
	title += vuString(m_FVR->getXSize()).c_str();
	title += "x";
	title += vuString(m_FVR->getYSize()).c_str();
	title += "x";
	title += vuString(m_FVR->getZSize()).c_str();
	title += "]";
	SetTitle(title);
      }
      cerr << " done." << endl;
    }
    else
      cerr << " COULD NOT LOAD FILE!" <<  endl;

    m_Canvas->redraw();
  }
}

void vuSimpleFVRDialog::OnButtonCloseFile(wxCommandEvent& event)
{
  CHECKNDELETE(m_FVR);
  m_BUTTONcloseFile->Disable();
  m_Canvas->setFVR(NULL);
  SetTitle(WINDOW_TITLE);
  m_Canvas->redraw();
}

void vuSimpleFVRDialog::OnButtonEqualSize(wxCommandEvent& event)
{
  makeCanvasSizeEqual();
}


void vuSimpleFVRDialog::OnChoiceMethod(wxCommandEvent& event)
{
  m_Canvas->setRenderMethod(m_CHOICEmethod->GetSelection());
  m_Canvas->redraw();
}

void vuSimpleFVRDialog::OnButtonFitScaleAndBias(wxCommandEvent& event)
{
  //m_ShouldFitScaleAndBias = true;
  m_Canvas->redraw();
}

void vuSimpleFVRDialog::OnCheckboxAutoScaleAndBias(wxCommandEvent& event)
{
  if (m_CHECKBOXautoScaleAndBias->GetValue()) {
    m_SLIDERimageScale->Disable();
    m_SLIDERimageBias->Disable();
    m_BUTTONfitScaleAndBias->Disable();
  }
  else {
    m_SLIDERimageScale->Enable();
    m_SLIDERimageBias->Enable();
    m_BUTTONfitScaleAndBias->Enable(true);
  }
  m_Canvas->redraw();
}

void vuSimpleFVRDialog::OnSliderImageScale(wxScrollEvent& event)
{
  m_Canvas->setImageScale((float)m_SLIDERimageScale->GetValue()/10);
  m_Canvas->redraw();
}
