#ifndef _wxUIElements_vuSimpleFVRCanvas_h_
#define _wxUIElements_vuSimpleFVRCanvas_h_

#include <wx/wx.h>
#include "vuBasicSubViewer.h"
#include "General/vuLightfield/vuFixelMap.h"
#include "General/vuFourier/vuFourierVolume.h"
#include "Volume/Regular/Unimodal/3d/1B/Intensity/SimpleFVR/vuSimpleFVR.h"

class vuSimpleFVRCanvas : public vuBasicSubViewerCanvas
{
public:
    //!The constructor
    vuSimpleFVRCanvas(vuBasicSubViewer *parent, wxWindowID id=-1);
    //!The destructor.
    ~vuSimpleFVRCanvas();

    //! sets the to displayed volume
    void setFVR(vu1112119 *fvr);
    void setFourierVolume(vuFourierVolume1 *volume);

    //! sets the rendering method
    /*! following methods are supported:
        0 ... render image (default)
	1 ... render image delta
	2 ... render frequency amplitude
	3 ... render frequency amplitude delta
	4 ... render frequency phase
	5 ... render frequency phase delta
        6 ... render frequency real part
        7 ... render frequency real part delta
        8 ... render frequency imaginary part
        9 ... render frequency imaginary part delta
     */
    void setRenderMethod(dword method);

    //! set image scale
    void setImageScale(float scale);

protected:
    //!Initializes openGL for the transfer function canvas
    bool glInit();
    //!Renders the transfer function.
    void render();
    //!Sets up the coordinates for the canvas.
    void resize();

    //! clear canvas
    void _clearCanvas();

    //! render image
    void _renderImage();

    void _copyDeltaImageToRGB(vuFixelMap1F *errorMap, vuFixelMap3F *rgbMap);

    void _renderImageOld();

    //! calculate the image difference
    bool _substract(vuFixelMap1F *srcImg, vuFixelMap1F* destImg);

    //!Helper function that posts the passed in event to the event handler
    void postEvent(wxEventType ev);

protected:
    vu1112119        *m_FVR;
    vuFourierVolume1 *m_FourierVolume;
    dword             m_RenderMethod;
    vuFixelMap1F     *m_Image;
    vuFixelMap3F     *m_ImageRGB;
    float             m_ImageScale;
};

#endif /* _wxUIElements_vuSimpleFVRCanvas_h_ */
