#include "vuSimpleFVRCanvas.h"
#include <GL/gl.h>
#include <GL/glu.h>
#include "vuSimpleFVRDialog.h"

#define ODD(x) ((x)&1)

// Constructor
vuSimpleFVRCanvas::vuSimpleFVRCanvas(vuBasicSubViewer *parent,wxWindowID id) :
  vuBasicSubViewerCanvas(parent, id)
{
  m_Image         = NULL;
  m_ImageRGB      = NULL;
  m_FVR           = NULL;
  m_FourierVolume = NULL;
  m_ImageScale    = 255.0f;

  m_RenderMethod  = 0; // spatial data
}

// Deconstructor
vuSimpleFVRCanvas::~vuSimpleFVRCanvas()
{
  CHECKNDELETE(m_Image);
  CHECKNDELETE(m_ImageRGB);

  m_FVR           = NULL;
  m_FourierVolume = NULL;
}


void vuSimpleFVRCanvas::setFVR(vu1112119 *fvr)
{
  m_FVR = fvr;
}

void vuSimpleFVRCanvas::setFourierVolume(vuFourierVolume1 *volume)
{
  m_FourierVolume = volume;
}


void vuSimpleFVRCanvas::setRenderMethod(dword method)
{
  m_RenderMethod = method;
  if (m_RenderMethod > 9) m_RenderMethod = 0;
}

void vuSimpleFVRCanvas::setImageScale(float scale)
{
  m_ImageScale = scale;
}

//----------------------------------------------------------------------------
//------------------------- protected: glInit() ------------------------------
//----------------------------------------------------------------------------

bool vuSimpleFVRCanvas::glInit(void)
{
  glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
  return true;
};

//----------------------------------------------------------------------------
//------------------------- protected: resize() ------------------------------
//----------------------------------------------------------------------------

void vuSimpleFVRCanvas::resize()
{
}

//----------------------------------------------------------------------------
//------------------------- protected: render() ------------------------------
//----------------------------------------------------------------------------

void vuSimpleFVRCanvas::render()
{
  if (m_FVR)
    _renderImage();
  else
    _clearCanvas();
}

//----------------------------------------------------------------------------
//------------------------- protected: postEvent() ---------------------------
//----------------------------------------------------------------------------

void vuSimpleFVRCanvas::postEvent(wxEventType ev)
{
  wxCommandEvent commandEvent(ev, GetId());
  commandEvent.SetEventObject(this);
  //commandEvent.SetClientData(&m_TFunc);
  GetEventHandler()->ProcessEvent(commandEvent);   
}

void vuSimpleFVRCanvas::_clearCanvas()
{
  static byte *black = NULL;

  if (black == NULL) {
    black = new byte[16];
    for (dword i=0; i<16; i++) black[i] = 0;
  }
  glPixelZoom((float)getWidth()/4, (float)getHeight()/4);
  glDrawPixels(4,4, GL_LUMINANCE, GL_UNSIGNED_BYTE, black);
}

void vuSimpleFVRCanvas::_renderImage()
{
  dword method  = m_RenderMethod / 2;
  bool  isDelta = (m_RenderMethod % 2);
  float minVal;
  float maxVal;

  m_FVR->updateCamera();
  m_FVR->computeUnscaledImage(m_Image, minVal, maxVal, method);

  if (isDelta && m_FourierVolume) {
    float minVal2;
    float maxVal2;
    vuFixelMap1F *img = NULL;

    m_FourierVolume->computeUnscaledImage(img, minVal2, maxVal2, method);
    cerr << "minVal"  << minVal  << " maxVal"  << maxVal  << endl;
    cerr << "minVal2" << minVal2 << " maxVal2" << maxVal2 << endl;

    dword width  = m_Image->getWidth();
    dword height = m_Image->getHeight();

    if (m_ImageRGB == NULL)
      m_ImageRGB = new vuFixelMap3F(width, height);
    else if (m_ImageRGB->getWidth()  != width || 
	     m_ImageRGB->getHeight() != height) {
      m_ImageRGB->setWidthAndHeight(width, height);
    }
    *m_Image /= maxVal;
    *img     /= maxVal2;
    
    *m_ImageRGB = vuFixel3F(0.0f); // clear RGB image
    if (_substract(img, m_Image)) {
      CHECKNDELETE(img);
      img = m_Image;
    }
    else {
      _substract(m_Image, img);
      CHECKNDELETE(m_Image);
      m_Image = img;
    }

    img->getMinAndMaxValue(minVal, maxVal);

    cerr << "delta.minVal"  << minVal  << " delta.maxVal"  << maxVal  << endl;

    _copyDeltaImageToRGB(img, m_ImageRGB);

    *m_ImageRGB /= m_ImageScale;
    //*m_ImageRGB /= m_ImageScale;

    m_ImageRGB->glResize(getWidth(), getHeight());
    m_ImageRGB->glRender();
  }
  else {
    *m_Image /= m_ImageScale;

    m_Image->glResize(getWidth(), getHeight());
    m_Image->glRender();
  }
}

void vuSimpleFVRCanvas::_copyDeltaImageToRGB(vuFixelMap1F *errorMap,
					     vuFixelMap3F *rgbMap)
{
  dword count  = errorMap->getWidth() * errorMap->getHeight();
  float *src   = errorMap->getBuffer();
  float *dest  = rgbMap->getBuffer();

  for (dword i=0; i<count; i++) {
    if (*src < 0.0)
      dest[0] = -(*src); // RED  -> minus
    else
      dest[2] = *src;    // BLUE -> plus

    dest += 3; // RGB
    src  += 1; // Intensity
  }
}

void vuSimpleFVRCanvas::_renderImageOld()
{
  dword method  = m_RenderMethod / 2;
  bool  isDelta = (m_RenderMethod % 2);
  float minVal;
  float maxVal;

  m_FVR->updateCamera();
  m_FVR->computeUnscaledImage(m_Image, minVal, maxVal, method);

  if (isDelta && m_FourierVolume) {
    float minVal2;
    float maxVal2;
    vuFixelMap1F *img = NULL;

    m_FourierVolume->computeUnscaledImage(img, minVal2, maxVal2, method);
    _substract(img,m_Image);
    //*m_Image -= *img;
  }

  //*m_Image /= maxVal;
  //*m_Image -= minVal;

  m_Image->glResize(getWidth(), getHeight());
  m_Image->glRender();
}

bool vuSimpleFVRCanvas::_substract(vuFixelMap1F *srcImg, vuFixelMap1F* destImg)
{
  float *dest   = destImg->getBuffer();
  float *src    = srcImg->getBuffer();
  dword rowStep = destImg->getWidth();
  int   deltaX  = destImg->getWidth()  - srcImg->getWidth();
  int   deltaY  = destImg->getHeight() - srcImg->getHeight();

  if (deltaX < 0 || deltaY < 0) {
    cerr << "vuSimpleFVRCanvas::_substract(): ";
    cerr << "this case is not implemented! (case 1)" << endl;
    return false;
  }

  dword lowX  = abs(deltaX / 2);
  dword lowY  = abs(deltaY / 2);
  dword highX = lowX + srcImg->getWidth();
  dword highY = lowY + srcImg->getHeight();

  dest+= lowY * rowStep;
  float *ptr = dest;
  for (dword j=lowY; j<highY; j++) {
    dest = ptr + lowX;
    for (dword i=lowX; i<highX; i++, dest++, src++) {
      *dest -= *src;
    }
    ptr += rowStep;
  }
  return true;
}
