#ifndef _VULIGHTDIAL_H_
#define _VULIGHTDIAL_H_

#include <wx/wx.h>
#include <wx/dialog.h>
#include <wx/image.h>
#include <wx/file.h>

#include "../vuGui.h"
#include "vuTFunc/vuTFDesignSpec.h"
#include "vuConvexHull.h"
#include "vuSimpleTypes.h"

#define CHECK_EXE_PATH
#ifdef CHECK_EXE_PATH
// to make wxGetApp function usable
DECLARE_APP(vuGUI)
#endif

#define LDIAL_SLDRES		100
#define LDIAL_INTENSITY		5

#define LDIAL_MAXLIGHTS		100

//!A multidimensional slider for the light weights!
/*! the weights result from reciprocal distances to the nodes being normalized
    to sum==1*/
class vuLightDial : public wxDialog
{
public:
    enum
	{
	    idLIGHTINT,
	    idHIDE,
	    idLAST
	};

    //!Constructor for the dialog window.
    /*!This creates the dialog window and it's controls, but doesn't show it.
       Call the standard ShowModal() method to display it.

       \param parent The parent window showing the dialog.
       \param tf The transfer function to be displayed and edited by the dialog.
    */
    vuLightDial(wxWindow *parent, vuTFDesignSpec &tf);

    //! lights have been updated?
    bool isUpdated() {
	bool ret=m_IsUpdated;
	m_IsUpdated=false;
	return ret;
    }

    /** Set the slider according to the weights.  A correct
	implementation of this function is quite tricky if even
	impossible because of the limitation of the 2D slidespace and
	the nD weight space. So far we just use an
	approximation. Actually, we are doing nothing so far ;-)*/
    void updateSliders();

    //! returns value of lagrange interpolation polynomial L(j)
    float getLj(int j, const wxPoint& x);
    
 protected:

    //!change in intensity slider
#if wxMINOR_VERSION < 5
    void OnSlideIntensity();
#else
    void OnSlideIntensity(wxScrollEvent&);
#endif
    //!hide button clicked
#if wxMINOR_VERSION < 5
    void OnHide();
#else
    void OnHide(wxCommandEvent&);
#endif

    //!reweights the lights according to slider position
    void reweightLights();
    
    //! mouse handler
    void OnMouseEvent(wxMouseEvent& event);
    //! customized handle for paint events
#if wxMINOR_VERSION < 5
    void OnPaint();
#else
    void OnPaint(wxPaintEvent& event);
#endif
    void DrawShape();
    
    //!repaint parent (should be a (vuUtilityWindow*))
    void repaintParent();
    
    //!handle to the tfunc holding the light sources
    vuTFDesignSpec &m_TFunc;
    
    //!Slider for the overall intensity.
    wxSlider *m_LightIntensity;

    //!area of the dial
    wxRect m_DialArea;

    //!position of the light weight
    int m_WeightX, m_WeightY;
    
    //! spacer for the dial
    wxSizer *m_DialSpacer;

    //! is updated?
    bool m_IsUpdated;
    
    wxPoint	m_LPos[LDIAL_MAXLIGHTS];
    bool	m_LActive[LDIAL_MAXLIGHTS];
    wxPoint	m_HullPos[LDIAL_MAXLIGHTS];
    int		m_LIndices[LDIAL_MAXLIGHTS];
    int		m_NLights, m_NCHull;

    vuConvexHull m_CHull;

    wxBitmap    *m_BulbImg;

    DECLARE_EVENT_TABLE()
};

#ifndef WIN32
# undef wxUSE_LIBPNG
#endif


#endif
