#include "vuLightDial.h"
#include "../vuUtilityWindow.h"
#include <wx/mstream.h>

#include <iostream.h>
#include <math.h>

#include "vuColour31a.h"

#include "bulb.h"

#ifdef WIN32
#include "wx/msw/winundef.h"
#endif

#define MIN(a,b) (a<b ? a : b)
#define MAX(a,b) (a>b ? a : b)

//#ifdef WIN32
//int rint(double d) {
//	return (int) d;
//}
//#endif

BEGIN_EVENT_TABLE(vuLightDial, wxDialog)
    EVT_PAINT(vuLightDial::OnPaint)
    EVT_MOUSE_EVENTS(vuLightDial::OnMouseEvent)
    EVT_COMMAND_SCROLL(vuLightDial::idLIGHTINT, vuLightDial::OnSlideIntensity)
    EVT_BUTTON(vuLightDial::idHIDE, vuLightDial::OnHide)
END_EVENT_TABLE();

#ifndef HEADERIMG
#define HEADERIMG(varname) varname, varname ## _size
#endif

//----------------------------------------------------------------------------
//------------------------- The constructor ----------------------------------
//----------------------------------------------------------------------------

vuLightDial::vuLightDial(wxWindow *parent, vuTFDesignSpec &tf)
    : wxDialog(parent,-1, wxString("Light Dial"),
	       wxDefaultPosition,wxDefaultSize,wxDEFAULT_DIALOG_STYLE),
    m_TFunc(tf)
{
    m_NLights = 0;
    m_WeightX = -1;
    m_WeightY = -1;
    wxSizer *sizer = new wxBoxSizer(wxHORIZONTAL);
    m_DialArea.width = 200;
    m_DialArea.height = 200;
    m_DialSpacer = new wxBoxSizer(wxHORIZONTAL);
    m_DialSpacer->Add(m_DialArea.width,m_DialArea.height);
    sizer->Add(m_DialSpacer);
    wxSizer *rightsizer = new wxBoxSizer(wxVERTICAL);
    m_LightIntensity = new wxSlider(this,idLIGHTINT,
 				    (int)(float(LDIAL_SLDRES)/LDIAL_INTENSITY),
 				    0,LDIAL_SLDRES,
				    wxDefaultPosition, 
				    wxSize(20,m_DialArea.height-20),
				    wxSL_VERTICAL);
    rightsizer->Add(new wxStaticText(this, -1, "Intensity"),
		    0,wxALL|wxALIGN_CENTER,5);
    rightsizer->Add(m_LightIntensity,0,wxALL|wxALIGN_CENTER,5);
    rightsizer->Add(new wxButton(this,idHIDE,"Hide"),0,wxALL|wxALIGN_CENTER,5);
    sizer->Add(rightsizer);
    
    SetSizer(sizer);
    SetAutoLayout(true);
    sizer->Layout();
    sizer->SetSizeHints(this);
    sizer->Fit(this);

    m_DialArea.x = m_DialSpacer->GetPosition().x;
    m_DialArea.y = m_DialSpacer->GetPosition().y;
    m_IsUpdated = false;

#ifdef LOAD_IMAGE_FROM_FILE
    // try to find the directory with our images
    wxString dir;
    vuGUI *app = &(wxGetApp());
#ifndef WIN32
    if (app != NULL) {
	dir = app->argv[0];
	dir = dir.BeforeLast('/');
    }
    if ( wxFile::Exists(dir+"/bulb.png") )
	dir = dir+"/";
    else if ( wxFile::Exists("./bulb.png") )
        dir = "./";
    else
        wxLogWarning("Can't find image files in directories!");

#else
    if (app != NULL) {
	dir = app->argv[0];
	dir = dir.BeforeLast('\\');
    }
    if ( wxFile::Exists(dir+"\\bulb.png") )
	dir = dir+"\\";
    else if ( wxFile::Exists(".\\bulb.png") )
        dir = ".\\";
    else
        wxLogWarning("Can't find image files in directories!");
#endif
#endif // of LOAD_IMAGE_FROM_FILE

#if wxUSE_LIBPNG
#ifndef LOAD_IMAGE_FROM_FILE
    wxMemoryInputStream mims(HEADERIMG(bulbimg));
    wxImage image(mims);
#if wxMINOR_VERSION < 5
    m_BulbImg = new wxBitmap( image.ConvertToBitmap() );
#else
    m_BulbImg = new wxBitmap( image );
#endif
#else
    if ( !image.LoadFile( dir + wxString("bulb.png")) ) {
        wxLogError("Can't load PNG image");
	m_BulbImg = NULL;
    } else {
        m_BulbImg = new wxBitmap( image.ConvertToBitmap() );
	//writeImageToHeader(image, "bulb.h", "bulbimage");
    }
#endif // of LOAD_IMAGE_FROM_FILE
#endif // wxUSE_LIBPNG
}

void vuLightDial::updateSliders() {
    m_LightIntensity->SetValue((int)(m_TFunc.getLightIntensity()*float(LDIAL_SLDRES)/LDIAL_INTENSITY));
#ifndef WIN32
    DrawShape();
#endif
}

#if wxMINOR_VERSION < 5
void vuLightDial::OnHide()
#else
void vuLightDial::OnHide(wxCommandEvent& ev)
#endif
{
    EndModal(wxID_OK);
    Show(false);	// ?
}

#if wxMINOR_VERSION < 5
void vuLightDial::OnPaint()
#else
void vuLightDial::OnPaint(wxPaintEvent& event)
#endif
{
#if !defined(__WXMOTIF__) && !defined(WIN32)
  wxPaintEvent event;
  wxDialog::OnPaint(event);
#endif

  DrawShape();
}

void vuLightDial::DrawShape()
{
  wxPaintDC dc(this);

  dc.BeginDrawing();

  //dc.SetPen(*wxTRANSPARENT_PEN);
  dc.SetPen(*wxBLACK_PEN);
  wxBrush bgbrush(dc.GetBackground());
  dc.SetBrush(bgbrush);
  dc.DrawRectangle(m_DialArea.x,m_DialArea.y,
  		   m_DialArea.width,m_DialArea.height);

  if(!m_TFunc.getNumLights()) return;

  wxPen spen(wxColour(10,20,100),3,wxSOLID);
  wxBrush sbrush(wxColour(10,20,100),wxSOLID);
  dc.SetPen(spen);
  dc.SetBrush(sbrush);
  
  int radius, cx, cy;
  if(m_NLights != (int)m_TFunc.getNumLights())	// redo the shape?
  {
      m_NLights = (int)m_TFunc.getNumLights();
      radius = MIN(m_DialArea.width,m_DialArea.height)/2 - 30;
      cx = m_DialArea.x+m_DialArea.width/2;
      cy = m_DialArea.y+m_DialArea.height/2;
      for(int i=0;i<m_NLights;i++)
      {
	  float fi = i*2*M_PI/m_NLights;
	  m_LPos[i].x = (int)rint(radius*sin(fi) + cx);
	  m_LPos[i].y = (int)rint(-radius*cos(fi) + cy);
	  m_LActive[i] = true;
      }
  }

  m_CHull.clearPoints();
  for(int i=0;i<m_NLights;i++)
      if(m_LActive[i])
	  m_CHull.addPoint(i,m_LPos[i].x, m_LPos[i].y);

  m_NCHull = LDIAL_MAXLIGHTS;
  m_CHull.getCHull(m_NCHull, m_LIndices);
  for(int h=0;h<m_NCHull;h++) {
      m_HullPos[h].x = m_LPos[m_LIndices[h]].x;
      m_HullPos[h].y = m_LPos[m_LIndices[h]].y;
  }
  
  //dc.DrawPolygon(m_NLights,m_LPos);
  dc.DrawPolygon(m_NCHull,m_HullPos);
  
  wxPen lpen(wxColour(0,0,0),1,wxDOT);
  wxPen npen(wxColour(30,30,30),2,wxSOLID);
  wxBrush onbrush(wxColour(100,100,200),wxSOLID);
  wxBrush offbrush(wxColour(100,100,100),wxSOLID);
  dc.SetPen(lpen);
  
  for(int l=0;l<m_NLights;l++)
  {
      dc.SetBrush(m_LActive[l] ? onbrush : offbrush);
      int yofs = 0;
      if(!m_BulbImg) {
	  dc.DrawCircle(m_LPos[l].x,m_LPos[l].y,10);
      } else {
	  int xofs = m_BulbImg->GetWidth()/2;
	  yofs = m_BulbImg->GetHeight()/2;
	  dc.DrawBitmap( *m_BulbImg, m_LPos[l].x-xofs,m_LPos[l].y-yofs, true );
 	  if(!m_LActive[l]) {
 	    dc.SetPen(npen);
 	    dc.DrawLine(m_LPos[l].x-xofs,m_LPos[l].y-yofs,
 			m_LPos[l].x+xofs,m_LPos[l].y+yofs);
 	    dc.DrawLine(m_LPos[l].x-xofs,m_LPos[l].y+yofs,
 			m_LPos[l].x+xofs,m_LPos[l].y-yofs);
 	  }
      }
      char number[1024];
      sprintf(number,"%i", l+1);
      wxString snumber(number);
      wxCoord w,h;
      dc.GetTextExtent(snumber,&w,&h);
      dc.DrawText(snumber, m_LPos[l].x-(w/2), m_LPos[l].y-(2*yofs/3));
  }
  
  if(m_WeightX >=0 && m_WeightY>=0){
      //wxPen lpen(wxColour(240,220,10),7,wxCROSS_HATCH);
      wxPen lpen(wxColour(0,0,0),1,wxDOT);
      wxBrush lbrush(wxColour(200,200,0),wxSOLID);
      dc.SetPen(lpen);
      dc.SetBrush(lbrush);
      
      //dc.DrawPoint(m_WeightX, m_WeightY);
      //dc.DrawCheckMark(m_WeightX-5,m_WeightY-5,10,10);
      dc.DrawCircle(m_WeightX,m_WeightY,10);
      dc.SetPen(wxNullPen);
      dc.SetBrush(wxNullBrush);
  }
  
  dc.SetPen(wxNullPen);
  dc.SetBrush(wxNullBrush);
  dc.EndDrawing();
}

#if wxMINOR_VERSION < 5
void vuLightDial::OnSlideIntensity()
#else
void vuLightDial::OnSlideIntensity(wxScrollEvent& ev)
#endif
{
    float intensity = (LDIAL_SLDRES-m_LightIntensity->GetValue())
			/float(LDIAL_SLDRES)*LDIAL_INTENSITY;
    m_TFunc.setLightIntensity(intensity);
    m_TFunc.generateLight();
    
    m_IsUpdated = true;
    repaintParent();
}

#define DNORM(a,b) sqrt(double((a.x-b.x)*(a.x-b.x)+(a.y-b.y)*(a.y-b.y)))

float vuLightDial::getLj(int j, const wxPoint& x)
{
    float lj = 1;
    if(!m_LActive[j]) return 0.0;
    for(int i=0;i<m_NLights;i++)
	if(i!=j && m_LActive[i]) lj *= DNORM(x,m_LPos[i])/DNORM(m_LPos[j],m_LPos[i]);
    return lj;
}

#define RR 15
#define LR 10

void vuLightDial::OnMouseEvent(wxMouseEvent& event)
{
    int mx = (int)event.GetX();
    int my = (int)event.GetY();

    static int movlight = -1;
    
    if(event.ButtonDClick(3))
    {
	for(int j=0;j<m_NLights;j++) {
	    if(abs(m_LPos[j].x-mx) < LR &&
	       abs(m_LPos[j].y-my) < LR)
	    {
		m_LActive[j] = !m_LActive[j];
		
		reweightLights();
		
		Refresh(false);
		m_IsUpdated = true;
		repaintParent();
		break;
	    }
	}
    } else if(event.LeftIsDown())  // && event.Dragging()
    {
	if ((mx >= m_DialArea.x+RR && 
	     mx <= (m_DialArea.x + m_DialArea.width-2*RR)) &&
	    (my >= m_DialArea.y+RR && 
	     my <= (m_DialArea.y + m_DialArea.height-2*RR)))
	{
	    m_WeightX = mx;
	    m_WeightY = my;
	    
	    reweightLights();
	    
		Refresh(false);
	    m_IsUpdated = true;
	    repaintParent();
	}
	
    } else if(event.Dragging() && event.RightIsDown())
    {
	if ((movlight >=0) &&
	    (mx >= m_DialArea.x+RR && 
	     mx <= (m_DialArea.x + m_DialArea.width-2*RR)) &&
	    (my >= m_DialArea.y+RR && 
	     my <= (m_DialArea.y + m_DialArea.height-2*RR)))
	{
	    m_LPos[movlight].x = mx;
	    m_LPos[movlight].y = my;
	    m_CHull.addPoint(movlight,m_LPos[movlight].x,m_LPos[movlight].y);

	    reweightLights();

		Refresh(false);
	    m_IsUpdated = true;
	    repaintParent();
	}
    } else if(!event.Dragging() && event.RightIsDown())
    {
	movlight = -1;
	for(int j=0;j<m_NLights;j++) {
	    if(abs(m_LPos[j].x-mx) < LR &&
	       abs(m_LPos[j].y-my) < LR)
	    {
		movlight = j;
		break;
	    }
	}
    }
}

void vuLightDial::reweightLights()
{
    int nl = (int)m_TFunc.getNumLights();
    float *wl = new float[nl];
    float wlsum =0;
    
#ifdef MINDISTWEIGHTING
    int radius = MIN(m_DialArea.width,m_DialArea.height)/2 - 30;
    int cx = m_DialArea.x+m_DialArea.width/2;
    int cy = m_DialArea.y+m_DialArea.height/2;
	    
    for(int i=0;i<nl;i++)
    {
	float fi = i*2*M_PI/nl;
	int dx = (int)rint(radius*sin(fi) + cx) - mx;
	int dy = (int)rint(-radius*cos(fi) + cy) - my;
	wl[i] = dx*dx + dy*dy;
	if(wl[i] < 0.00001) wl[i] = 1000000;
	else wl[i] = 1/wl[i];
	wlsum += wl[i];
    }
	    
#else
    if(nl!=m_NLights) return;
    for(int j=0;j<nl;j++) {
	wl[j] = getLj(j,wxPoint(m_WeightX,m_WeightY));
	wlsum += wl[j];
    } 
#endif
    for(int i=0;i<nl;i++)	//normalize sum
	wl[i] /= wlsum;

    float intensity = (LDIAL_SLDRES-m_LightIntensity->GetValue())
	/float(LDIAL_SLDRES)*LDIAL_INTENSITY;
    m_TFunc.setLightIntensity(intensity);
    m_TFunc.weightLights(wl);
	    
    delete wl;
}

void vuLightDial::repaintParent()
{
    ((vuUtilityWindow*)GetParent())->notifyDataChanged();
}

//----------------------------------------------------------------------------
//----------------------------------------------------------------------------
