#include "vuStopWatch.h"

#include <wx/timer.h>

vuStopWatch::vuStopWatch (int time_in_ms)

{
	m_timer_1 = new wxStopWatch;
	m_timer_2 = new wxStopWatch;
	m_timer_3 = new wxStopWatch;

	Start (time_in_ms);

	setIsReversing (false);
	setIsRewinding (false);
	setIsFastForwarding (false);

	setIsLooping (false);
	setIsBouncing (false);
}

vuStopWatch::~vuStopWatch ()

{
	delete [] (wxStopWatch *) (m_timer_1);
	delete [] (wxStopWatch *) (m_timer_2);
	delete [] (wxStopWatch *) (m_timer_3);
}

void vuStopWatch::Start (int time_in_ms)

{
/*	m_timer_1.Resume ();
	m_timer_2.Resume ();
	m_timer_3.Resume ();

	m_timer_1.Start (time_in_ms);
	m_timer_2.Start (0);
	m_timer_3.Start (0);*/

	((wxStopWatch *) (m_timer_1))->Resume ();
	((wxStopWatch *) (m_timer_2))->Resume ();
	((wxStopWatch *) (m_timer_3))->Resume ();

	((wxStopWatch *) (m_timer_1))->Start (time_in_ms);
	((wxStopWatch *) (m_timer_2))->Start (0);
	((wxStopWatch *) (m_timer_3))->Start (0);
}

int vuStopWatch::Time ()

{
	int time1 = ((wxStopWatch *) (m_timer_1))->Time ();
	int time2 = ((wxStopWatch *) (m_timer_2))->Time ();

	if (IsReversing ())

	{
		time1 -= 2 * time2;

		if ((IsBouncing ()) && (time1 <= 0))
			setIsReversing (false);

		if ((IsLooping ()) && (time1 <= 0))
			time1 = m_maxtime;

		if (time1 < 0)
			time1 = 0;

		((wxStopWatch *) (m_timer_1))->Start (time1);
		((wxStopWatch *) (m_timer_2))->Start (0);

		return time1;
	}

	if (IsRewinding ())

	{
		time1 -= int ((getFastSpeed () + 1) * time2);

		if ((IsBouncing ()) && (time1 <= 0))

		{
			setIsRewinding (false);
			setIsFastForwarding (true);
		}

		if ((IsLooping ()) && (time1 <= 0))
			time1 = m_maxtime;

		if (time1 < 0)
			time1 = 0;

		((wxStopWatch *) (m_timer_1))->Start (time1);
		((wxStopWatch *) (m_timer_2))->Start (0);

		return time1;
	}

	if (IsFastForwarding ())

	{
		time1 += int ((getFastSpeed () - 1) * time2);

		if ((IsBouncing ()) && (time1 >= m_maxtime))

		{
			setIsRewinding (true);
			setIsFastForwarding (false);
		}

		if ((IsLooping ()) && (time1 >= m_maxtime))
			time1 = 0;

		if (time1 >= getMaxTime ())
			time1 = getMaxTime ();

		((wxStopWatch *) (m_timer_1))->Start (time1);
		((wxStopWatch *) (m_timer_2))->Start (0);

		return time1;
	}

	if ((IsBouncing ()) && (time1 >= getMaxTime ()))

	{
		setIsReversing (true);

		time1 = getMaxTime ();
	}

	if ((IsLooping ()) && (time1 >= getMaxTime ()))

	{
		time1 = 0;
	}

	if (time1 > getMaxTime ())
		time1 = getMaxTime ();

	((wxStopWatch *) (m_timer_1))->Start (time1);
	((wxStopWatch *) (m_timer_2))->Start (0);

	return time1;

/*	int time1 = m_timer_1.Time ();
	int time2 = m_timer_2.Time ();

	if (IsReversing ())

	{
		time1 -= 2 * time2;

		if ((IsBouncing ()) && (time1 <= 0))
			setIsReversing (false);

		if ((IsLooping ()) && (time1 <= 0))
			time1 = m_maxtime;

		if (time1 < 0)
			time1 = 0;

		m_timer_1.Start (time1);
		m_timer_2.Start (0);

		return time1;
	}

	if (IsRewinding ())

	{
		time1 -= int ((getFastSpeed () + 1) * time2);

		if ((IsBouncing ()) && (time1 <= 0))

		{
			setIsRewinding (false);
			setIsFastForwarding (true);
		}

		if ((IsLooping ()) && (time1 <= 0))
			time1 = m_maxtime;

		if (time1 < 0)
			time1 = 0;

		m_timer_1.Start (time1);
		m_timer_2.Start (0);

		return time1;
	}

	if (IsFastForwarding ())

	{
		time1 += int ((getFastSpeed () - 1) * time2);

		if ((IsBouncing ()) && (time1 >= m_maxtime))

		{
			setIsRewinding (true);
			setIsFastForwarding (false);
		}

		if ((IsLooping ()) && (time1 >= m_maxtime))
			time1 = 0;

		if (time1 >= getMaxTime ())
			time1 = getMaxTime ();

		m_timer_1.Start (time1);
		m_timer_2.Start (0);

		return time1;
	}

	if ((IsBouncing ()) && (time1 >= getMaxTime ()))

	{
		setIsReversing (true);

		time1 = getMaxTime ();
	}

	if ((IsLooping ()) && (time1 >= getMaxTime ()))

	{
		time1 = 0;
	}

	if (time1 > getMaxTime ())
		time1 = getMaxTime ();

	m_timer_1.Start (time1);
	m_timer_2.Start (0);

	return time1;*/
}

void vuStopWatch::Pause ()

{
	((wxStopWatch *) (m_timer_1))->Pause ();
	((wxStopWatch *) (m_timer_2))->Pause ();

//	m_timer_1.Pause ();
//	m_timer_2.Pause ();
}

void vuStopWatch::Resume ()

{
	((wxStopWatch *) (m_timer_1))->Resume ();
	((wxStopWatch *) (m_timer_2))->Resume ();

//	m_timer_1.Resume ();
//	m_timer_2.Resume ();
}

int vuStopWatch::TotalTime ()

{
	return ((wxStopWatch *) (m_timer_3))->Time ();

//	return m_timer_3.Time ();
}

void vuStopWatch::setIsReversing (bool isit)

{
//	cout << "setting reversing" << endl;
//	cout << "maxtime:" << m_maxtime << endl;

	mb_reversing = isit;

	if (isit)

	{
		setIsRewinding (false);
		setIsFastForwarding (false);
	}

	((wxStopWatch *) (m_timer_2))->Start (0);

//	m_timer_2.Start (0);
}

#include <stdlib.h>

void vuStopWatch::setIsRewinding (bool isit)

{
//	cout << "setting rewinding" << endl;

//	exit (0);

	mb_rewinding = isit;

	if (isit)

	{
		setIsReversing (false);
		setIsFastForwarding (false);
	}

	((wxStopWatch *) (m_timer_2))->Start (0);

//	m_timer_2.Start (0);
}

void vuStopWatch::setIsFastForwarding (bool isit)

{
	mb_fastforwarding = isit;

	if (isit)

	{
		setIsReversing (false);
		setIsRewinding (false);
	}

	((wxStopWatch *) (m_timer_2))->Start (0);

//	m_timer_2.Start (0);
}

void vuStopWatch::setIsLooping (bool isit)

{
	mb_looping = isit;

	if (isit)
		setIsBouncing (false);
}

void vuStopWatch::setIsBouncing (bool isit)

{
	mb_bouncing = isit;

	if (isit)
		setIsLooping (false);
}

bool vuStopWatch::IsReversing ()

{
	return mb_reversing;
}

bool vuStopWatch::IsRewinding ()

{
	return mb_rewinding;
}

bool vuStopWatch::IsFastForwarding ()

{
	return mb_fastforwarding;
}

bool vuStopWatch::IsLooping ()

{
	return mb_looping;
}

bool vuStopWatch::IsBouncing ()

{
	return mb_bouncing;
}

void vuStopWatch::setFastSpeed (float mul)

{
	m_fastspeed = mul;
}

float vuStopWatch::getFastSpeed ()

{
	return m_fastspeed;
}

void vuStopWatch::setMaxTime (int maxtime)

{
	m_maxtime = maxtime;

//	cout << "max_timer = " << m_maxtime << ' ' << Time ();

//	if (IsBouncing ()) cout << " bouncing:" << endl;
}

int vuStopWatch::getMaxTime ()

{
	return m_maxtime;
}






