/* 	This is the key frame animator for vuVolume which
	Will allow for easy and quick animations to be
	generated for any method.

	This hooks in through vuBasicUtility, and requires
	that certain functions be overridden (such as getcamera,
	get image and set image, etc...)

	Written by Christopher Steinbach
	Mar 2002

	Added some comments in June 2002.
*/

#ifndef _vuKeyFramerDialog_h_
#define _vuKeyFramerDialog_h_

#include <wx/wx.h>
#include "vuCamera.h"
#include "vuDVector.h"
#include "vuEvtGenerator.h"
#include "vuHWTimer.h"
#include "vuImage.h"

//#include "vuKFThread.h"
#include "vuPerspectiveCamera.h"
#include "vuParallelCamera.h"
#include "vuPPMReader.h"
#include "vuStopWatch.h"
#include "vuThread.h"
#include "../../vuUtilityWindow.h"
#include "vuVector.h"

#include "../../wxUtilities/vuBasicUtility.h"
#include "../vuTransferCanvas.h"

#include <fcntl.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include <sys/types.h>
#include <sys/stat.h>

#include <wx/bmpbuttn.h>
#include <wx/dialog.h>
#include <wx/filedlg.h>
#include <wx/msgdlg.h>
#include <wx/panel.h>
#include <wx/stattext.h>
#include <wx/textctrl.h>
#include <wx/timer.h>
#include <wx/wx.h>


#include <wx/mdi.h>

#ifndef wxCHILDWINDOW
#define wxCHILDWINDOW wxMDIChildFrame
#endif


/*	Interrupt delay for play control to allow for
	pauses and stops to take effect.

	This play back will work in two modes,
	burst mode as fast as possible and in time.

	In order to allow for pausing and stopping a play, I
	need to release control of the process in the play
	mechanism so that hitting the stop button or start button
	will take effect.  In order to accomplish this,
	I will use an event generator which will go for a second
	and then return control to my process when the delay has
	passed.

	Therefore this delay is the length of time that the
	process will wait for stops and whatnot to occur
	so that they user is not foraced to wait through an entire
	animation and can stop it easily.

	NB, this time is in milliseconds

	NB, this is no longer in use as I am trying to use separate
	threads so that pause, stop, rewind, etc can take effect at any time.
*/

#define vuKF_play_delay 20

/* 	This is how long the process should stay paused for before
	attempting to start up again.
*/

#define vuKF_regular_pause_delay 100

/* 	This next define is simlar to the previoius define, except
	That is is for records... should be a bit longer...

	NB, this time is in milliseconds...

	NB, this should be gone too...
*/

#define vuKF_regular_record_delay 100

/* 	This is the directory where the key frame animator save
	files are stored by default...  This is as good a place as
	any...  though it might be good to change this to something like

	"proj/KeyFramesSaved/KFS"...
	"proj/KeyFramesSaved/Anis"...
*/

#define vuKF_default_keyframe_save_dir_ "./wxUIElements/vuKeyFramerDialog/KeyFramesSaved/"

/*	This is the the default message that the file dialog boxes
	will use within the key frame animator dialog...
*/

#define vuKF_default_vuKFFileDlg_msg_ "Select A Key Frame Animation file"

/* 	These are the number of digits of precision that floating point numbers
	should be shown with. */
#define vuKF_precision_digits 8

/* 	This message prefixes the frame rate that is shown when a frame rate is displayed */
#define vuKF_default_fm_rate_msg_ "Frame Rate: "

/* 	This message is the prefix for the total number of frames that should be displayed */
#define vuKF_frames_played_msg_ "Total Frames Played: "

/* 	This is the default extension that cameras will be written
	to with time... the * is to allow for all formatting to
	make life easier surrounding the wxFileDialogs for loading
	and recording...
*/
#define vuKF_default_recorded_ext_ "*.vut"

/*	This is the default extension that animation files will be
	written to.  So far, it consists of an index file
	which is of the format [time], [frame.ppm]\n

	everything is ascii so far.
*/
#define vuKF_default_animated_ext_ "*.vua"

/* 	This is the message that will preface the messages that
	will tell the user which file is currently open (for
	both the key frame and the video sections
*/
#define vuKF_default_curr_loaded_msg "Currently Loaded: "

/*	This is the message which by default prefixes any display of the ammount
	of time that it took to render a file */
#define vuKF_render_time_msg "Render Time: "

/*	This is the message which by default prefixes any display of the status
	of the key frame animator */
#define vuKF_status_msg "Status: "

/* 	This is the factor of speed that a rewind or a fastforward will
	be run at (1 is normal speed, 2 is twice as fast as normal, etc).
*/
#define vuKF_spd_mul 4

/*	This is the message that will be displayed for the bounce function
	and the Bounce mode of the key framer playback.

	Change this definition to whatever you want to call loop.
*/
#define vuKF_bounce_msg "Bounce"

/*	This is the message that will be displayed for the loop function and the
	Loop mode of the Key framer.

	Change this definition to be whatever you want to call loop.
*/
#define vuKF_loop_msg "Loop"

/*	This is the default prefix of the frame rate. */

#define vuKF_frame_rate_msg "Frame Rate: "

/* 	this is to prevent a circular include condition in these
	two files because I need to be able to communicate
	back and forth between the two classes...  ie, I need to
	be able to set the camera and render the scene in the
	Utility window from the key frame animator, and I need
	to be able to start up the key frame animator from the
	Utility window (like the raycaster gui, splatter gui, etc).

	The GUI must at least initiate the animator, and it must
	at least control the renderer so that it can change camera
	positions, transfer functions, etc and re-render.  Since
	these capabilities exist, I think that I am simply going
	to use it to render and ignore the volume tree element.
*/

class vuBasicUtility;

/*	The event generator is a class which is specifically
	designed to call an event at a regular interval (ie,
	like a redraw).

	It is derived from the base class of wxTimer and will
	call a specific function when it wants to.  This will
	allow for breaks so that play can be paused or stop
	(except during burst play, which will not tolerate breaks
	so that the time can be acurately and properely assessed).
*/

class vuEvtGenerator;
//class vuKFThread;

class vuKeyFramerDialog;
//typedef vuKeyFramerDialog vuKeyFramerDialog;

/**	This is the Key Frame Animator for the vuVolume class.

	By simply overriding a few functions in vuBasicUtility, and
	using the standard vuVolumeFramework, it will be simple for
	any method added to vuVolume to interface with this class.

	This class will allow the user to double right click on the utility
	that he/she is using to display a volume.

	From this, the KeyFramer will pop up, allowing the user to record
	to a file certain key frames, along with their associated times.

	Then, the user will be able to generate animations that will
	inerpolate the camera to work out the current camera position and
	store those animations to disk

	Then, the user will be able to play those animations in time.

	The user will also be able to play the animations in time without
	prerendering.

	This will allow the user to perform direct time comparisons between
	two method on the same test run so long as they use the same
	type of camera.

	NB - The prerendered video uses different functions than the key
	frame portion, whenever you are using any function, make sure that
	you are using the appropriate one (ie, use the prerendered video version
	of a play to play rather than the other one).

	This animator plays as follows (since threads won't work without design changes
	to vuVolume or to wxWindows, this is how it has to be).

	Play_initialize ();

	while (there is a next frame to play)
		Play_next_frame ();
		wait for a while so that other events can be processed ().
	end while

	Note that fastforwarding and rewinding work by:

		starting a timer
		reading the timer every so often
		adding or subtracting vuKF_spd_mul * time going to the time of the play
		reseting the timer, starting this process again

	\todo add a scroll bar and the capabilities to edit a key frame file
		such as add, move or delete key frames...
	\todo add capabilities for the user to place a frame to a different time
	\todo add the capabilities to display icons in place of the animation
	\todo thread the process to make it run more smoothly (ie, thead
		the plays so that the screen and controls are occasionally updated
		everything is set up correctly to do so through vuThread.
		currently, the limiting factor is that you will get asynchronous
		XLib errors if you try to do this.  There needs to be some sort of
		locking (which wxwindows has to use) before this will work properely.
		This will have to use XInitThreads () and XLockDisplay, etc...
		It works without this, but it'd work better with it.
	\todo add better file type to read from for animation (like avi's or mpegs...
		ppm is just too large for big animations and too slow for high frame rates.).
		300 by 500 is about the largest we can reasonably get on a fast
		machine with the PPM method...  The I/O is just too slow for much larger
		sets.
	\todo change the method of instanstiation to something that is consistent with the lighter.
*/

//class vuKeyFramerDialog : public wxDialog, public vuThread
class vuKeyFramerDialog : public wxFrame, public vuThread
//class vuKeyFramerDialog : public wxWindow, public vuThread
//class vuKeyFramerDialog : public wxCHILDWINDOW, public vuThread
//class vuKeyFramerDialog : public vuUtilityWindow, public vuThread
//class vuKeyFramerDialog : public vuBasicUtility, public vuThread

{
//    friend class vuKFThread;

	/** This class will generate the timer events and will call the event handler in
		this class */
	friend class vuEvtGenerator;

 public:

 	//! these are the identifiers associated with each even in this object.
    enum
	{
	    idAUTOSHOT = 1001,
	    idCANVAS,
	    idBURSTPLAY,
	    idCLOSE,
	    idFASTFORWARD,
	    idGENIMAGES,
	    idKFBOUNCE,
	    idKFLOOP,
	    idKFSELECT,
	    idLOAD,
	    idPAUSE,
	    idPLAY,
	    idPLAYFROMIMAGES,
	    idRECORD,
	    idREWIND,
	    idSAVE,
	    idSCROLLER,
	    idSTOP,
	    idTAKESHOT,
	    idVIDBOUNCE,
	    idVIDCLOSE,
	    idVIDFASTFORWARD,
	    idVIDLOOP,
	    idVIDLOAD,
	    idVIDPAUSE,
	    idVIDPLAY,
	    idVIDREWIND,
	    idVIDSELECT,
	    idVIDSTOP
	};

  public:

    /** Default constructor,

    	This will set the parent of this window to be parent.

	This will set the camera that this is to operate on (read from, write to)
	to be the camera pointed to by NULL (vuPerspective, vuParallel, etc...).

	This will treat UWin as the calling GUI (ie, it'll make it's changes to UWin);
    */

    vuKeyFramerDialog(wxWindow *parent = NULL, vuCamera *cam = NULL, vuBasicUtility *UWin = NULL);

    /** destructor */

    virtual ~vuKeyFramerDialog ();

    /**  This will set the camera that this utility operates on to be the one pointed
         to be cam, and the parent Gui to be UWin

	 This way, you can change the camera that this will operate upon.
    */

    void setup (vuCamera *cam, vuBasicUtility *UWin);

    virtual void Close ();

    virtual bool Destroy ();

  public:	// get state functions - these will return the state of the animator

    /** This returns true if there is a key frame animation that is playing and is
    	being fastforwarded.

	Otherwise, this returns false.

	NB, this only applies to key frames, not prerendered videos, it says nothing
	about whether or not a prerendered video is playing and fastforwarding */
    bool IsFastForwarding ();

    /** This returns true if the animator has a video file loaded into memory that it
    	can play from, otherwise it returns false */
    bool IsImgsLoaded ();

    /** This returns true if the key frame animation that is currently playing (or
        would be playing if one were started) is bouncing.

	This returns false otherwise.

	Bouncing means that when the animation reaches either end in time (either
	the maximum or the minimum time that it is allowed to be at), then it will
	reverse direction and play in the reverse direction. */
    bool IsKFBouncing ();

    /** This returns true if the key frame animation that is currently playing (
        or would be playing if one were started) is looping.

	This returns false otherwise.

	Looping means that when the time of the animation reaches either end of the
	time scale associated with the animation, the current time is set to the
	other end, and the animation will continue playing. */
    bool IsKFLooping ();

    /** This return true if the key frame animation that is currently playing (or
        would be playing if one were started) is reversing.

	This returns false otherwise.

        reversing means that it is travelling backwards in time at the regular speed. */
    bool IsKFReversing ();

    /** This returns true if the animator has a key frame file loaded into memory that
    	it can play from, otherwise, it returns false */
    bool IsLoaded ();

    /** This returns true if the animator is not currently paused while playing back
        an animation, and returns false otherwise */
    bool IsPaused ();

    /** This returns true if the animator is currently playing back an animation
    	(if this animation is being played from key frames, but not prerendered
	video), and returns false otherwise */
    bool IsPlaying ();

    /** This returns true if the animator is currently playing an animation from
    	prerendered videos, and returns false otherwise */
    bool IsPlayingImgs ();

    /** This returns true if the animator is currently recording an animation
    	(that is, it's recording key frames to a key frame file),
        false otherwise */
    bool IsRecording ();

    /** This returns true if the animator is currently rewinding through a
        key framed animation, otherwise it returns false

	NB, this returns false if the prerendered video part is rewinding, please note
	the distinction between the two different rewinds. */
    bool IsRewinding ();

    /** This returns true if the animator is stopped (the key frames, not the
    	prerendered video), but it may return false if it is not playing something...
     	and returns false otherwise */
    bool IsStopped ();

    /** This returns true if the animation that is currently playing is bouncing (or
        would be bouncing if one were to be started).

	This returns false otherwise.

	Bouncing means that when the time reaches either ot the time extremes, it
	reverses direction and continues playing.

	Note that this is different than IsKFBouncing ().
	*/
    bool IsVideoBouncing ();

    /** This returns true if the animator is currently fastforwarding through a
        prerendered video animation, and returns false otherwise.

	NB, this may return false if a key frame file is loaded and is being played,
	and is fastworded since there is a difference between key frame and prerendered*/
    bool IsVideoFastForwarding ();

    /** This returns true if the animator is currently looping it's plays of
        prerendered video animations, and returns false otherwise.

	Looping means that when the animation reaches one time extreme, the time
	is adjusted to be as if it were at the other and the animation continues
	(ie, it repeats what it's been playing).

	Note, this says nothing about what the key frames are doing.*/
    bool IsVideoLooping ();

    /** This returns true if the animator is playing a prerendered video and that video
        is paused, and will return false otherwise (NB, there is a distinction between
	this and IsPaused, namely the latter is on key frames, and the former is
	pregenerated). */
    bool IsVideoPaused ();

    /** This returns true if there is a video playing, and false otherwise.

        Note that this is different than if a key frame is playing, since they are
	two different things */
    bool IsVideoPlaying ();

    /** This returns true if there is a video playing in reverse direction at the
        normal speed of play, and false otherwise.

	Note that this is different that IsKFReversing ()*/
    bool IsVideoReversing ();

    /** This returns true if there is a video rewinding and false otherwise.

        Note that this is different that is a key frame is rewinding, since they are two
	different processes */
    bool IsVideoRewinding ();

  public:

    /** This function is the entry point for any threads through vuThread
    	(so that it can run independently, and other stuff can be given time
	to run, like the event handlers so that the user can tell this to
	stop) */
    virtual void run(int whatsup, void* data);

  protected:	// these are the functions that can set the states of
  		// the key frame animator and the prerendered animator

    /** This function sets the return of IsFastForwarding () to be isit
        (ie, this sets the state of the KeyFramer Video FastForwarding to be
	isit). */
    void setIsFastForwarding (bool isit);

	/** This function sets the state {is prerendered images loaded} to be
		the same value as isit.

		ie, the will set the return value of IsImgsLoaded to be isit. */
    void setIsImgsLoaded (bool isit);

    /** This function sets the state of of the Key Frame Bouncing in an animation to be
        The same value as isit.

	ie, this will set the return value of IsKFBouncing to be isit. */
    void setIsKFBouncing (bool isit);

    /** This function sets the state of of the Key frame Looping in an animation to be
        The same value as isit.

	ie, this will set the return value of IsKFLooping to be isit. */
    void setIsKFLooping (bool isit);

    /** This function sets the state of of the KF Reversng in an animation to be
        The same value as isit.

	ie, this will set the return value of IsKFReversing to be isit. */
    void setIsKFReversing (bool isit);

    	/** This function sets the state of a key frame file loaded to be the
		same value as isit.

		ie, the will set the return value of IsLoaded to be isit.  */
    void setIsLoaded (bool isit);

    	/** This function sets the state of a key frame file being paused
		to be the same value as isit.

		ie, the will set the return value of IsPaused to be isit.  */
    void setIsPaused (bool isit);

    	/** This function sets the state of a key frame file being played
		 to be the same value as isit.

		ie, the will set the return value of IsPlaying to be isit.  */
    void setIsPlaying (bool isit);

    	/** This function sets the state of a prerendered animation file loaded
		to be the same value as isit.

		ie, the will set the return value of IsPlayingImgs to be isit.  */
    void setIsPlayingImgs (bool isit);

    	/** This function sets the state of a key frame file being recorded to
		to be the same value as isit.

		ie, the will set the return value of IsRecording to be isit.  */
    void setIsRecording (bool isit);

    /** This function set the state of key frame rewinding to be the same value as
        isit

        is, this will set the return value of IsRewinding to isit.

	Note that this is different than setIsVideoRewinding */
    void setIsRewinding (bool isit);

    	/** This function sets the state of a key frame file being stopped to
		to be the same value as isit.

		ie, the will set the return value of IsStopped to be isit.  */
    void setIsStopped (bool isit);

    /** This function sets the state of of the Video Bouncing in an animation to be
        The same value as isit.

	ie, this will set the reutrn value of IsVideoBouncing to be isit. */
    void setIsVideoBouncing (bool isit);

    /** This function will set the state of Video Fast Forwarding to be the same
        value as isit...

	ie, this will set the return value of IsVideoFastForwarding to be isit.

	note that this is different than setIsFastForwarding (bool isit); */
    void setIsVideoFastForwarding (bool isit);

    /** This function sets the state of of the Video Looping in an animation to be
        The same value as isit.

	ie, this will set the reutrn value of IsVideoLooping to be isit. */
    void setIsVideoLooping (bool isit);

    /** This function will set the state of Video Paused to be the same value as isit.

        ie, this will set the return value of IsVideoPaused to be isit

	note that this is different than setIsPaused (bool isit); */
    void setIsVideoPaused (bool isit);

    /** This function will set the state of Video Playing to be the same value as isit

        ie, this will set the return value of IsVideoPlaying to be isit.

	note that this is different than setIsPlaying (bool isit) */
    void setIsVideoPlaying (bool isit);

    /** This function sets the state of of the Video Reversing in an animation to be
        The same value as isit.

	ie, this will set the reutrn value of IsVideoReversing to be isit. */
    void setIsVideoReversing (bool isit);

    /** This function will set the state of Video Rewinding to be the same value as isit

        ie, this will set the return value of IsVideoRewinding to be isit.

	note that this is different than setIsRewinding (bool isit). */
    void setIsVideoRewinding (bool isit);

  protected:	// event handling functions
  		// ........................
		// These will be the functions that will handle the
		// various events that wxWindows needs to handle.

    /**  This function will be called every time a timer event occurs

	ie, if when the animator is playing back a series of pregenerated images, and
	the animator has a break, then the animator will hold pending the timer
	interrupt going off, and this function will return it to where it should be.

	This may not be implemented as it generates frames without control from the user...
    */
    void OnAutoShot(wxCommandEvent &ev);

    /** This function will close the key frame file that has currently been loaded
    	or is currently being recorded to.

	It will not save a key frame file that is being recorded to... but it will
	prompt the user to find out if he/she wishes to save it, and if so, will
	instead go to OnSave to close it*/
    void OnClose (wxCommandEvent &ev);

    /** This code will be called when a key frame file is playing and the fast forward
        button has been pressed.

	Note that this will have no effect if the file is already being rewound.

	If the animation is already fast forwarding, then this will return the
	animation to regular speed. */
    void OnFastForward (wxCommandEvent &ev);

    /** This code will be called whenever the user chagnes the Key Frame side's
        Bounce check box.

	This will set stop key frame looping when this is checked. */
    void OnKFBounce (wxCommandEvent &ev);

    /** This code will be called whenever the user chagnes the Key Frame side's
        Loop check box.

	This will set stop key frame bouncing when this is checked. */
    void OnKFLoop (wxCommandEvent &ev);

    void OnKFSelect (wxCommandEvent &ev);

    /** This Function will be called when the Key Frame load button is pressed

    	This will not allow to load another file when another
	is already opened by OnLoad or OnRecord.

	This loads vuKeyFrame descriptions...*/
    void OnLoad(wxCommandEvent &ev);

    /** This function will be called when the Key Frame pause button is pressed.

    	This will Pause the key frame animation that is currently being played

	This will not pause any prerendered animation that is being played.

	This will need threads to be properely working before it works.*/
    void OnPause(wxCommandEvent &ev);

    /** This function will be called when the Key Frame play button has been pressed.

    	This will Play the Key Frame Animation that is currently loaded.

	If no Key frame animation has been loaded, then it will also load one
	after getting the user to specify which file.

	This will not play any prerendered video that has been loaded.

	This will not play while any prerendered video is playing.

	If "Save Animation" has been selected by the user, generate the images
	at a frame rate of "frame rate" and save this animation to a video file,
	so that it may be played back later.

	If "Max Speed/KeyFrames Only" has been selected by the user, this will
	only play the key frames and will play everyone of the key frames.

	This will also output the total render time of the operation to "Render Time:"
	so that the user can compare with other times of other methods on the same
	animation (if they use the same camera of course). */
    void OnPlay(wxCommandEvent &ev);

    /** This function will be called when the video play button has been pressed.

    	This will Play the prerendered video that has is currently loaded.

	If no prerendered video has been loaded, then this will load one after
	prompting the user to specify which one should be loaded.

	This will not play and key frame files are playing. */
    void OnPlayFromImages(wxCommandEvent &ev);

    /** This function will be called when the key frame record button has
    	been pressed.

	This will prompt the user for a file to record to, and will record
	a Key frame sequence to the specified file.

	This will not record while another key frame file has been loaded.

	This will not record while another key frame file is being recorded to.*/
    void OnRecord (wxCommandEvent &ev);

    /** This code will be called when the key frame rewind button has been pressed
        It will start rewinding the playing animation when it is pressed.

	If the animation is already rewinding, then this will set the speed back to
	normal and the direction back to normal too.

	If no animation is playing, this will have no effect.*/
    void OnRewind (wxCommandEvent &ev);

    /** This function will be called when the key frame record button has been pressed.

    	This will save and close the key frame file that has currently been loaded. */
    void OnSave (wxCommandEvent &ev);

    /** This function will be called when the key frame stop button has been pressed.

    	This will stop and close the currently loaded or playing key frame file. */
    void OnStop (wxCommandEvent &ev);

    /** This function will be called when the Key frame take shot button has been pressed.

    	This will add the current frame to the list of frames to be recorded.

	This will add it to the list of those scheduled to be saved.

	The timestamp will be that of since you started recording

	This will have no effect except when you are recording a key frame file.*/
    void OnTakeShot (wxCommandEvent &ev);

    /** This code will be called whenever the user chagnes the Video side's
        Bounce check box.

	This will set stop video looping when this is checked. */
    void OnVideoBounce (wxCommandEvent &ev);

    /** This function will be called when the video Close button has been pressed.

    	This will close the currently loaded animation file.*/
    void OnVideoClose (wxCommandEvent &ev);		/**< this is the other of the two cameras that will
    						be used by the PlayInTime () method
						to interpolate between key frames

						This is stored here so that I don't have
						to allocate new cameras everytime (as
						would be the case if I stored them locally)*/

    /** This function will be called when the video fast forward button has been pressed.

        If a video is playing, this will start fast forwarding.
	If the video is already fast forwarding, this will return it to normal speed. */
    void OnVideoFastForward (wxCommandEvent &ev);

    /** This function will be called when the video Load button has been pressed.

    	This open a video file to be played, as long as no other video file is currently
	loaded. */
    void OnVideoLoad (wxCommandEvent &ev);

    /** This code will be called whenever the user changes the Video side's
        loop check box.

	This will set stop video bouncing when this is checked. */
    void OnVideoLoop (wxCommandEvent &ev);

    /** This function will be called when the video pause button has been pressed.

    	This will pause the video that is playing.

	Currently, this has no effect since threads are not working properely. */
    void OnVideoPause (wxCommandEvent &ev);

    /** This function will be called when the video play button has been pressed.

    	This will play the video that has been loaded.

	If no video is currently loaded, then this will prompt the user to provide
	a video to load and will play that. */
    void OnVideoPlay (wxCommandEvent &ev);

    void OnVideoReverse (wxCommandEvent &ev);

    /** This function will be called when the video Rewind button has been pressed.

        If a video is currently playing, this will start the video rewinding.

	If the video is already rewinding, it will stop the rewinding and return
	the play to normal speed and direction.

	On all other cases, this will have no effect */
    void OnVideoRewind (wxCommandEvent &ev);

    void OnVideoSelect (wxCommandEvent &ev);

    /** This function will be called when the video stop button has been pressed.

    	This will stop the video that is playing.

	If no video is currently playing, this will have no effect. */
    void OnVideoStop (wxCommandEvent &ev);

 protected:	// these are the main functions that will perform the load,
 		// play, stop and record functions of the key frame animator.

    /** This will play every key frame in order as fast as the computer can */
    void BurstPlay ();

    /** This will play every key fram in order as fast as the computer can

    	This will also record the images to a file that the user will provide
	when  prompted.*/
    void BurstPlayGI ();

    /** This will load key frame animation files after prompting the user
    	to specify which one to load. */
    void LoadFunc ();

    /** This will play back a prerendered video inside the method. */
    void PlayFromImages (bool fromevttimer = false);

    /** This will play an animation from key frame files, and will load

	The animation if necessary.*/
    void PlayFunc ();

    /** This will play an animation from key frame files, and will do so with

    	Interpolation in real time */
    void PlayInTime ();

    /** This will play the next frame of a key frame animation...
        It will interpolated if the curent time indicates that it is between frames.

	 It will then set off a timer interrupt if it needs to play again, and will wait
	 for vuKF_play_delay milliseconds before playing the next image.*/
    void PlayNextFrame ();

    /** This will play the next frame of a prerendered video file.

        When it is done, it will initialize a timer to wait for, and when the timer
	goes off, it will play itself again. */
    void PlayNextImage ();

    /** This will start recording an animation of key frame files */
    void RecordFunc ();

    /** This was for automatic snap shots, but I don't think that I'll use it
    	yet... not really necessary, see the discussion on autoahots... */
    void RecordInTime ();

    /** This will save a key frame animation file.  If write changes is false, it will
    	not update the file... It's strange, but I did it for the recordings...*/
    void SaveFunc (bool writechanges = false);

 protected:	// some of these were required for wxWindows...

    /** Add the sliders for the light sources.
       This function is called after a new transfer function is loaded. */
    virtual void buildCustomSizer() {};
    /** Calls buildCustomSizer and refreshes Layout of the dialog. */
    void rebuildCustomSizer();
    //!Part of the wxWindows architecture -- there is no data to transfer
    bool TransferDataFromWindow() {return true;};
    //!Part of the wxWindows architecture -- there is no data to transfer.
    bool TransferDataToWindow() {return true;};

  protected:	// helper functions.

    /** This will perform a bisection search on the list of times to find time (it
    	will only look between start and finish).*/
    int bisect_time_vector_search (float time, int start, int finish);

    /**	This will clear the camera and time lists */
    void clear_vectors ();

    /** This will return a frame value given time.

    	frame may be a float which will indicate how much to interpolate between
	two other frames */
    float get_frame_number (float time);

    /** This will open an animation file (video).  It will open for writing if
    	write is true, and will set it to false otherwise */
    FILE* OpenGIFile (bool write = false);

    /** This function will be called when a timer event occurs

        This function will process the timer event and from there
	call the function that should be called when the event has completed.*/
    void TimerEvent ();

  protected: // wxobjects... this is the member data, these are the sizers
    wxBoxSizer *m_CustomSizer; 	//!< This can probably go.
    wxBoxSizer *m_MainSizer;	//!< This is the main screen that will be written to by this dialog

  protected: // wxObjects, these are the buttons that will appear on the screen
    wxButton *m_close;		//!< This is the key frame close button
    wxBitmapButton *m_fastforward;	//!< This is the key frame fast forward button
    wxButton *m_load;		//!< This is the key frame load button
    wxBitmapButton *m_pause;		//!< This is the key frame pause button
    wxBitmapButton *m_play;		//!< This is the key frame play button
    wxButton *m_playfromimages;	//!< This is the video play button
    wxBitmapButton *m_record;		//!< This is the key frame record button
    wxBitmapButton *m_rewind;		//!< This is the key frame rewind button
    wxButton *m_save;		//!< This is the key frame save button
    wxBitmapButton *m_stop;		//!< This is the key frame stop button
    wxButton *m_takeshot;	//!< This is the key frame take snap shot button
    wxButton *m_vid_close;	//!< This is the video close button
    wxButton *m_vid_fastforward;//!< This is the video fast forward button
    wxButton *m_vid_load;	//!< This is the video load button
    wxButton *m_vid_pause;	//!< This is the video pause button
    wxButton *m_vid_play;	//!< This is the video play button
    wxButton *m_vid_rewind;	//!< This is the video rewind button
    wxButton *m_vid_stop;	//!< This is the video stop button

  protected: // wxObjects, these are the checkboxes that will appear on the screen.
    wxCheckBox *m_autoshot;	//!< This is the checkbox to select if snapshots should be taken automatically
    wxCheckBox *m_burstplay;	/**< This is the checkbox to select if the key frame animator should play only key frames
    					and do so as fast as it can. */
    wxCheckBox *m_genimages;	//!< This is the checkbox to select if a video should be generated of the animation.
    wxCheckBox *m_kf_bounce;	/**< This is the checkbox that will be selected if the
    					key framer should bounce on it's animations. */
    wxCheckBox *m_kf_loop;	/**< This is the checkbox that will be selected if the
    					key framer should loop on it's animations. */
    wxCheckBox *m_vid_bounce;	/**< This is the checkbox that will be selected if the
    					video portion of the animator should bounce while
					playing it's animations. */
    wxCheckBox *m_vid_loop;	/**< This is the checkbox that should be selected if the
    					video portion of the animator should loop while
					playing it's animations. */

  protected: // wxobjects, these are the dividers and panels that will appear on the screen
    wxPanel *m_divider;		//!< This is the dividing line on the screen between key frame handling and video handling
    wxPanel *m_divider2;		//!< This is the dividing line on the screen between key frame handling and video handling

  protected: // wxobjects, these are the text boxes that will appear on the screen that the user can type into.
    wxTextCtrl *m_time_final;	//!< This is dormant for now, this is the end time of the set.
    wxTextCtrl *m_time_delay;	/**< This is the time delay with which an animation will be generated
    					ie, if m_time_delay contains the text 0.03 it will generate
					33 images per second of animation time in the video file (so that the
					video can play back at 33 frames per second). */

  protected: // wxobjects, this is for later, it's a scrollbar that will allow the user to
             // select what time he wishes to be at.
    wxScrollBar *m_scroller;	/**< This is a scroll bar to be used later on when full
  					editing capabilities are added to this key framer

					(The scrollbar would be used to select the frame
					at the time where the | represents the bar, and
					the f's represent frames at specific times...

							|
							|
						f	|f	   f     f
							|
					====================================

					This way a frame could be selected easily be the user,
					dragged and moved into the correct time. */

  protected: // wxobjects, these are the labels that the keyframer will display information on
    wxStaticText *m_fm_rate;	/**< This is where the frame rate text identifier is stored
    					(This will tell the user that the corresponding text
					 box is where he inputs the frame rate */

    wxStaticText *m_frames_played_txt;	/**< This will display the number of frames that
    						have been played in the key frame
						portion of the animator. */
    wxCheckBox *m_kf_txt;		/**< This displays the title of the key frame
    						handling section of the animator */
    wxStaticText *m_kf_status_txt;	/**< This displays the status of the key frame
    						handling section of the animator
						(ie, playing, paused, fastforwarding,
						rewinding, etc). */
    wxStaticText *m_fm_rate_txt;	/**< This displays the frame rate of the key frame
    						handling section of the animator */
    wxStaticText *m_loaded_txt;		/**< This displays the name of the key frame file that
    						has been loaded into the key frame
						handling section of the animator. */
    wxStaticText *m_total_time;		/**< This displays the total time taken to
    						render the scenes to the screen*/
    wxStaticText *m_vid_fm_rate_txt;	/**< This displays the frame rate that a video
    						play back is achieving */
    wxStaticText *m_vid_frames_played_txt;	/**< This displays the number of frames
    							that have been played by the
							video side of the animator in the
							current operation. */
    wxStaticText *m_vid_loaded_txt;	/**< This displays which video is currently loaded
    						and can be played. */
    wxStaticText *m_vid_status_txt;	/**< This displays what the status of the video
    						player (ie, is it playing, paused,
						fastforwarding, etc...). */
    wxStaticText *m_vid_total_time_txt;	/**< This displays the total time the video has
    						spent running it's animation so far */
    wxCheckBox *m_vid_txt;		/**< This displays the title of the video
    						handling section on the key framer
						window. */

  protected: // member data, these are the boolean expressions that are being
  	// used to keep track of the current state of the animator.

	/* all of the following have to be set by any programmer whenever he
		changes the state, either directly or thourhg the setISXXXXXXX (bool isit)
		functions.  */
    bool mb_fast_forward;	/**< This is true if the key frame handler is fast-
    					forwarding, false otherwise */
    bool mb_imgs_loaded;	/**< This is true if there is a video loaded, and
    					is false otherwise */
    bool mb_kf_reverse;		/**< This is true if the key frame handler is reversing,
    					false otherwise. */
    bool mb_kf_select;
    bool mb_loaded;		/**< This is true if a key frame file is loaded and
    					is false otherwise */
    bool mb_pause;		/**< This is true if the key framer handler is paused
    					while it is playing something else, and
    					is false otherwise */
    bool mb_play;		/**< This is true if the key framer handler is playing, and
    					is false otherwise */
    bool mb_play_from_images;	/**< This is true if there is a video playing, and
    					is false otherwise */
    bool mb_record;		/**< This is true if the key frame handler is
    					recording something, and is false otherwise */
    bool mb_rewind;		/**< This is true if the key frame handler is
    					rewinding something, and is false otherwise */
    bool mb_run;		/**< This is true if the key frame handler is
    					running something and is false otherwise...

					I think that this is probably
					deprecrated and probably should be removed */
    bool mb_stop;		/**< This is true if the key frame handler is stopped,
    					and is false otherwise */
    bool mb_video_bounce;
    bool mb_video_fast_forward;	/**< This is true if the video handler is fast forwarding
    					through a video file. */
    bool mb_video_loop;
    bool mb_video_pause;	/**< This is true if the video handler is paused while
    					it is playing or fastforwarding or rewinding a
					video file, and is false otherwise */
    bool mb_video_select;
    bool mb_video_reverse;	/**< This is true if the video portion of the animator
    					is reversing, false otherwise. */
    bool mb_video_rewind;	/**< This is true if the video handler is rewinding
    					while it is playing a video and is false
					otherwise */

  protected: // member data, these are the pointers to the strings that are
  	// keeping track of the buffers and the file names in this animator.

    char* m_play_video_buf;	/**< This is the screen buffer that files are being read
    					to and that images are being allocated from */
    char* m_img_fstart;		/**< This is the filename of the animation that's
    					being loaded into the video buffer. */

  protected: // member data, file pointers for open files in this animator.

    FILE *m_imgfp;		/**< This is a pointer to the file that is being
    					loaded from */

  protected: // member data, these are the floating point values of this animator,
  	// these are all time values for now.

    	// for take snap shot time
    float time_t;
    float m_pause_time;
    float m_play_time;			/**< This is the total play time of a key frame
    						animation file.  This is the time
						that is currently playing (so that we
						know what frames to interpolate, how to
						interpolate and play them next).*/
    float m_play_times [5];		/**< This array contains the last five play times
    						in the key frame animation.  This is stored
						so that I can keep track of the frame rate
						and ignore anomolies by averaging the last
						five instead of taking the last one. */
    float m_play_video_times [5];	/**< This is the array of the last five play times
    						when playing a video.  This is stored
						so that I can keep track of the frame
						rate that I am achieving, and ignore
						anomolies by averaging five. */
    float m_play_video_ttime;		/**< This is the length of time that the
    						video is currently playing so that
						it can work out which cel that it should
						play. */

  protected: // member data... mostly frames and counters

    int m_currentframe;			/**< This is the current frame that we are
    						playing in the key frame portion of
						the animator. */
    int counter;
    int m_play_counter;			/**< This keeps track of how many frames were
    						displayed in a key frame animation file.

						This will help the user figure out the
						speed that they are achieving. */
    int m_play_video_frame;		/**< This is the frame that the video
    						is currently playing.

						This is needed here since I cannot
						store it locally in playNextImage. */
    int m_play_video_size;		/**< This is the size of the buffer that
    						is needed to store frames in the video
						player.  This is needed here since I
						need to preserve it from frame to
						frame as I PlayNextImage (); */

    void* m_PlayTimer;			/**< This is a pointer to a timer...*/

    vuBasicUtility *m_Gui;		/**< This is a pointer to the calling utility
    						This is needed so that I can communicate
						with it probably when I need to (tell
						it to rerender, redisplay, etc). */

  protected: // member data, the camera pointers that are used by this animator

    vuCamera *m_camera;			/**< this is the default camera that the
    						Key frame animator will read from
						and write to (this is a pointer
						to the camera used by the method to render
						from... ie, it's the same camera as the
						user is manipulating through his renderer.
					*/
    vuCamera *m_play_camera_1;		/**< this is one of the two cameras that will
    						be used by the PlayInTime () method
						to interpolate between key frames

						This is stored here so that I don't have
						to allocate new cameras everytime (as
						would be the case if I stored them locally)*/
    vuCamera *m_play_camera_2;		/**< this is the other of the two cameras that will
    						be used by the PlayInTime () method
						to interpolate between key frames

						This is stored here so that I don't have
						to allocate new cameras everytime (as
						would be the case if I stored them locally)*/

  protected: // member data, the data vectors that are used by this animator
  	// to store time information.

    vuDVector <float> ttimevector;	/**< This will be used to store the time associated
    						with each cel in a video animation.

						cel i's time will be the value stored
						at ttimevector [i].

						This is so I don't play too early or too
						late..., and was preloaded to speed things up.
						*/
    vuDVector <char*> tfilenamevector;	/**<This will be used to store the filenames
    						of each of the PPMs in a video animation
						(these will be preloaded to speed things
						up a bit).  Remember to free your memory.
						cel i is found by reading file named
						tfilenamevector [i].
						*/

    vuDVector <vuCamera*> m_camera_vector;	/**< This will be used to store
    							The cameras (ie, key frame i's
							camera will be at
							m_camera_vector [i])/ */
    vuDVector <float> m_time_vector;	/**< This will be used to store the times
    						that each key frame is located at
						(ie, key frame i is at
						time m_time_vector [i]). */

  protected: // member data, some timers used by this animator

    vuHWTimer m_timer;		/**< This will be used as a general purpose timer */
    vuHWTimer m_pause_timer;	/**< This will be used to time the length of time
    					that a pause has taken */
    vuHWTimer m_play_timer;	/**< this will be used to time the play of the
    					animation files */

  protected: // the PPM reader that this animator uses for video files

    vuPPM m_PPMHandler;		/**< This will read ppm files and put them into the
    					screen buffers */


  protected: // vuobjects, these are the stop watches needed to time the processes that
  	// are occuring in this animator.

    vuStopWatch debugtimer;		/**< This timer was used to work out the time
    						taken by specific sections of code to
						run.  This was used so that I could
						figure out if my optimizations were
						any good or not, and so that I could
						speed up the video play back */
    vuStopWatch m_playwatch;		/**< This is used to figure out how long it's
    						taking for the key frame to play, and to
						figure out which frame or interpolated
						frame it should play next.

						 This will run faster if fast forwarding, and
						 backwards if rewinding... */
    vuStopWatch m_vid_play_timer;	/**< This timer is used to figure out how long
					    it takes to play back a video (it's here
					    because the fucntion is borken up into steps
					    of playnextimage (), so that the other
					    wxevents could be processed in that time.

					    The time stored by this is corresponds to
					    which frame should be played (if it's
					    too late to play a frame, it'll skip and go to
					    the next, this timer's time will be
					    changed by fast forwards and rewinds.).*/

  protected:	// a wxWindows thing.  Probably sets up how the stuff is working.
    DECLARE_EVENT_TABLE()
};

#endif






