#include "vuKeyFramerDialog.h"
#include <wx/colordlg.h>

#include <fstream.h>
#include <iostream.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <math.h>
#include <stdio.h>

#include "../vuTransferCanvas.h"

#include "vuColourRGBa.h"

#ifndef DEBUGMSG
#define DEBUGMSG cout << __FILE__ << ":" << __LINE__<<":" << endl
#endif

//----------------------------------------------------------------------------
//------------------------- The vuKeyFramerDialog event table -----------------
//----------------------------------------------------------------------------

BEGIN_EVENT_TABLE (vuKeyFramerDialog, wxFrame)
  EVT_BUTTON (vuKeyFramerDialog::idAUTOSHOT, vuKeyFramerDialog::OnAutoShot)
  EVT_BUTTON (vuKeyFramerDialog::idCLOSE, vuKeyFramerDialog::OnClose)
  EVT_BUTTON (vuKeyFramerDialog::idFASTFORWARD, vuKeyFramerDialog::OnFastForward)
  EVT_BUTTON (vuKeyFramerDialog::idLOAD, vuKeyFramerDialog::OnLoad)
  EVT_BUTTON (vuKeyFramerDialog::idPAUSE, vuKeyFramerDialog::OnPause)
  EVT_BUTTON (vuKeyFramerDialog::idPLAY, vuKeyFramerDialog::OnPlay)
  EVT_BUTTON (vuKeyFramerDialog::idPLAYFROMIMAGES, vuKeyFramerDialog::OnPlayFromImages)
  EVT_BUTTON (vuKeyFramerDialog::idRECORD, vuKeyFramerDialog::OnRecord)
  EVT_BUTTON (vuKeyFramerDialog::idREWIND, vuKeyFramerDialog::OnRewind)
  EVT_BUTTON (vuKeyFramerDialog::idSAVE, vuKeyFramerDialog::OnSave)
  EVT_BUTTON (vuKeyFramerDialog::idSTOP, vuKeyFramerDialog::OnStop)
  EVT_BUTTON (vuKeyFramerDialog::idTAKESHOT, vuKeyFramerDialog::OnTakeShot)
/*  EVT_BUTTON (vuKeyFramerDialog::idVIDCLOSE, vuKeyFramerDialog::OnVideoClose)
  EVT_BUTTON (vuKeyFramerDialog::idVIDFASTFORWARD, vuKeyFramerDialog::OnVideoFastForward)
  EVT_BUTTON (vuKeyFramerDialog::idVIDLOAD, vuKeyFramerDialog::OnVideoLoad)
  EVT_BUTTON (vuKeyFramerDialog::idVIDPAUSE, vuKeyFramerDialog::OnVideoPause)
  EVT_BUTTON (vuKeyFramerDialog::idVIDPLAY, vuKeyFramerDialog::OnVideoPlay)
  EVT_BUTTON (vuKeyFramerDialog::idVIDREWIND, vuKeyFramerDialog::OnVideoRewind)
  EVT_BUTTON (vuKeyFramerDialog::idVIDSTOP, vuKeyFramerDialog::OnVideoStop) */
  EVT_CHECKBOX (vuKeyFramerDialog::idKFBOUNCE, vuKeyFramerDialog::OnKFBounce)
  EVT_CHECKBOX (vuKeyFramerDialog::idKFLOOP, vuKeyFramerDialog::OnKFLoop)
  EVT_CHECKBOX (vuKeyFramerDialog::idKFSELECT, vuKeyFramerDialog::OnKFSelect)
  EVT_CHECKBOX (vuKeyFramerDialog::idVIDSELECT, vuKeyFramerDialog::OnVideoSelect)
//  EVT_CHECKBOX (vuKeyFramerDialog::idVIDBOUNCE, vuKeyFramerDialog::OnVideoBounce)
//  EVT_CHECKBOX (vuKeyFramerDialog::idVIDLOOP, vuKeyFramerDialog::OnVideoLoop)
END_EVENT_TABLE ()

//----------------------------------------------------------------------------
//------------------------- The constructor ----------------------------------
//----------------------------------------------------------------------------

wxSize defsize (200, 200);

vuKeyFramerDialog::vuKeyFramerDialog (wxWindow *parent, vuCamera *cam, vuBasicUtility *UWin)
    : wxFrame (parent, -1, wxString ("Key Frame Editor")),
    //: wxWindow (parent, -1, wxString ("Key Frame Editor")),
//:	wxCHILDWINDOW ((wxMDIParentFrame *) (parent), -1, wxString ("Key Frame Editor")),
	       mb_fast_forward (false),
	       mb_imgs_loaded (false),
	       mb_loaded (false),
	       mb_pause (false),
	       mb_play (false),
	       mb_play_from_images (false),
	       mb_record (false),
	       mb_rewind (false),
	       mb_run (false),
	       mb_stop (false),
	       mb_video_bounce (false),
	       mb_video_fast_forward (false),
	       mb_video_loop (false),
	       mb_video_pause (false),
	       mb_video_reverse (false),
	       mb_video_rewind (false),
	       m_play_video_buf (NULL),
	       m_img_fstart (NULL),
	       m_imgfp (NULL),
	       m_currentframe (0),
	       m_play_video_frame (0),
	       m_Gui (UWin),
	       m_camera (cam),
	       m_play_camera_1 (NULL),
	       m_play_camera_2 (NULL)

{
	// set the event generator that will generate the
	// timer events for this key framer class

  //	DEBUGMSG;

    vuEvtGenerator* t_timer = new vuEvtGenerator [1];

    m_play_counter = 0;

    t_timer->setKeyFramer (this);

    m_PlayTimer = (void *) t_timer;

    //Create the OpenGL canvas.
    m_MainSizer = new wxBoxSizer (wxHORIZONTAL);

    wxBoxSizer *vlefSizer = new wxBoxSizer (wxVERTICAL);
//    wxBoxSizer *vrigSizer = new wxBoxSizer (wxVERTICAL);

//	DEBUGMSG;
    wxBoxSizer *firstbar = new wxBoxSizer (wxHORIZONTAL);
    wxBoxSizer *kfplaybar = new wxBoxSizer (wxHORIZONTAL);
//    wxBoxSizer *vidplaybar = new wxBoxSizer (wxHORIZONTAL);
    wxBoxSizer *recbar = new wxBoxSizer (wxHORIZONTAL);
    wxBoxSizer *loadbar = new wxBoxSizer (wxHORIZONTAL);
    wxBoxSizer *infobar = new wxBoxSizer (wxHORIZONTAL);
//    wxBoxSizer *aniloadbar = new wxBoxSizer (wxHORIZONTAL);
    wxBoxSizer *kfloopbar = new wxBoxSizer (wxHORIZONTAL);
//    wxBoxSizer *vidloopbar = new wxBoxSizer (wxHORIZONTAL);
    wxBoxSizer *topbar = new wxBoxSizer (wxHORIZONTAL);
    wxBoxSizer *openbar = new wxBoxSizer (wxVERTICAL);
    wxBoxSizer *statbar = new wxBoxSizer (wxVERTICAL);
    //	DEBUGMSG;

    wxSize size (80, -1);
    wxSize halfsize (40, -1);

//    	DEBUGMSG;

    m_time_delay = new wxTextCtrl ((wxCHILDWINDOW *) (this), -1, "1.00", wxPoint (235, 70), halfsize, 0,
				 wxTextValidator (wxFILTER_NUMERIC));
//	DEBUGMSG;
    m_fm_rate = new wxStaticText (this ,-1 , wxString (vuKF_default_fm_rate_msg_), wxPoint (195, 70),size, 0);
//	DEBUGMSG;
    m_fm_rate_txt = new wxStaticText (this, -1, wxString (vuKF_default_fm_rate_msg_), wxPoint (200, 155), size, 0);
//	DEBUGMSG;
    m_frames_played_txt = new wxStaticText (this, -1, wxString (vuKF_frames_played_msg_), wxPoint (200, 170), wxSize (145, -1), 0);
//	DEBUGMSG;
    m_kf_status_txt = new wxStaticText (this, -1, wxString (vuKF_status_msg), wxPoint (200, 140), size, 0);
//	DEBUGMSG;
    m_loaded_txt = new wxStaticText (this, -1, wxString (vuKF_default_curr_loaded_msg), wxPoint (5, 190), wxSize (200, -1), 0);
    //	DEBUGMSG;

/*
    m_vid_fm_rate_txt = new wxStaticText (this ,-1 , wxString (vuKF_default_fm_rate_msg_), wxDefaultPosition, size, 0);
    m_vid_frames_played_txt = new wxStaticText (this ,-1 , wxString (vuKF_frames_played_msg_), wxDefaultPosition, wxSize (250, -1), 0);
    m_vid_loaded_txt = new wxStaticText (this, -1, wxString (vuKF_default_curr_loaded_msg), wxDefaultPosition, wxSize (250, -1), 0);
    m_vid_status_txt = new wxStaticText (this, -1, wxString (vuKF_status_msg), wxDefaultPosition, wxSize (250, -1), 0);
    m_vid_total_time_txt = new wxStaticText (this, -1, wxString (vuKF_render_time_msg), wxDefaultPosition, wxSize (250, -1), 0);
*/

    m_total_time = new wxStaticText (this, -1, wxString (vuKF_render_time_msg), wxPoint (200, 185), size, 0);
//	DEBUGMSG;

    m_close = new wxButton (this, idCLOSE, "Close", wxPoint (55, 140), wxSize (45, 20));

//	DEBUGMSG;
    m_fastforward = new wxBitmapButton (this, idFASTFORWARD, wxBitmap ("vuGui/wxUIElements/vuKeyFramerDialog/ff.bmp", wxBITMAP_TYPE_BMP), wxPoint (330, 30), wxSize (55, 25));
    m_load = new wxButton (this, idLOAD, "Open",  wxPoint (5, 140), wxSize (45, 20));
    m_play = new wxBitmapButton (this, idPLAY, wxBitmap ("vuGui/wxUIElements/vuKeyFramerDialog/play.bmp", wxBITMAP_TYPE_BMP), wxPoint (70, 30), wxSize (55, 25));
    m_pause = new wxBitmapButton (this, idPAUSE, wxBitmap ("vuGui/wxUIElements/vuKeyFramerDialog/pause.bmp", wxBITMAP_TYPE_BMP), wxPoint (135, 30), wxSize (55, 25));
    m_record = new wxBitmapButton (this, idRECORD, wxBitmap ("vuGui/wxUIElements/vuKeyFramerDialog/rec.bmp", wxBITMAP_TYPE_BMP), wxPoint (265, 30), wxSize (55, 25));
    m_rewind = new wxBitmapButton (this, idREWIND, wxBitmap ("vuGui/wxUIElements/vuKeyFramerDialog/rew.bmp", wxBITMAP_TYPE_BMP), wxPoint (3, 30), wxSize (55, 25));
    m_stop = new wxBitmapButton (this, idSTOP, wxBitmap ("vuGui/wxUIElements/vuKeyFramerDialog/stop.bmp", wxBITMAP_TYPE_BMP), wxPoint (200, 30), wxSize (55, 25));
    m_takeshot = new wxButton (this, idTAKESHOT, "Take", wxPoint (5, 165), wxSize (45, 20));

/*    m_vid_close = new wxButton (this, idVIDCLOSE, "Close", wxPoint (25, 150));
    m_vid_fastforward = new wxButton (this, idVIDFASTFORWARD, "Fast Foward", wxPoint (25, 150));
    m_vid_load = new wxButton (this, idVIDLOAD,"Load", wxPoint (25, 150));
    m_vid_pause = new wxButton (this, idVIDPAUSE,"Pause", wxPoint (25, 150));
    m_vid_play = new wxButton (this, idVIDPLAY,"Play", wxPoint (25, 150));
    m_vid_rewind = new wxButton (this, idVIDREWIND, "Rewind", wxPoint (25, 150));
    m_vid_stop = new wxButton (this, idVIDSTOP,"Stop", wxPoint (25, 150));*/

//    m_autoshot = new wxCheckBox(this,idAUTOSHOT,"AutoSnapShot",wxDefaultPosition);
    m_burstplay = new wxCheckBox (this, idBURSTPLAY, "Max Speed/Key Frames Only", wxPoint (5, 90));
    m_kf_bounce = new wxCheckBox (this, idKFBOUNCE, wxString (vuKF_bounce_msg), wxPoint (320, 90));
    m_kf_loop = new wxCheckBox (this, idKFLOOP, wxString (vuKF_loop_msg), wxPoint (320, 70));
    m_kf_txt = new wxCheckBox (this, idKFSELECT, "KeyFrame", wxPoint (5, 5), size, 0);
    m_genimages = new wxCheckBox (this, idGENIMAGES, "Save Animation", wxPoint (5, 70));

    m_save = new wxButton (this, idSAVE, "Save", wxPoint (105, 140), wxSize (45, 20));
//    m_vid_bounce = new wxCheckBox (this, idVIDBOUNCE, wxString (vuKF_bounce_msg), wxDefaultPosition);
//    m_vid_loop = new wxCheckBox (this, idVIDLOOP, wxString (vuKF_loop_msg), wxDefaultPosition);
    m_vid_txt = new wxCheckBox (this, idVIDSELECT, "Video", wxPoint (320, 5),size, 0);

    m_divider = new wxPanel (this, -1, wxPoint (190, 135), wxSize (2, 100), wxSUNKEN_BORDER);
    m_divider2 = new wxPanel (this, -1, wxPoint (5, 130), wxSize (400, 2), wxSUNKEN_BORDER);
    //	DEBUGMSG;

    topbar->Add (m_kf_txt, 0);
    topbar->Add (200, 0);
    topbar->Add (m_vid_txt, 0);

    kfplaybar->Add (m_rewind, 0);
    kfplaybar->Add (10, 0);
    kfplaybar->Add (m_play, 0);
    kfplaybar->Add (10, 0);
    kfplaybar->Add (m_pause, 0);
    kfplaybar->Add (10, 0);
    kfplaybar->Add (m_record, 0);
    kfplaybar->Add (10, 0);
    kfplaybar->Add (m_stop, 0);
    kfplaybar->Add (10, 0);
    kfplaybar->Add (m_fastforward, 0);
    kfplaybar->Add (10, 0);

    firstbar->Add (m_genimages);
    firstbar->Add (20, 0);
    firstbar->Add (m_fm_rate, 0);
    firstbar->Add (m_time_delay, 0);
    firstbar->Add (20, 0);
    firstbar->Add (m_kf_bounce, 0);

    recbar->Add (m_takeshot, 0);
//    recbar->Add (5, 0);
//    recbar->Add (m_save, 0);

    loadbar->Add (m_load, 0);
    loadbar->Add (5, 0);
    loadbar->Add (m_close, 0);
    loadbar->Add (5, 0);
    loadbar->Add (m_save, 0);
    //	DEBUGMSG;

//    infobar->Add (m_loaded_txt, 0);

/*    vidplaybar->Add (m_vid_rewind, 0);
    vidplaybar->Add (5, 0);
    vidplaybar->Add (m_vid_play, 0);
    vidplaybar->Add (5, 0);
    vidplaybar->Add (m_vid_pause, 0);
    vidplaybar->Add (5, 0);
    vidplaybar->Add (m_vid_stop, 0);
    vidplaybar->Add (5, 0);
    vidplaybar->Add (m_vid_fastforward, 0);*/

    kfloopbar->Add (m_burstplay, 0);
    kfloopbar->Add (85, 0);
    kfloopbar->Add (m_kf_loop, 0);

    vlefSizer->Add (0, 5);
    vlefSizer->Add (topbar, 0, wxEXPAND);
    vlefSizer->Add (0, 5);
    vlefSizer->Add (kfplaybar, 0);
    vlefSizer->Add (0, 5);
    vlefSizer->Add (firstbar, 0, wxEXPAND);
    vlefSizer->Add (0, 5);
    vlefSizer->Add (kfloopbar, 0, wxEXPAND);
    vlefSizer->Add (0, 5);
    vlefSizer->Add (m_divider2, 0);
    vlefSizer->Add (0, 5);

    openbar->Add (loadbar, 0);
    openbar->Add (0, 5);
    openbar->Add (m_takeshot, 0);
    openbar->Add (0, 5);
    openbar->Add (m_loaded_txt, 0);
    openbar->Add (0, 5);
    openbar->Add (m_kf_status_txt, 0);
    openbar->Add (0, 5);

    statbar->Add (m_total_time, 0);
    statbar->Add (0, 5);
    statbar->Add (m_fm_rate_txt, 0);
    statbar->Add (0, 5);
    statbar->Add (m_frames_played_txt, 0);

    infobar->Add (openbar, 0);
    infobar->Add (5, 0);
    infobar->Add (m_divider, 0);
    infobar->Add (5, 0);
    infobar->Add (statbar, 0);

    vlefSizer->Add (infobar, 0);
    vlefSizer->Add (0, 5);
//	DEBUGMSG;

/*    aniloadbar->Add (m_vid_load, 0);
    aniloadbar->Add (5, 0);
    aniloadbar->Add (m_vid_close, 0);

    vidloopbar->Add (m_vid_loop, 0);
    vidloopbar->Add (5, 0);
    vidloopbar->Add (m_vid_bounce, 0);

    vrigSizer->Add (0, 5);
    vrigSizer->Add (m_vid_txt, 0);
    vrigSizer->Add (0, 5);
    vrigSizer->Add (vidplaybar, 0);
    vrigSizer->Add (0, 5);
    vrigSizer->Add (vidloopbar, 0);
    vrigSizer->Add (0, 5);
    vrigSizer->Add (m_vid_total_time_txt, 0);
    vrigSizer->Add (0, 5);
    vrigSizer->Add (m_vid_fm_rate_txt, 0);
    vrigSizer->Add (0, 5);
    vrigSizer->Add (m_vid_frames_played_txt, 0);
    vrigSizer->Add (0, 5);
    vrigSizer->Add (aniloadbar, 0);
    vrigSizer->Add (0, 5);
    vrigSizer->Add (m_vid_loaded_txt, 0);
    vrigSizer->Add (0, 5);
    vrigSizer->Add (m_vid_status_txt, 0);
    vrigSizer->Add (0, 5);*/

    //Construct the Dialog architecture.
    m_MainSizer->Add (5, 0);
    m_MainSizer->Add (vlefSizer, 1, wxEXPAND);
/*    m_MainSizer->Add (25, 0);
    m_MainSizer->Add (m_divider);
    m_MainSizer->Add (25, 0);
    m_MainSizer->Add (vrigSizer, 0, wxEXPAND);
    m_MainSizer->Add (5, 0);*/

    //Set the Dialog up to use the sizers
    SetSizer (m_MainSizer);
    SetAutoLayout (true);

    m_MainSizer->SetSizeHints (this);
    m_MainSizer->Fit (this);
//	DEBUGMSG;

    m_playwatch.setFastSpeed (vuKF_spd_mul);
    m_vid_play_timer.setFastSpeed (vuKF_spd_mul);

    m_kf_txt->SetValue (true);
    m_vid_txt->SetValue (false);

//	DEBUGMSG;
    m_takeshot->Disable ();
    m_save->Disable ();
}

vuKeyFramerDialog::~vuKeyFramerDialog ()

{
	vuEvtGenerator *temp;
	temp = (vuEvtGenerator *) (m_PlayTimer);

	delete [] temp;

	if (int (m_camera_vector.getLength ()) > 0)

	{
		for (int i = 0; i < int (m_camera_vector.getLength ()); i++)
			delete [] m_camera_vector [i];

		m_camera_vector.removeRange (0, m_camera_vector.getLength () - 1);
	}

	if (int (tfilenamevector.getLength ()) > 0)

	{
		for (int i = 0; i < int (tfilenamevector.getLength ()); i++)
			delete [] tfilenamevector [i];

		tfilenamevector.removeRange (0, tfilenamevector.getLength () - 1);
	}
}

void vuKeyFramerDialog::setup (vuCamera *cam, vuBasicUtility *UWin)

{
	m_camera = cam;
	m_Gui = UWin;
}

void vuKeyFramerDialog::Close ()

{
  Show (false);
}

bool vuKeyFramerDialog::Destroy ()

{
  Show (false);
  return true;
}


//-----------------------------------------------------------------------
//
//	state retrieval functions
//
//-----------------------------------------------------------------------

bool vuKeyFramerDialog::IsFastForwarding ()

{
	return mb_fast_forward;
}

bool vuKeyFramerDialog::IsImgsLoaded ()

{
	return mb_imgs_loaded;
}

bool vuKeyFramerDialog::IsKFBouncing ()

{
	return m_kf_bounce->GetValue ();
}

bool vuKeyFramerDialog::IsKFLooping ()

{
	return m_kf_loop->GetValue ();
}

bool vuKeyFramerDialog::IsKFReversing ()

{
	return mb_kf_reverse;
}

bool vuKeyFramerDialog::IsLoaded ()

{
	return mb_loaded;
}

bool vuKeyFramerDialog::IsPaused ()

{
	return mb_pause;
}

bool vuKeyFramerDialog::IsPlaying ()

{
	return mb_play;
}

bool vuKeyFramerDialog::IsPlayingImgs ()

{
	return mb_play_from_images;
}

bool vuKeyFramerDialog::IsRecording ()

{
	return mb_record;
}

bool vuKeyFramerDialog::IsRewinding ()

{
	return mb_rewind;
}

bool vuKeyFramerDialog::IsStopped ()

{
	return mb_stop;
}

bool vuKeyFramerDialog::IsVideoFastForwarding ()

{
	return mb_video_fast_forward;
}

bool vuKeyFramerDialog::IsVideoPaused ()

{
	return mb_video_pause;
}

bool vuKeyFramerDialog::IsVideoPlaying ()

{
	return IsPlayingImgs ();
}

bool vuKeyFramerDialog::IsVideoBouncing ()

{
//	return m_vid_bounce->GetValue ();
//	return mb_video_bounce;

	return ((m_kf_bounce->GetValue ()) && (m_vid_txt->GetValue ()));
}

bool vuKeyFramerDialog::IsVideoLooping ()

{
//	return m_vid_loop->GetValue ();
//	return mb_video_loop;

	return ((m_kf_loop->GetValue ()) && (m_vid_txt->GetValue ()));
}

bool vuKeyFramerDialog::IsVideoReversing ()

{
	return mb_video_reverse;
}

bool vuKeyFramerDialog::IsVideoRewinding ()

{
	return mb_video_rewind;
}

//-------------------------------------

void vuKeyFramerDialog::run (int whatsup, void* data)

{
	if (mb_run)
		return;

	mb_run = true;

	wxCommandEvent temp;

	if (mb_stop)

	{
		OnStop (temp);
	}

	if (mb_pause)

	{
		OnPause (temp);
	}

	if ((mb_play) && (!mb_pause) && (!mb_stop))

	{
		cout << "playtime" << endl;

		PlayFunc ();
	}

	if ((mb_record) && (!mb_pause) && (!mb_stop))

	{
	}

	mb_run = false;
}

//--------------------------

void vuKeyFramerDialog::setIsFastForwarding (bool isit)

{
	mb_fast_forward = isit;

	m_playwatch.setIsFastForwarding (isit);

	if (isit)

	{
		setIsRewinding (false);
		setIsKFReversing (false);
//		setIsFastForwarding (false);
	}
}

void vuKeyFramerDialog::setIsImgsLoaded (bool isit)

{
	mb_imgs_loaded = isit;
}

void vuKeyFramerDialog::setIsKFBouncing (bool isit)

{
	m_kf_bounce->SetValue (isit);

	m_playwatch.setIsBouncing (isit);

	if (isit)
		m_kf_loop->SetValue (isit);
}

void vuKeyFramerDialog::setIsKFLooping (bool isit)

{
	m_kf_loop->SetValue (isit);

	m_playwatch.setIsLooping (isit);

	if (isit)
		m_kf_bounce->SetValue (isit);
}

void vuKeyFramerDialog::setIsKFReversing (bool isit)

{
	mb_kf_reverse = isit;

	m_playwatch.setIsReversing (true);

	if (isit)

	{
		setIsRewinding (false);
		setIsFastForwarding (false);
	}
}

void vuKeyFramerDialog::setIsLoaded (bool isit)

{
	mb_loaded = isit;
}

void vuKeyFramerDialog::setIsPaused (bool isit)

{
	mb_pause = isit;

	if (isit)
		m_playwatch.Pause ();
	else
		m_playwatch.Resume ();
}

void vuKeyFramerDialog::setIsPlaying (bool isit)

{
	mb_play = isit;

	m_playwatch.Resume ();

	if (isit)

	{
		setIsRewinding (false);
		setIsKFReversing (false);
		setIsFastForwarding (false);
	}
}

void vuKeyFramerDialog::setIsPlayingImgs (bool isit)

{
	mb_play_from_images = isit;
}

void vuKeyFramerDialog::setIsRecording (bool isit)

{
	mb_record = isit;
}

void vuKeyFramerDialog::setIsVideoBouncing (bool isit)

{
/*	mb_video_bounce = isit;

	if (isit)
		mb_video_loop = false;
*/
//	m_vid_bounce->SetValue (isit);
//
//	if (isit)
//		m_vid_bounce->SetValue (false);
	m_vid_play_timer.setIsBouncing (isit);
}

void vuKeyFramerDialog::setIsVideoFastForwarding (bool isit)

{
	mb_video_fast_forward = isit;
	m_vid_play_timer.setIsFastForwarding (isit);

	if (isit)

	{
		setIsVideoRewinding (false);
		setIsVideoReversing (false);
	}
}

void vuKeyFramerDialog::setIsVideoLooping (bool isit)

{
//	m_vid_loop->SetValue (isit);

//	if (isit)
//		m_vid_bounce->SetValue (false);
//	mb_video_loop = isit;
//
//	if (isit)
//		mb_video_bounce = false;

	m_vid_play_timer.setIsLooping (isit);
}

void vuKeyFramerDialog::setIsVideoPaused (bool isit)

{
	mb_video_pause = isit;

	if (isit)
		m_vid_play_timer.Pause ();
	else
		m_vid_play_timer.Resume ();
}

void vuKeyFramerDialog::setIsVideoPlaying (bool isit)

{
	setIsPlayingImgs (isit);

	if (isit)

	{
		setIsVideoRewinding (false);
		setIsVideoReversing (false);
		setIsVideoFastForwarding (false);
	}
}

void vuKeyFramerDialog::setIsVideoRewinding (bool isit)

{
	m_vid_play_timer.setIsRewinding (isit);
	mb_video_rewind = isit;

	if (isit)

	{
		setIsVideoReversing (false);
		setIsVideoFastForwarding (false);
	}
}

void vuKeyFramerDialog::setIsVideoReversing (bool isit)

{
	mb_video_reverse = isit;
	
	m_vid_play_timer.setIsReversing (isit);

	if (isit)

	{
		setIsVideoRewinding (false);
		setIsVideoFastForwarding (false);
	}
}

void vuKeyFramerDialog::setIsRewinding (bool isit)

{
	mb_rewind = isit;

	m_playwatch.setIsRewinding (isit);

	if (isit)

	{
		setIsKFReversing (false);
		setIsFastForwarding (false);
	}
}

void vuKeyFramerDialog::setIsStopped (bool isit)

{
	mb_stop = isit;
}

void vuKeyFramerDialog::OnAutoShot (wxCommandEvent &ev)

{
}

void vuKeyFramerDialog::OnClose (wxCommandEvent &ev)

{
	if (m_vid_txt->GetValue ())

	{
		OnVideoClose (ev);

//		return;
	}

	if ((!IsLoaded ()) && (!IsRecording ()))
		return;

	if (IsPlaying ())

	{
/*		wxMessageDialog temp (this, "Cannot close a file while it is playing. \n Please stop the file before trying to close it.", "Close Error!", wxOK);

		temp.ShowModal ();

		return;*/
		OnStop (ev);
	}

	if (IsRecording ())

	{
//		wxMessageDialog temp (this, "Do you wish to close without saving?", "Close Error!", wxYES_NO);

//		int t = temp.ShowModal ();
//
//		if (t == wxID_NO)
//
//		{
//			wxCommandEvent tevt;
//
//			OnSave (tevt);
//
//			return;
//		}
		OnSave (ev);
	}

	m_camera_vector.removeRange (0, m_camera_vector.getLength ());
	m_time_vector.removeRange (0, m_time_vector.getLength ());

	setIsLoaded (false);
	setIsRecording (false);
	setIsPlaying (false);

	m_save->Disable ();
	m_takeshot->Disable ();

	m_loaded_txt->SetLabel (wxString (vuKF_default_curr_loaded_msg));

	return;
}

void vuKeyFramerDialog::OnFastForward (wxCommandEvent &ev)

{
	if (m_vid_txt->GetValue ())

	{
		OnVideoFastForward (ev);

		return;
	}

	if (!IsPlaying ())
		OnPlay (ev);
//		return;

	if (IsRewinding ())
		OnRewind (ev);

	if (IsPaused ())
		OnPause (ev);

	if (IsKFReversing ())
		m_playwatch.setIsReversing (false);

	if (IsFastForwarding ())
		cout << "fastforwarding" << endl;
	else
		cout << "not fastforwarding" << endl;

	setIsFastForwarding (!IsFastForwarding ());

	if (IsFastForwarding ())

	{
		m_kf_status_txt->SetLabel (wxString (vuKF_status_msg) + wxString ("Fast Forwarding"));
//		m_fastforward_timer.Start (0);

		m_playwatch.setIsFastForwarding (true);
	}

	else

	{
		m_kf_status_txt->SetLabel (wxString (vuKF_status_msg) + wxString ("Playing"));

		m_playwatch.setIsFastForwarding (false);
	}

	cout << "OnFastForward" << endl;
}

void vuKeyFramerDialog::OnKFBounce (wxCommandEvent &ev)

{
	if (m_vid_txt->GetValue ())

	{
		OnVideoBounce (ev);

//		return;
	}

	if (m_kf_bounce->GetValue ())
		m_kf_loop->SetValue (false);

	m_playwatch.setIsBouncing (m_kf_bounce->GetValue ());
	m_playwatch.setIsLooping (false);

	m_vid_play_timer.setIsBouncing (m_kf_bounce->GetValue ());
	m_vid_play_timer.setIsLooping (false);
}

void vuKeyFramerDialog::OnKFLoop (wxCommandEvent &ev)

{
	if (m_vid_txt->GetValue ())

	{
		OnVideoLoop (ev);

//		return;
	}

	if (m_kf_loop->GetValue ())
		m_kf_bounce->SetValue (false);

	m_playwatch.setIsLooping (m_kf_loop->GetValue ());
	m_playwatch.setIsBouncing (false);

	m_vid_play_timer.setIsLooping (m_kf_loop->GetValue ());
	m_vid_play_timer.setIsBouncing (false);
}

void vuKeyFramerDialog::OnKFSelect (wxCommandEvent &ev)

{
	if (m_vid_txt->GetValue ())

	{
		m_vid_txt->SetValue (false);

		m_genimages->Enable (true);
		m_burstplay->Enable (true);
		m_record->Enable (true);

		m_kf_bounce->SetValue (false);
		m_kf_loop->SetValue (false);

//		m_kf_bounce->Enable (false);
//		m_kf_loop->Enable (false);

		OnVideoStop (ev);
		OnVideoClose (ev);
	}

	else

	{
		m_vid_txt->SetValue (true);

		m_genimages->Disable ();
		m_burstplay->Disable ();
		m_record->Disable ();
		m_takeshot->Disable ();
		m_save->Disable ();

//		m_kf_bounce->Enable (true);
//		m_kf_loop->Enable (true);

		OnStop (ev);
		OnClose (ev);
	}
}

void vuKeyFramerDialog::OnLoad (wxCommandEvent &ev)

{
	if (m_vid_txt->GetValue ())

	{
		OnVideoLoad (ev);

		return;
	}

	if (IsLoaded ())

	{
/*		wxMessageDialog temp (this, "A key frame file has already been loaded.\n  Please close this file before loading another", "Load Error!", wxOK);

		temp.ShowModal ();

		return;*/
		OnClose (ev);
	}

	if (IsRecording ())

	{
/*		wxMessageDialog temp (this, "Cannot Load a file while another is being recorded to", "Load Error!", wxOK);
		temp.ShowModal ();

		return;*/
		OnSave (ev);
	}

	LoadFunc ();
}

void vuKeyFramerDialog::OnPause (wxCommandEvent &ev)

{
	if (m_vid_txt->GetValue ())

	{
		OnVideoPause (ev);

		return;
	}

	setIsPaused (!IsPaused ());

	if (IsPaused ())
		m_playwatch.Pause ();
	else
		m_playwatch.Resume ();
}

void vuKeyFramerDialog::OnPlay (wxCommandEvent &ev)

{
	if (m_vid_txt->GetValue ())

	{
		OnPlayFromImages (ev);

		return;
	}

	if (IsPlaying ())

	{
		wxCommandEvent ev;

		bool retval = false;

		if (IsPaused ())

		{
			OnPause (ev);

			retval = true;
		}

		if (IsRewinding ())

		{
			OnRewind (ev);

			retval = true;
		}

		if (IsFastForwarding ())

		{
			OnFastForward (ev);

			return;
		}

		if (IsKFReversing ())

		{
			setIsKFReversing (false);

			return;
		}

		if (retval)
			return;

//		wxMessageDialog temp (this, "A key frame file is already playing.\n  Please stop this file before playing another", "Load Error!", wxOK);

//		temp.ShowModal ();

		return;
	}

	setIsPaused (false);
	setIsStopped (false);

		// the playing will resume from inside the thread (which I hope is working...).
	if (IsPlaying ())
		return;

	if (IsRecording ())

	{
		wxMessageDialog temp (this, "Cannot play a key frame file while another is recording.  \n Please stop this file before reocrding to another.", "Play Error!", wxOK);

		temp.ShowModal ();

		return;
	}

	if (m_camera == NULL)

	{
		wxMessageDialog temp (this, "Cannot play a key frame file when the rendering method gives me a NULL pointer to a camera.  \n Please fix the return value of this functions before continue.", "Play Error!", wxOK);

		temp.ShowModal ();

		return;
	}

	wxCommandEvent ttemp;

	if (!IsLoaded ())
		OnLoad (ttemp);

	if (!IsLoaded ())
		return;

	mb_play = true;

//	blocker.lock ();
//	if (!defined (WIN32))
//		XInitThreads ();
#ifndef WIN32
	if (!XInitThreads ())
		cout << "X initialization failed" << endl;
#endif
//	if (!startThread (10))	// starts as a thread
		run (10, NULL);		// otherwise start manually without a thread
}

void vuKeyFramerDialog::OnPlayFromImages (wxCommandEvent &ev)

{
	cout << "PlayFromImages " << endl;

	if (IsVideoPlaying ())

	{
		cout << "VideoIsPlaying" << endl;
		setIsVideoPlaying (true);
		return;
	}

	if (IsVideoFastForwarding ())

	{
		setIsVideoFastForwarding (false);

		return;
	}

	if (IsVideoRewinding ())

	{
		setIsVideoRewinding (false);

		return;
	}

	if (IsVideoPaused ())

	{
		setIsVideoPaused (false);

		return;
	}

	if (IsPlaying ())

	{
		wxMessageDialog temp (this, "Already Playing a Key Frame animation, \n can't play a prerendered animation as well.", "Load Error!", wxOK);

		temp.ShowModal ();

		return;
	}

	if (IsPlayingImgs ())

	{

//		wxMessageDialog temp (this, "Already Playing an animation, \n can't play another while this is happening.", "Load Error!", wxOK);

//		temp.ShowModal ();

		return;
	}

	if (IsRecording ())

	{
		wxMessageDialog temp (this, "Already Recording a Key Frame file, \n can't play while this is happening.", "Load Error!", wxOK);

		temp.ShowModal ();

		return;
	}

	if (m_Gui->getCurrentImage () == NULL)

	{
		wxMessageDialog temp (this, "Cannot play a prerendered video without an image buffer to write to.  \n Please fix the return value of the rendering method's getCurrentImage () so that this can work.");

		temp.ShowModal ();

		return;
	}

	setIsPlayingImgs (true);

	PlayFromImages ();
}

void vuKeyFramerDialog::OnRecord(wxCommandEvent &ev)

{
	if (IsRecording ())

	{
		wxMessageDialog temp (this, "Cannot record to a file while another is being recorded to. \n Please save or close the current recording before recording to a new file.", "Load Error!", wxOK);
		temp.ShowModal ();

		return;
	}

	if (IsLoaded ())

	{
		wxMessageDialog temp (this, "Cannot record to a file while another is loaded. \n Please save or close the currently loaded file before recording to a new file.", "Load Error!", wxOK);
		temp.ShowModal ();

		return;
	}

	RecordFunc ();

	setIsRecording (true);
	setIsPaused (false);

	m_takeshot->Enable (true);
	m_save->Enable (true);
}

void vuKeyFramerDialog::OnRewind (wxCommandEvent &ev)

{
	if (m_vid_txt->GetValue ())

	{
		OnVideoRewind (ev);

		return;
	}

	if (!IsPlaying ())
		OnPlay (ev);

	if (IsFastForwarding ())
		OnFastForward (ev);

	if (IsPaused ())
		OnPause (ev);

	if (IsKFReversing ())
		m_playwatch.setIsReversing (false);

	setIsRewinding (!IsRewinding ());

	if (IsRewinding ())

	{
		m_kf_status_txt->SetLabel (wxString (vuKF_status_msg) + wxString ("Rewinding"));
//		m_rewind_timer.Start (0);

		m_playwatch.setIsRewinding (true);
	}

	else

	{
		m_kf_status_txt->SetLabel (wxString (vuKF_status_msg) + wxString ("Playing"));

		m_playwatch.setIsRewinding (false);
	}
}

void vuKeyFramerDialog::OnSave (wxCommandEvent &ev)

{
	if ((!IsRecording ()) && (!IsLoaded ()))

	{
		wxMessageDialog temp (this, "No key frame file has been loaded.\n  On must be loaded (or recorded to) before save can take effect.", "Load Error!", wxOK);

//		temp.ShowModal ();

		return;
	}

	if (IsLoaded ())

	{
		wxMessageDialog temp (this, "Currently, this can only save modifications to Key frame files that have been recorded to.", "Load Error!", wxOK);

		temp.ShowModal ();

		return;
	}

	wxMessageDialog temp (this, "Saving will also remove the currently loaded or recording file from memory. \n Do you wish to continue?", "Load Error!", wxYES_NO);

//	if (temp.ShowModal () == wxID_NO)
//		return;

	m_save->Disable ();
	m_takeshot->Disable ();

	SaveFunc (true);
}

void vuKeyFramerDialog::OnStop(wxCommandEvent &ev)

{
//	if (m_vid_txt->GetValue ())

//	{
		OnVideoStop (ev);

//		return;
//	}

	if (m_camera->IsRecording ())

	{
		wxMessageDialog temp (this, "Stopping without saving could cause loss of data.  \n Are you sure you wish to continue?", "Stop Error!", wxYES_NO);

		if (temp.ShowModal () == wxID_NO)
			return;

		SaveFunc (false);

		m_camera->stop_recording ();

		setIsRecording (false);
	}

	setIsFastForwarding (false);
	setIsPaused (false);
	setIsPlaying (false);
	setIsRewinding (false);
//	setIsLoaded (false);

	m_kf_status_txt->SetLabel (wxString (vuKF_status_msg));

	m_save->Disable ();
	m_takeshot->Disable ();

	m_currentframe = 0;
}

void vuKeyFramerDialog::OnTakeShot(wxCommandEvent &ev)

{
//	if (!m_camera->IsRecording ())
	if (!IsRecording ())

	{
		wxMessageDialog temp (this, "No key frame file to record to. \n Please start recording before taking snapshots.", "Snap Shot Error!", wxOK);

		temp.ShowModal ();

		return;
//		cout << "vuKeyFramer::OnTakeShot : Not recording so I can't do anything of importance" << endl;
	}

	cout << "OnTakeShot::   taking the thing" << endl;
//	m_camera->TakeSnapShot ();

	time_t += m_timer.getElapsedTimeFloat ();
//	TakeSnapShotWithTime (time_t, (*m_camera));

	m_time_vector.add (time_t);
	vuCamera* tcam = m_camera->create_new ();
	*tcam = m_camera;
	m_camera_vector.add (tcam);
}

void vuKeyFramerDialog::OnVideoBounce (wxCommandEvent &ev)

{
/*	if (m_vid_bounce->GetValue ())
		m_vid_loop->SetValue (false);
*/
//	setIsVideoBouncing (!IsVideoBouncing ());
//	setIsVideoLooping (false);

//	m_vid_play_timer.setIsBouncing (IsVideoBouncing ());
	m_vid_play_timer.setIsBouncing (m_kf_bounce->GetValue ());
	m_vid_play_timer.setIsLooping (false);
}

void vuKeyFramerDialog::OnVideoClose (wxCommandEvent &ev)

{
	if (IsVideoPlaying ())

	{
//		wxMessageDialog temp (this, "Cannot close a file while it is playing. \n Please stop the file before trying to close it.", "Close Error!", wxOK);
//
//		temp.ShowModal ();
//
//		return;
		OnVideoStop (ev);
	}

	if (m_imgfp != NULL)

	{
		fclose (m_imgfp);

		m_imgfp = NULL;
	}

	for (int i = 0; i < int (tfilenamevector.getLength ()); i++)
		delete [] tfilenamevector [i];

	tfilenamevector.removeRange (0, tfilenamevector.getLength () - 1);
	ttimevector.removeRange (0, ttimevector.getLength () - 1);

//	m_vid_loaded_txt->SetLabel (wxString (vuKF_default_curr_loaded_msg));
	m_loaded_txt->SetLabel (wxString (vuKF_default_curr_loaded_msg));

	setIsImgsLoaded (false);

//	m_vid_status_txt->SetLabel (wxString (vuKF_status_msg));
	m_kf_status_txt->SetLabel (wxString (vuKF_status_msg));
}

void vuKeyFramerDialog::OnVideoFastForward (wxCommandEvent &ev)

{
	if (!IsVideoPlaying ())
		OnPlayFromImages (ev);
//		return;

	if (IsVideoPaused ())
		OnVideoPause (ev);

	if (IsVideoRewinding ())
		OnVideoRewind (ev);

	if (IsVideoReversing ())
		OnVideoReverse (ev);

	setIsVideoFastForwarding (!IsVideoFastForwarding ());

	if (IsVideoFastForwarding ())

	{
//		m_vid_status_txt->SetLabel (wxString (vuKF_status_msg) + wxString ("Fast Forwarding"));
		m_kf_status_txt->SetLabel (wxString (vuKF_status_msg) + wxString ("Fast Forwarding"));
//		m_vid_fastforward_timer.Start (0);

		m_vid_play_timer.setIsFastForwarding (true);
	}

	else

	{
//		m_vid_status_txt->SetLabel (wxString (vuKF_status_msg) + wxString ("Playing"));
		m_kf_status_txt->SetLabel (wxString (vuKF_status_msg) + wxString ("Playing"));

		m_vid_play_timer.setIsFastForwarding (false);
	}
}

void vuKeyFramerDialog::OnVideoLoad (wxCommandEvent &ev)

{
	m_imgfp = OpenGIFile ();

	setIsImgsLoaded (true);
}

void vuKeyFramerDialog::OnVideoLoop (wxCommandEvent &ev)

{
//	if (m_vid_loop->GetValue ())
//		m_vid_bounce->SetValue (false);

//	setIsVideoLooping (!IsVideoLooping ());
//	setIsVideoBouncing (false);

//	m_vid_play_timer.setIsLooping (IsVideoLooping ());
	m_vid_play_timer.setIsLooping (m_kf_loop->GetValue ());
	m_vid_play_timer.setIsBouncing (false);
}

void vuKeyFramerDialog::OnVideoPause (wxCommandEvent &ev)

{
	if (!IsVideoPlaying ())
		return;

	setIsVideoPaused (!IsVideoPaused ());

	if (!IsVideoPaused ())

	{
		m_vid_play_timer.Resume ();
//		m_vid_status_txt->SetLabel (wxString (vuKF_status_msg) + wxString ("Playing"));
		m_kf_status_txt->SetLabel (wxString (vuKF_status_msg) + wxString ("Playing"));
	}

	else

	{
		m_vid_play_timer.Pause ();
//		m_vid_status_txt->SetLabel (wxString (vuKF_status_msg) + wxString ("Paused"));
		m_kf_status_txt->SetLabel (wxString (vuKF_status_msg) + wxString ("Paused"));
	}
}

void vuKeyFramerDialog::OnVideoPlay (wxCommandEvent &ev)

{
	if (IsPlaying ())

	{
		wxMessageDialog temp (this, "Already Playing a Key Frame animation, \n can't play a prerendered animation as well.", "Load Error!", wxOK);

		temp.ShowModal ();

		return;
	}

	if (IsPlayingImgs ())

	{
		bool retnow = false;
		wxCommandEvent ev;

		if (IsVideoRewinding ())

		{
			OnVideoRewind (ev);

			retnow = true;
		}

		if (IsVideoFastForwarding ())

		{
			OnVideoFastForward (ev);

			retnow = true;
		}

		if (IsVideoPaused ())

		{
			OnVideoPause (ev);

			return;
		}

		if (IsVideoReversing ())

		{
			OnVideoReverse (ev);

			return;
		}

		if (IsVideoPlaying ())
		
		{
			OnVideoPlay (ev);

			return;
		}

		if (retnow)
			return;

		wxMessageDialog temp (this, "Already Playing an animation, \n can't play another while this is happening.", "Load Error!", wxOK);

		temp.ShowModal ();

		return;
	}

	if (IsRecording ())

	{
		wxMessageDialog temp (this, "Already Recording a Key Frame file, \n can't play while this is happening.", "Load Error!", wxOK);

		temp.ShowModal ();

		return;
	}

	setIsPlayingImgs (true);
	setIsVideoFastForwarding (false);
	setIsVideoRewinding (false);

//	m_vid_status_txt->SetLabel (wxString (vuKF_status_msg) + wxString ("Playing"));
	m_kf_status_txt->SetLabel (wxString (vuKF_status_msg) + wxString ("Playing"));

	cout << "::PlayFromImages" << endl;

	PlayFromImages ();
}

void vuKeyFramerDialog::OnVideoReverse (wxCommandEvent &ev)

{
	m_vid_play_timer.setIsReversing (!m_vid_play_timer.IsReversing ());

	m_kf_status_txt->SetLabel (wxString (vuKF_status_msg) + wxString ("Reversing"));
}

void vuKeyFramerDialog::OnVideoRewind (wxCommandEvent &ev)

{
	if (!IsVideoPlaying ())
		OnPlayFromImages (ev);

	if (IsVideoFastForwarding ())
		OnVideoFastForward (ev);

	if (IsVideoPaused ())
		OnVideoPause (ev);

	if (IsVideoReversing ())
		OnVideoReverse (ev);

	setIsVideoRewinding (!IsVideoRewinding ());

	if (IsVideoRewinding ())

	{
//		m_vid_status_txt->SetLabel (wxString (vuKF_status_msg) + wxString ("Rewinding"));
		m_kf_status_txt->SetLabel (wxString (vuKF_status_msg) + wxString ("Rewinding"));
//		m_vid_rewind_timer.Start (0);

		m_vid_play_timer.setIsRewinding (true);
	}

	else

	{
//		m_vid_status_txt->SetLabel (wxString (vuKF_status_msg) + wxString ("Playing"));
		m_kf_status_txt->SetLabel (wxString (vuKF_status_msg) + wxString ("Playing"));

		m_vid_play_timer.setIsRewinding (false);
	}
}

void vuKeyFramerDialog::OnVideoSelect (wxCommandEvent &ev)

{
	if (m_kf_txt->GetValue ())

	{
		m_kf_txt->SetValue (false);

		m_genimages->Disable ();
		m_burstplay->Disable ();
		m_record->Disable ();
		m_takeshot->Disable ();
		m_save->Disable ();

//		m_kf_bounce->Enable (true);
//		m_kf_loop->Enable (true);

		OnStop (ev);
		OnClose (ev);
	}

	else

	{
		m_kf_txt->SetValue (true);

		m_genimages->Enable (true);
		m_burstplay->Enable (true);
		m_record->Enable (true);

		m_kf_bounce->SetValue (false);
		m_kf_loop->SetValue (false);

//		m_kf_bounce->Enable (false);
//		m_kf_loop->Enable (false);

		OnVideoStop (ev);
		OnVideoClose (ev);
	}
}

void vuKeyFramerDialog::OnVideoStop (wxCommandEvent &ev)

{
	setIsPlayingImgs (false);
	setIsVideoRewinding (false);
	setIsVideoFastForwarding (false);
	setIsVideoPaused (false);

//	m_vid_status_txt->SetLabel (wxString (vuKF_status_msg));
	m_kf_status_txt->SetLabel (wxString (vuKF_status_msg));
}

//---------------------------------

void vuKeyFramerDialog::BurstPlay ()

{
	wxStopWatch twatch;

	twatch.Start (0);

	for (unsigned int i = 0; i < m_camera_vector.getLength (); i++)
		if ((mb_play) && (!mb_stop) && (!mb_pause))

		{
			*m_camera = m_camera_vector [i];

			m_Gui->DrawAgain ();
		}

	unsigned int time = twatch.Time ();

	char tchar [20];

	gcvt (time, 16, tchar);

	m_total_time->SetLabel (wxString (vuKF_render_time_msg) + wxString (tchar) + wxString (" ms"));

	float temp = float (m_camera_vector.getLength ()) / float (time);

	gcvt (temp, vuKF_precision_digits, tchar);

//	m_fm_rate->SetLabel (wxString (vuKF_frame_rate_msg) + wxString (tchar) + wxString ("/sec"));

	gcvt (m_camera_vector.getLength (), 16, tchar);

	m_frames_played_txt->SetLabel (wxString (vuKF_frames_played_msg_) + wxString (tchar));

	gcvt (float (m_camera_vector.getLength () / float (time)), vuKF_precision_digits, tchar);

	m_fm_rate_txt->SetLabel (wxString (vuKF_default_fm_rate_msg_) + wxString (tchar) + wxString ("/sec"));
}

void vuKeyFramerDialog::BurstPlayGI ()

{
	FILE* fp = NULL;
	char* line = NULL;
	char* num = NULL;

	if (IsImgsLoaded ())

	{
		wxMessageDialog temp (this, "An animation file has already been loaded.\n  Please close this file before recording to another", "Load Error!", wxOK);

		temp.ShowModal ();

		return;
	}

	if (m_Gui->getCurrentImage () == NULL)

	{
		wxMessageDialog temp (this, "No image to write to or read from \n (the method needs to tell the Key framer where it's image is, fix getCurrentMethod ()'s return value...).", "Play Error!", wxOK);

		temp.ShowModal ();

		return;
	}

	int time = 0;
	int time2 = 0;

	char time_str [20];

//	if (!IsImgsLoaded ())
		fp = OpenGIFile (true);
//	else
//		fp = m_imgfp;

	if (fp == NULL)

	{
		cout << "file does not exist " << endl;

		return;
	}

	line = new char [512];
	num = new char [15];

	char *ttime;

	ttime = (char *) (m_time_delay->GetValue ().c_str ());

	vuCamera *f_camera_1 = m_camera_vector [0]->create_new ();
	vuCamera *f_camera_2 = m_camera_vector [0]->create_new ();

	if ((f_camera_1 == NULL) || (f_camera_2 == NULL))
		return;

	m_camera->set_defaults ();
	cout << "set_defaults ():" << endl;

	char strinc [8];

	strncpy (strinc, m_time_delay->GetValue ().c_str (), 7);

	float tinc = atof (strinc);

	if (tinc <= 0)

	{
		wxMessageDialog temp (this, "A video cannot be generated with a non-positive frame rate. \n Please input a valid (positive frame rate) and try again in order to generate your video.", "Pllay Error!", wxOK);

		temp.ShowModal ();

		return;
	}

	int fr = 0;

	int play_counter = 0;

	wxStopWatch totalTimer;

	totalTimer.Start (0);

	int counter = 0;

	float frame = - 1.0 / float (tinc);

	cout << int ((m_time_vector.getLength () - 1) * int (tinc) - 1) << endl;
//	for (float t = 0.0; t < m_time_vector [m_time_vector.getLength () - 1]; t += tinc)
	for (counter = 0; counter < int ((m_time_vector.getLength () - 2) * int (tinc)); counter++)
		if ((mb_play) && (!mb_stop) && (!mb_pause))

		{
			play_counter ++;

//			float frame = get_frame_number (t);
//			fr = int (frame);
			frame += 1.0 / float (tinc);
			fr = int (frame);

			float t = (frame - float (fr)) * (m_time_vector [fr + 1] - m_time_vector [fr]) + m_time_vector [fr];

			f_camera_1->operator= (m_camera_vector [fr]);
			f_camera_2->operator= (m_camera_vector [fr + 1]);

			cout << ":t:" << m_time_vector [fr] << ":t:" << m_time_vector [fr + 1] << endl;

			m_camera->operator= (interpolate (f_camera_1, f_camera_2, t, m_time_vector [fr], m_time_vector [fr + 1]));

			gcvt (t, 10, num);
			strcpy (line, num);
			strcat (line, ", ");
			strcat (line, m_img_fstart);
			gcvt (m_currentframe, 10, num);
			strcat (line, num);
			strcat (line, ".ppm\n");

			fputs (line, fp);

			strcpy (line, m_img_fstart);
			strcat (line, num);
			strcat (line, ".ppm");

			m_PPMHandler.SaveImage (line, *(m_Gui->getCurrentImage ()));

			m_currentframe++;

			m_Gui->DrawAgain ();

			time2 = int (totalTimer.Time ());
			time = int (1000.0 * time2);

			gcvt (time, vuKF_precision_digits, time_str);

			m_total_time->SetLabel (wxString (vuKF_render_time_msg) + vuString (time_str).c_str () + " ms");
		}

	if (fp != NULL)
		fclose (fp);

	unsigned int ttim = totalTimer.Time ();

	char tchar [20];

	gcvt (ttim, 16, tchar);

	m_total_time->SetLabel (wxString (vuKF_render_time_msg) + wxString (tchar) + wxString (" ms"));

	gcvt (play_counter, 16, tchar);

	m_frames_played_txt->SetLabel (wxString (vuKF_frames_played_msg_) + wxString (tchar));

	delete [] f_camera_1;
	delete [] f_camera_2;
}

void vuKeyFramerDialog::LoadFunc ()

{
	wxString tstring;// ("*.vcf", 5);

	wxFileDialog KFfdlg (this, vuKF_default_vuKFFileDlg_msg_, wxString (vuKF_default_keyframe_save_dir_), "", vuKF_default_recorded_ext_);

	if (KFfdlg.ShowModal () == wxID_CANCEL)
		return;

	tstring = KFfdlg.GetPath ();

	char* tcstr = (char *) (tstring.c_str ());

	ifstream temp (tcstr);

	if (!temp.good ())

	{
//		cout << "vuKeyFramer::OnLoad :: could not open file: " << tcstr << endl;
		char tstr [100];

		strcpy (tstr, "Could not open file: ");
		strcat (tstr, tcstr);

		wxMessageDialog temp (this, tstr, "Load Error!", wxOK);
		temp.ShowModal ();

		return;
	}

	temp.close ();

	tstring = vuKF_default_curr_loaded_msg;
	tstring += KFfdlg.GetFilename ();

	m_loaded_txt->SetLabel (tstring);

	m_camera_vector.removeRange (0, m_camera_vector.getLength ());
	m_time_vector.removeRange (0, m_time_vector.getLength ());

	if (!load_WithTime (tcstr, m_camera, m_camera_vector, m_time_vector))

	{
		char tstr [100];

		strcpy (tstr, "Could not parse file: ");
		strcat (tstr, tcstr);
		strcat (tstr, ",\n This is not a valid key frame file");

		wxMessageDialog temp (this, tstr, "Load Error!", wxOK);
		temp.ShowModal ();

		return;
	}

	setIsLoaded (true);
}

void vuKeyFramerDialog::PlayFromImages (bool fromevttimer)

{
	if (m_Gui->getCurrentImage () == NULL)

	{
		wxMessageDialog temp (this, wxString ("This method couldn't find the buffer that was associated with it.  \n This will now end."), "Can't find buffer!", wxOK);
		temp.ShowModal ();

		return;
	}

	FILE *fp;

	if (!IsImgsLoaded ())
		fp = OpenGIFile (false);
	else
		fp = m_imgfp;

	if (fp == NULL)

	{
		cout << "File could not be opened" << endl;

		return;
	}

	fseek (fp, 0, SEEK_SET);

	for (int i = 0; i < 5; i++)
		m_play_video_times [i] = 0.0;

	m_play_video_frame = 0;
	m_play_video_size = -1;
	m_vid_play_timer.Start (1);

	m_vid_play_timer.setMaxTime (int (1000.0 * ttimevector [ttimevector.getLength () - 1]));

	m_play_video_ttime = 0.0;

//	m_vid_status_txt->SetLabel (wxString (vuKF_status_msg) + wxString ("Playing"));
	m_kf_status_txt->SetLabel (wxString (vuKF_status_msg) + wxString ("Playing"));

//--------------------------

	PlayNextImage ();
}

void vuKeyFramerDialog::PlayFunc ()

{
	wxCommandEvent tmpevent;

	if (!IsLoaded ())
		OnLoad (tmpevent);


	if (m_camera_vector.getLength () == 0)
		return;

	m_currentframe = 0;

	if (m_genimages->GetValue ())

	{
		BurstPlayGI ();

		setIsPlaying (false);

		return;
	}

	if (m_burstplay->GetValue ())

	{
		BurstPlay ();

		setIsPlaying (false);

		return;
	}

	setIsPlaying (true);
	setIsPaused (false);
	setIsStopped (false);
	setIsRecording (false);

	m_playwatch.setMaxTime (int (1000.0 * m_time_vector [m_time_vector.getLength () - 1]));

	PlayInTime ();
}

void vuKeyFramerDialog::PlayInTime ()

{
	if (!IsPlaying ())
		return;

	m_play_time = 0.0;

	m_play_timer.getElapsedTimeFloat ();

	if (m_camera_vector.getLength () == 0)
		return;

	if (m_play_camera_1 != NULL)
		delete [] m_play_camera_1;

	if (m_play_camera_2 != NULL)
		delete [] m_play_camera_2;

	m_play_camera_1 = m_camera_vector [0]->create_new ();
	m_play_camera_2 = m_camera_vector [0]->create_new ();

	for (int i = 0; i < 5; i++)
		m_play_times [i] = 0.0;

	m_play_counter = 0;

	m_playwatch.Start(0);

	m_kf_status_txt->SetLabel (wxString (vuKF_status_msg) + wxString ("Playing"));

	PlayNextFrame ();
}

void vuKeyFramerDialog::PlayNextFrame ()

{
	if (!IsPlaying ())
		return;

	if (IsPaused ())

	{
		m_kf_status_txt->SetLabel (wxString (vuKF_status_msg) + wxString ("Paused"));

		((vuEvtGenerator *) (m_PlayTimer))->Start (vuKF_regular_pause_delay, true);

		return;
	}

	if (m_playwatch.IsRewinding ())

	{
		m_kf_status_txt->SetLabel (wxString (vuKF_status_msg) + wxString ("Rewinding"));
		setIsRewinding (true);
	}

	if (m_playwatch.IsFastForwarding ())

	{
		m_kf_status_txt->SetLabel (wxString (vuKF_status_msg) + wxString ("Fast Forwarding"));
		setIsFastForwarding (true);
	}

	if (m_playwatch.IsReversing ())

	{
		m_kf_status_txt->SetLabel (wxString (vuKF_status_msg) + wxString ("Reversing"));
		setIsKFReversing (true);
	}

	if ((!m_playwatch.IsReversing ()) && (!m_playwatch.IsRewinding ()) && (!m_playwatch.IsFastForwarding ()))
		m_kf_status_txt->SetLabel (wxString (vuKF_status_msg) + wxString ("Playing"));

	int ttemp;

	int frame;
	float fr;
	float frate;

	ttemp = m_playwatch.Time ();

	wxCommandEvent ev;

	for (int i = 0; i < 4; i++)
		m_play_times [i] = m_play_times [i + 1];

	m_play_time = float (ttemp) / 1000.0;
//	m_play_times [4] = m_play_time;
	m_play_times [4] = float (m_playwatch.TotalTime ()) / 1000.0;

	m_playwatch.setMaxTime (int (1000.0 * m_time_vector [m_time_vector.getLength () - 1]));

	if (m_play_time < m_time_vector [m_time_vector.getLength () - 1] && (!IsPaused ()) && (!IsStopped ()))

	{
		fr = get_frame_number (m_play_time);
		frame = int (fr);

		cout << "frame = " << frame << endl;

		if ((frame > int (m_camera_vector.getLength () - 2)) || (fr < 0))
			*m_camera = *(m_camera_vector [frame]);
		else

		{
			m_play_camera_1->operator= (m_camera_vector [frame]);
			m_play_camera_2->operator= (m_camera_vector [frame + 1]);

			cout << ":t:" << m_time_vector [frame] << ":t:" << m_time_vector [frame + 1] << endl;

			*m_camera = interpolate (m_play_camera_1, m_play_camera_2, m_play_time, m_time_vector [frame], m_time_vector [frame + 1]);
//			*m_camera = m_play_camera_1;
		}

		m_Gui->DrawAgain ();

		char time [16];
		gcvt (float (m_playwatch.TotalTime ()) / 1000.0, vuKF_precision_digits, time);

		wxString timstr = vuKF_render_time_msg;
		timstr += time;
		timstr += " sec";

		m_total_time->SetLabel (timstr);

//		if (++m_play_counter > 4)

//		{
			if (++m_play_counter > 4)
				frate = 5.0 / (m_play_times [4] - m_play_times [0]);
			else
				frate = float (m_play_counter) / (m_play_times [4]);

			gcvt (frate, vuKF_precision_digits, time);

			timstr = vuKF_frame_rate_msg;
			timstr += time;
			timstr += "/second";

			m_fm_rate_txt->SetLabel (timstr);
//		}

		gcvt (float (m_play_counter), vuKF_precision_digits, time);
		timstr = vuKF_frames_played_msg_;
		timstr += time;

		m_frames_played_txt->SetLabel (timstr);

		((vuEvtGenerator *) (m_PlayTimer))->Start (vuKF_play_delay, true);

		return;
	}

	else

	{
		if ((!IsKFBouncing ()) && (!IsKFLooping ()))
			setIsPlaying (false);
	}

	if ((IsKFLooping ()) || (IsKFBouncing ()))

	{
		((vuEvtGenerator *) (m_PlayTimer))->Start (vuKF_play_delay, true);

		return;
	}

	cout << "stopping\n";

	setIsPlaying (false);

	m_kf_status_txt->SetLabel (wxString (vuKF_status_msg));

	delete [] m_play_camera_1;
	delete [] m_play_camera_2;

	m_play_camera_1 = NULL;
	m_play_camera_2 = NULL;
}

void vuKeyFramerDialog::PlayNextImage ()

{
	if (!mb_play_from_images)
		return;

	if (IsVideoPaused ())

	{
//		m_vid_status_txt->SetLabel (wxString (vuKF_status_msg) + wxString ("Paused"));
		m_kf_status_txt->SetLabel (wxString (vuKF_status_msg) + wxString ("Paused"));

		((vuEvtGenerator *) (m_PlayTimer))->Start (vuKF_regular_pause_delay, true);

		return;
	}

	if (m_vid_play_timer.IsRewinding ())

	{
//		m_vid_status_txt->SetLabel (wxString (vuKF_status_msg) + wxString ("Rewinding"));
		m_kf_status_txt->SetLabel (wxString (vuKF_status_msg) + wxString ("Rewinding"));

//		setIsVideoRewinding (true);
	}

	if (m_vid_play_timer.IsReversing ())

	{
//		m_vid_status_txt->SetLabel (wxString (vuKF_status_msg) + wxString ("Reversing"));
		m_kf_status_txt->SetLabel (wxString (vuKF_status_msg) + wxString ("Reversing"));
//		setIsVideoReversing (true);
	}

	if (m_vid_play_timer.IsFastForwarding ())

	{
//		m_vid_status_txt->SetLabel (wxString (vuKF_status_msg) + wxString ("Fast Forwarding"));
		m_kf_status_txt->SetLabel (wxString (vuKF_status_msg) + wxString ("Fast Forwarding"));
//		setIsVideoFastForwarding (true);
	}

	if ((!m_vid_play_timer.IsReversing ()) && (!m_vid_play_timer.IsFastForwarding ()) && (!m_vid_play_timer.IsRewinding ()))
//		m_vid_status_txt->SetLabel (wxString (vuKF_status_msg) + wxString ("Playing"));
		m_kf_status_txt->SetLabel (wxString (vuKF_status_msg) + wxString ("Playing"));

	char fm_rate_str [10];
	float calc_time;
	wxString twxstr;

	FILE *currfp;

	int k64 = 0x10000; //int (pow (2, 16));

	debugtimer.Start (0);

	for (int z = 0; z < 4; z++)
		m_play_video_times [z] = m_play_video_times [z + 1];

	int ttime = m_vid_play_timer.Time ();

//	m_vid_play_timer.setMaxTime (int (1000.0 * ttimevector [ttimevector.getLength () - 1]));
//	cout << "ttimevector.length (): " << ttimevector.getLength () << endl;

//	cout << "maxtime: " << ttimevector [ttimevector.getLength () - 1] << endl;

	m_play_video_ttime = float (ttime) / 1000.0;

	m_play_video_times [4] = float (m_vid_play_timer.TotalTime ()) / 1000.0;

	if (m_play_video_frame >= int (ttimevector.getLength ()))
		m_play_video_frame = int (ttimevector.getLength ()) - 1;

	while ((m_play_video_ttime < ttimevector [m_play_video_frame]) && (m_play_video_frame > 0))
		m_play_video_frame--;

	while ((m_play_video_ttime > ttimevector [m_play_video_frame]) && (m_play_video_frame < int (ttimevector.getLength () - 1)))
		m_play_video_frame++;


		/* This next section looks a little bit strange, but it actually seems
			to provide a small performance boost to the method...
			I attribute this to the fact that I'm now only doing 1 fread ()
			in place of 2...

			but I originally performed this to allow for an attempt to
			try a double buffered asynchronous read which would provide
			extra speed by doing to the blit during the read and then waiting
			for the read to finish before going to the next one...  I will
			still try to do that.
		*/

	if (m_play_video_size == -1)

	{
		delete [] m_play_video_buf;

		(m_Gui->getCurrentImage ())->set_extents (0, 0);
		(m_Gui->getCurrentImage ())->elim_data (NULL);

		cout << (int ) ((void*) tfilenamevector [m_play_video_frame]) << endl;
		m_PPMHandler.ReadImage (tfilenamevector [m_play_video_frame], *(m_Gui->getCurrentImage ()), 1);
		cout << tfilenamevector [m_play_video_frame] << endl;

		int x, y;

		m_Gui->getCurrentImage ()->get_extents (x, y);

		m_play_video_size = 18 + 3 * x * y;

		m_play_video_buf = new char [m_play_video_size];
	}

	else

	{
		int newcount = 0;
		currfp = fopen (tfilenamevector [m_play_video_frame], "r");
//		cout << tfilenamevector [m_play_video_frame] << endl;

			/* 	This commented out open code works, and if I could figure out how
				to do so, I could get a non-blocking file read, which might speed things
				up a little bit...

				Unfortuneately though, I think that for the ultimate speed up I'm
				going to have to go to a compressed format since most of the time seems
				to be taken up in actually reading the file... and if I could minimize
				the ammount of data read, without drastically increasing the length of
				time it took to process the data, I should be okay, and it should be faster...*/

//		int fd = open (tfilenamevector [counter], O_RDONLY | O_SYNC);

//		if (fd > -1)
		if (currfp != NULL)

		{
//			fread (buf, 1, size, currfp);
			while (newcount + k64 < m_play_video_size)

			{
//				read (fd, buf + newcount, k64);
				fread (m_play_video_buf + newcount, 1, k64, currfp);
				newcount += k64;
			}

//			read (fd, buf + newcount, size - newcount);
			fread (m_play_video_buf + newcount, 1, m_play_video_size - newcount, currfp);

			m_PPMHandler.ReadImageFromBuffer (m_play_video_buf, *(m_Gui->getCurrentImage ()), 1);

//			close (fd);
			fclose (currfp);
		}
	}

//	cout << "reading the file took: " << debugtimer.Time () << '\n';
	debugtimer.Start (0);

	float ntime = ttimevector [m_play_video_frame];

//	m_play_video_ttime = m_vid_play_timer.Time () / 1000.0;
	m_play_video_ttime = float (ttime) / 1000.0;

	m_Gui->DrawFromImage ();

//	cout << "drawing the image took: " << debugtimer.Time () << '\n';
	debugtimer.Start (0);

	m_play_video_frame++;

	if (m_play_video_frame >= int (ttimevector.getLength ()))
		m_play_video_frame = ttimevector.getLength () - 1;

//	cout << "time is:" << m_play_video_ttime << '\n';

	if (m_play_video_frame > 4)

	{
		calc_time = 5 / (m_play_video_times [4] - m_play_video_times [0]);

		gcvt (calc_time, vuKF_precision_digits, fm_rate_str);

		twxstr = vuKF_frame_rate_msg;
		twxstr += fm_rate_str;
		twxstr += "/sec";

//		m_vid_fm_rate_txt->SetLabel (twxstr);
		m_fm_rate_txt->SetLabel (twxstr);

//		calc_time = spdtimer.Time ();
		calc_time = m_vid_play_timer.TotalTime ();

		gcvt (calc_time, vuKF_precision_digits, fm_rate_str);

		twxstr = vuKF_render_time_msg;
		twxstr += fm_rate_str;
		twxstr += " ms";

//		m_vid_total_time_txt->SetLabel (twxstr);
		m_total_time->SetLabel (twxstr);

		gcvt (m_play_video_frame, 16, fm_rate_str);

//		m_vid_frames_played_txt->SetLabel (wxString (vuKF_frames_played_msg_) + wxString (fm_rate_str));
		m_frames_played_txt->SetLabel (wxString (vuKF_frames_played_msg_) + wxString (fm_rate_str));
	}

	if ((m_play_video_frame < int (ttimevector.getLength () - 1)) || (m_kf_bounce->GetValue ()) || (m_kf_loop->GetValue ()))
//	if ((m_play_video_frame < int (ttimevector.getLength () - 1)) || (m_vid_bounce->GetValue ()) || (m_vid_loop->GetValue ()))

	{
		if ((m_kf_bounce->GetValue ()) || (m_kf_loop->GetValue ()))

		{
			((vuEvtGenerator *) (m_PlayTimer))->Start (int ((1.0 / float (vuKF_spd_mul)) * (ntime - m_play_video_ttime - 0.001) * 1000.0), true);

			return;
		}

		if (m_play_video_frame >= int (ttimevector.getLength () - 2))

		{
			((vuEvtGenerator *) (m_PlayTimer))->Start (1, true);

			return;
		}

		if ((IsVideoFastForwarding ()) && (m_play_video_frame < int (ttimevector.getLength ())))

		{
			((vuEvtGenerator *) (m_PlayTimer))->Start (int ((1.0 / float (vuKF_spd_mul)) * (ntime - m_play_video_ttime - 0.001) * 1000.0), true);

			return;
		}

		if (((IsVideoRewinding ())|| (IsVideoRewinding ())) && (m_play_video_frame > 0))

		{
			((vuEvtGenerator *) (m_PlayTimer))->Start (int ((1.0 / float (vuKF_spd_mul)) * (ntime - m_play_video_ttime - 0.001) * 1000.0), true);

			return;
		}

		if ((IsVideoRewinding ()) || (IsVideoFastForwarding ())|| (IsVideoReversing ()))

		{
			setIsPlayingImgs (false);

			return;
		}

		((vuEvtGenerator *) (m_PlayTimer))->Start (int ((1.0 / float (vuKF_spd_mul)) * (ntime - m_play_video_ttime - 0.001) * 1000.0), true);

		return;
	}

	setIsPlayingImgs (false);
}

void vuKeyFramerDialog::RecordFunc ()

{
	m_camera_vector.removeRange (0, m_camera_vector.getLength());
	m_time_vector.removeRange (0, m_time_vector.getLength ());

	wxString tstring;// ("*.ppm", 5);// = m_rec_fname->GetValue ();
	wxFileDialog KFfdlg (this, vuKF_default_vuKFFileDlg_msg_, vuKF_default_keyframe_save_dir_, "", vuKF_default_recorded_ext_);

	if (KFfdlg.ShowModal () == wxID_CANCEL)
		return;

	tstring = KFfdlg.GetPath ();

	char* tcstr = (char *) (tstring.c_str ());

	cout << "OnRECORD " << tcstr << endl;

//	mb_record = true;
	setIsRecording (true);
//	m_camera->record (tcstr);
	record_with_time (tcstr, (*m_camera));

	tstring = vuKF_default_curr_loaded_msg;
	tstring += KFfdlg.GetFilename ();

	m_loaded_txt->SetLabel (tstring);

	m_kf_status_txt->SetLabel (wxString (vuKF_status_msg) + wxString ("Recording"));

	m_timer.getElapsedTimeFloat ();
	time_t = 0.0;
}

void vuKeyFramerDialog::RecordInTime ()

{
	if ((mb_pause) || (!mb_record) || (!m_autoshot->GetValue ()))
		return;

	wxCommandEvent tempevt;

	OnTakeShot (tempevt);
}

void vuKeyFramerDialog::SaveFunc (bool writechanges)

{
	if (m_camera->IsRecording ())

	{
		for (int i = 0; i < int (m_time_vector.getLength ()), i < int (m_camera_vector.getLength ()); i++)

		{
			if (writechanges)

			{
				*m_camera = m_camera_vector [i];
//				TakeSnapShotWithTime (m_time_vector [i], *m_camera);
				TakeSnapShotWithTime (float (i), *m_camera);
			}

			delete [] m_camera_vector [i];
		}

		m_time_vector.removeRange (0, m_time_vector.getLength () - 1);
		m_camera_vector.removeRange (0, m_camera_vector.getLength () - 1);

		m_camera->stop_recording ();
	}

	setIsRecording (false);
	setIsPlaying (false);
	setIsLoaded (false);

	m_loaded_txt->SetLabel (wxString (vuKF_default_curr_loaded_msg));
}

//----------------------------------

void vuKeyFramerDialog::rebuildCustomSizer()
{
    if(!m_CustomSizer) return;
    //remove all elements from the sizer
    while(m_CustomSizer->Remove(0)) {};
    buildCustomSizer();
    //Set the Dialog up to use the sizers
    //SetSizer(m_MainSizer);
    //SetAutoLayout(true);
    m_CustomSizer->Layout();	// recalc layout
    m_MainSizer->Layout();
    m_MainSizer->SetSizeHints(this);
    m_MainSizer->Fit(this);

    //m_CustomSizer->Layout();	// recalc layout
}

//----------------------------------

int vuKeyFramerDialog::bisect_time_vector_search (float time, int start, int finish)

{
	if (start == finish)
		return start;
	if (start == finish - 1)
		return start;

	int middle = finish - start;
	middle /= 2;
	middle += start;

	if (m_time_vector [middle] > time)
		return bisect_time_vector_search (time, start, middle);

	return bisect_time_vector_search (time, middle, finish);
}

void vuKeyFramerDialog::clear_vectors ()

{
	for (int i = 0; i < int (m_camera_vector.getLength ()); i++)
		delete [] m_camera_vector [i];

	m_camera_vector.removeRange (0, m_camera_vector.getLength () - 1);
	m_time_vector.removeRange (0, m_time_vector.getLength () - 1);
}

float vuKeyFramerDialog::get_frame_number (float time)

{
	int frame = bisect_time_vector_search (time, 0, m_time_vector.getLength () - 1);

	if (frame < 0)
		return 0;

	if (frame > int (m_time_vector.getLength ()) - 2)
		return float (frame);

	float t0 = m_time_vector [frame];
	float t1 = m_time_vector [frame + 1];

	float fr = float (frame);

	fr += (time - t0) / (t1 - t0);

	cout << "time " << time << " frame " << frame << " fr " << fr << endl;

	if (fr < 0)
		fr = 0.0;

	if (fr > float (m_time_vector.getLength () - 1))
		fr = float (m_time_vector.getLength () - 1);

	return fr;
}

FILE* vuKeyFramerDialog::OpenGIFile (bool write)

{
	if (IsImgsLoaded ())

	{
/*		wxMessageDialog temp (this, "An animation file has already been loaded.\n  Please close this file before loading another", "Load Error!", wxOK);

		temp.ShowModal ();

		return m_imgfp;*/
		wxCommandEvent tev;

		OnVideoClose (tev);
	}

	wxString tstring;

	wxFileDialog KFfdlg (this, wxString ("Select where you wish image information to be saved to"), wxString (vuKF_default_keyframe_save_dir_), wxString (""), wxString (vuKF_default_animated_ext_));
	if (KFfdlg.ShowModal () == wxID_CANCEL)
		return NULL;

	tstring = KFfdlg.GetPath ();

	char* tcstr = (char *) (tstring.c_str ());

	if (m_img_fstart == NULL)
		m_img_fstart = new char [256];

	strcpy (m_img_fstart, tcstr);

	m_img_fstart [strlen (m_img_fstart) - 4] = '\0';

	wxString twxstr = vuKF_default_curr_loaded_msg;
	twxstr += tcstr;

//	tstring = vuKF_default_curr_loaded_msg;
	tstring = KFfdlg.GetDirectory ();
	tstring += KFfdlg.GetFilename ();

//	m_vid_loaded_txt->SetLabel (tstring);
	m_loaded_txt->SetLabel (wxString ("Currently Loaded:") + KFfdlg.GetFilename ());

	if (write)

	{
		m_imgfp = fopen (tcstr, "w");
//		m_vid_loaded_txt->SetLabel (twxstr);
//		m_loaded_txt->SetLabel (twxstr);
		m_loaded_txt->SetLabel (wxString (vuKF_default_curr_loaded_msg) + KFfdlg.GetFilename ());
		return m_imgfp;
	}

	m_imgfp = fopen (tcstr, "r");

	if (m_imgfp == NULL)

	{
		cout << "Couldn't open the header" << endl;

		cout << tstring.c_str () << endl;

		return NULL;
	}

	char cbuf [256];	// it's signed for IRIX...  cgs

	int position;
	int tpos;
	char* tbuf;

	setIsImgsLoaded (true);

	cout << "OpenGIFilea" << endl;

	cbuf [0] = 'a';

	while ((cbuf [0] != EOF) && (cbuf [0] != '\0'))

	{
		cbuf [0] = fgetc (m_imgfp);

		fgets (cbuf + 1, 255, m_imgfp);

		cout << "cbuf:" << cbuf << endl;

		if (cbuf [0] != EOF)

		{
			position = clear_blanks (cbuf);

			float ntime = atof (&(cbuf [position]));

			ttimevector.add (ntime);

			position += get_next_comma (&(cbuf [position])) + 1;

			position += clear_blanks (&(cbuf [position]));

			tpos = position;

			while ((cbuf [tpos] != '\0') && (cbuf [tpos] != '\n'))
				tpos++;

			cbuf [tpos] = '\0';

			tbuf = new char [strlen (&(cbuf [position])) + 1];

			cout << "tbuf:" << (unsigned int) ( (void*) (tbuf)) << endl;
			strcpy (tbuf, &(cbuf [position]));

			tfilenamevector.add (tbuf);
		}
	}

	return m_imgfp;
}

//------------------------------------

void vuKeyFramerDialog::TimerEvent ()

{
	if (mb_play_from_images)
		PlayNextImage ();

	if (mb_play)
		PlayNextFrame ();

	if (mb_record)
		RecordInTime ();
}










