/** Canvas for the key framer to display the chart of frames in time...
*/

#ifndef _vuKeyFramerCanvas_h_
#define _vuKeyFramerCanvas_h_

#include <wx/wx.h>
#include "../vuGLCanvas.h"
#include "vuSimpleTypes.h"

/**	This is supposed to diplay the chart of frames in time... I don't have
	time to complete it now...

	\todo everything in this (add the ability to draw icons in the time access
 	representing the frame. */
class vuKeyFrameCanvas : public vuGLCanvas
{
public:
    vuKeyFrameCanvas(wxWindow *parent,wxWindowID id=-1,bool edit=false);
    //!The destructor.
    ~vuKeyFrameCanvas();

    //!Returns the transfer function displayed by the canvas.
    //!Sets the transfer function to display on the canvas.
    void setTransferFunc();

    //!Returns the active control node, or 0 if there is none.
    //!Sets the active control node to the given value.

    //!Returns the active colour
    //!Sets the active colour node to the given value.

    //!Sets the smoothing of the transfer function.
    void setSmoothing(float opacity, float colour);

protected:
    //!Initializes openGL for the transfer function canvas
    bool glInit();
    //!Renders the transfer function.
    void render();
    //!Sets up the coordinates for the canvas.
    void resize();
    //!Handles the mouse commands.
    void OnMouse(wxMouseEvent &ev);

    //!Helper function that posts the passed in event to the event handler
    void postEvent(wxEventType ev);

protected:
    //!The transfer function being shown in the Canvas.
    //!Whether the transfer function is editeable or not.
    bool m_Edit;

    //!The coordinates of the screen.
    float m_xScreenMin, m_xScreenMax, m_yScreenMin, m_yScreenMax;
    //!Grid widths and heights in graph coordinates
    float m_dx, m_dy;

    //!The opacity node selected, if any (if none then value is -1).
    dword m_Opacity;
    //!The colour node selected, if any (if none then value is -1).
    dword m_Colour;

protected:
    //!These are the ranges for the graph, ie the scales on the axes.
    const dword m_xMin;
    const dword m_xMax;
    const float m_yMin;
    const float m_yMax;

    //!Indicates whether spectral colours are to be designed or RGBa
    bool m_DoSpectral;

    DECLARE_EVENT_TABLE()
};

//!These are the event identifiers for vuKeyFrameCanvas events
enum
{
    //!A control node has been selected
    vuEVT_TRANSFER_NODE_SELECT = 12000,

    //!A control node has been double clicked
    vuEVT_TRANSFER_NODE_OPEN,

    //!The transfer function has changed
    vuEVT_TRANSFER_CHANGE
};



#endif

