#include "vuKeyFrameCanvas.h"
#include "vuColourRGBa.h"
//#include "../vuTransferDialog/vuTransferDialog.h"
#include <GL/gl.h>
#include <GL/glu.h>
#include <math.h>

BEGIN_EVENT_TABLE(vuKeyFrameCanvas, vuGLCanvas)
    EVT_MOUSE_EVENTS(vuKeyFrameCanvas::OnMouse)
END_EVENT_TABLE()

//----------------------------------------------------------------------------
//------------------------- The constructor ----------------------------------
//----------------------------------------------------------------------------

vuKeyFrameCanvas::vuKeyFrameCanvas(wxWindow *parent,wxWindowID id,bool edit)
  : vuGLCanvas(parent,id,wxDefaultPosition,wxDefaultSize,0,"vuKeyFrameCanvas",NULL)
    , m_Edit(edit),m_xMin(0),m_xMax(255),m_yMin(0),m_yMax(1)
{
    m_Opacity = m_Colour = (dword) -1;

    m_xScreenMin = m_xMin;
    m_xScreenMax = m_xMax;
    m_yScreenMin = m_yMin;
    m_yScreenMax = m_yMax;

}

//----------------------------------------------------------------------------
//------------------------- The destructor -----------------------------------
//----------------------------------------------------------------------------

vuKeyFrameCanvas::~vuKeyFrameCanvas()
{
}

//----------------------------------------------------------------------------
//------------------------- public: setOpacitiesmoothing() -------------------
//----------------------------------------------------------------------------

void vuKeyFrameCanvas::setSmoothing(float opacity, float colour)
{
    redraw();
}


//----------------------------------------------------------------------------
//------------------------- protected: glInit() ------------------------------
//----------------------------------------------------------------------------

bool vuKeyFrameCanvas::glInit(void)
{
    glClearColor(0.0f, 0.0f, 0.0f, 0.0f);

    //Set up the coordinate system.
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    gluOrtho2D(m_xScreenMin,m_xScreenMax,m_yScreenMin,m_yScreenMax);

    return true;
};

//----------------------------------------------------------------------------
//------------------------- protected: resize() ------------------------------
//----------------------------------------------------------------------------

void vuKeyFrameCanvas::resize()
{
    glViewport(0, 0, (GLint)getWidth(),(GLint)getHeight());

    //Recalculate the grid values
    m_dx = float(m_xMax-m_xMin) / getWidth();
    m_dy = float(m_yMax-m_yMin) / getHeight();

    if (m_Edit)
    {
        //Fix the coordinate system.
        m_xScreenMin = m_xMin-10*m_dx;
        m_xScreenMax = m_xMax+10*m_dx;
        m_yScreenMin = m_yMin-30*m_dy;
        m_yScreenMax = m_yMax+10*m_dy;

        glMatrixMode(GL_MODELVIEW);
        glLoadIdentity();
        glMatrixMode(GL_PROJECTION);
        glLoadIdentity();
        gluOrtho2D(m_xScreenMin,m_xScreenMax,m_yScreenMin,m_yScreenMax);
    }
}

//----------------------------------------------------------------------------
//------------------------- protected: render() ------------------------------
//----------------------------------------------------------------------------

void vuKeyFrameCanvas::render()
{
    glClear(GL_COLOR_BUFFER_BIT);

    //First fill in the graph.
    //Draw the colour regions
    glBegin(GL_QUADS);
    for (dword i = m_xMin; i <= m_xMax; i++)
    {
        vuColourRGBa rgba;

        glColor3fv(rgba.getData());
        glVertex2f(i-0.5,-20*m_dy);
        glVertex2f(i+0.5,-20*m_dy);
    }
    glEnd();

    //When editing, draw all the helper lines
    if (m_Edit)
    {
        //Draw the surrounding box
        glBegin(GL_LINE_LOOP);
        glColor3f(1,1,1);
        glVertex2f(m_xMin,m_yMin-20*m_dy);
        glVertex2f(m_xMax,m_yMin-20*m_dy);
        glVertex2f(m_xMax,m_yMax);
        glVertex2f(m_xMin,m_yMax);
        glEnd();

        //Draw the polyline opacity function.
        glBegin(GL_LINE_STRIP);
        glColor3f(1,1,1);
        glEnd();

        //Draw the opacity control nodes.
        {
                glColor4f(1,0.5,0.5,0.01);
                glColor4f(1,1,1,0.01);


            glBegin(GL_LINE_LOOP);
            glEnd();
        }

        //Draw the colour control nodes.
        {
                glColor4f(1,1,1,0.01);

            glBegin(GL_LINE_LOOP);
            glEnd();
        }
    }
};

//----------------------------------------------------------------------------
//------------------------- protected: OnMouse() -----------------------------
//----------------------------------------------------------------------------

void vuKeyFrameCanvas::OnMouse(wxMouseEvent &ev)
{
	int i = 0;
    if (ev.ButtonDClick() && !m_Edit)
    {
        //Pop up dialog Canvas that lets you edit

        {

            postEvent(vuEVT_TRANSFER_CHANGE);
            redraw();
        }
    }
    else if (ev.LeftDown() && m_Edit) //Select the clicked control Node
    {

        postEvent(vuEVT_TRANSFER_NODE_SELECT);
        redraw();
    }
    else if (ev.LeftDClick() && m_Edit) //Create and/or open up control Node
    {
    	unsigned int x = 0, y = 0;
        //If in the colour range, open the clicked colour node, or add a new one
        if ((m_Colour != (dword)-1))
        {
            postEvent(vuEVT_TRANSFER_NODE_OPEN);
        }
        else if (( x >= m_xMin && x <= m_xMax) && (fabs(-20*m_dy-y) < 4*m_dy))
        {
	  if(m_DoSpectral) {
	    // This has to be changed!
	  } else {
	  }
            m_Opacity = (dword)-1;

            postEvent(vuEVT_TRANSFER_CHANGE);
            postEvent(vuEVT_TRANSFER_NODE_OPEN);
            redraw();
        }
    }
    else if (ev.RightDClick() && m_Edit) //Remove control Node
    {
        //Translate click into graph coordinates
//        float x = (float(ev.GetX()) / getWidth()) * float(m_xScreenMax - m_xScreenMin) + m_xScreenMin;
  //      float y = (float(getHeight() - ev.GetY()) / getHeight()) * float(m_yScreenMax - m_yScreenMin) + m_yScreenMin;

        //Find out if there is an associated Opacity Node and remove it
        {
            {
                if (int (i) == int (m_Opacity)) m_Opacity = (dword)-1;

                postEvent(vuEVT_TRANSFER_CHANGE);
                redraw();
            }
        }

        //Find out if there is an associated colour Node and remove it
        {
            {
                if (int (i) == int (m_Colour)) m_Colour = (dword)-1;

                postEvent(vuEVT_TRANSFER_CHANGE);
                redraw();
            }
        }
    }
    else if (ev.LeftIsDown() && ev.Dragging() && m_Edit) //Drag the selected control node
    {
        //Translate into graph coordinates
    //    float x = (float(ev.GetX()) / getWidth()) * float(m_xScreenMax - m_xScreenMin) + m_xScreenMin;
      //  float y = (float(getHeight() - ev.GetY()) / getHeight()) * float(m_yScreenMax - m_yScreenMin) + m_yScreenMin;

        //Update the dragged Opacity Node, if any.
        if ((m_Opacity != (dword)-1))
        {
            postEvent(vuEVT_TRANSFER_CHANGE);
            redraw();
        }

        //Update the dragged colour Node, if any.
        if ((m_Colour != (dword)-1))
        {
            postEvent(vuEVT_TRANSFER_CHANGE);
            redraw();
        }
    }
}

//----------------------------------------------------------------------------
//------------------------- protected: postEvent() ---------------------------
//----------------------------------------------------------------------------

void vuKeyFrameCanvas::postEvent(wxEventType ev)
{
     wxCommandEvent commandEvent(ev, GetId());
     commandEvent.SetEventObject( this );
     GetEventHandler()->ProcessEvent(commandEvent);
}


