/* 	This is an event generator class that
	will allow events to be regularly generated
	for the key frame animator so that it can
	allow for brief breaks so that the user
	can pause or stop the code that is being run

	This uses the wxTimer Base class to provide
	most of the implementation

	Christopher Steinbach
	March 2002
*/

#ifndef vuEventGenerator_h__
#define vuEventGenerator_h__

#include <wx/wx.h>
#include <wx/timer.h>

class vuKeyFramerDialog;

/** 	This class will allow me to create a timer event for vuKeyFramer.

	When the Key framer instructs a timer event to occur, and when that
	event occurs, this will call the Notify () function, which will call
	the timer event function of the key framer, which will then execute
	the code that was supposed to have been executed when the timer event occured

	This is derived from wxTimer, and for the complete documentation of this,
	you should refer to www.wxwindows.org which contains the documentation
	on this product.
*/
class vuEvtGenerator : public wxTimer

{
	public:	// Constructors and destructors

		/** default constructor,

			This will seet the associated key framer to be NULL. */
		vuEvtGenerator ();

		/** destructor */
		virtual ~vuEvtGenerator ();

	public:	// member functions

		/** This is the function that will be called every time a timer
			event occurs.  This will call the associated vuKeyFramer
			Event handler... */
		virtual void Notify ();

		/** This function will set the associated key framer of this class
			to be temp (ie, on timer events, it will call temps event
			handler */
		void setKeyFramer (vuKeyFramerDialog *temp);

	private:	// member data

		/** This is a pointer to the associated key framer that this timer
			works for. */
		vuKeyFramerDialog *m_framer;
};

#endif



