#include "vuHelpPanel.h"
#include "../vuUtilityWindow.h"

#include <iostream>

enum {
  idHelpText
};

BEGIN_EVENT_TABLE(vuHelpPanel, wxDialog)
END_EVENT_TABLE();

//----------------------------------------------------------------------------
//------------------------- The constructor ----------------------------------
//----------------------------------------------------------------------------

vuHelpPanel::vuHelpPanel(wxWindow *parent)
    : wxDialog(parent, -1, wxString("Help"), wxDefaultPosition,
	       wxSize(400, 400),wxSTAY_ON_TOP|wxCAPTION/*|wxRESIZE_BORDER*/)
{
    wxSizer *sizer;

    sizer      = new wxBoxSizer(wxHORIZONTAL);
    m_textCtrl = new wxTextCtrl(this, idHelpText, wxString(""),
			        wxDefaultPosition, wxSize(380,380),
                                wxTE_MULTILINE|wxHSCROLL|wxTE_READONLY,
                                wxDefaultValidator, wxString("helpText"));
    sizer->Add(m_textCtrl);
    SetSizer(sizer);
    SetAutoLayout(true);
    sizer->Layout();
    sizer->SetSizeHints(this);
    sizer->Fit(this);

    _initFont();
}

vuHelpPanel::~vuHelpPanel()
{
  if (m_textCtrl != NULL) {
    delete m_textCtrl;
    m_textCtrl = NULL;
  }
  
}

void vuHelpPanel::setTitle(const wxString& _title)
{
  wxDialog::SetTitle(wxString("Help: ") + _title);
}

void vuHelpPanel::setHelpText(const wxString& _helpText)
{
  m_textCtrl->SetValue(_helpText);
}

// this does not seem to work
// Does anybody have an idea, how to apply a fixed font to a wxTextCtrl? -ms-
void vuHelpPanel::_initFont()
{
  wxFont myFont(10, wxMODERN, wxNORMAL, wxNORMAL,
                false, "", wxFONTENCODING_DEFAULT);
  m_textCtrl->SetFont(myFont);
}
