#include <iostream.h>
#include "vuGLCanvas.h"
#include <wx/dcclient.h>
#include "vuSimpleTypes.h"

//----------------------------------------------------------------------------
//------------------------- GLCanvas Event Table -----------------------------
//----------------------------------------------------------------------------

BEGIN_EVENT_TABLE(vuGLCanvas, wxGLCanvas)
    EVT_SIZE(vuGLCanvas::onSize)
    EVT_PAINT(vuGLCanvas::onPaint)
    EVT_ERASE_BACKGROUND(vuGLCanvas::onEraseBackground)
END_EVENT_TABLE()

//----------------------------------------------------------------------------
//------------------------- public: vuGLCanvas() -----------------------------
//----------------------------------------------------------------------------

vuGLCanvas::vuGLCanvas(wxWindow *parent, wxWindowID id, const wxPoint& pos,
    const wxSize& size, long style, const wxString& name, int* gl_attrib)
    : wxGLCanvas(parent, id, pos, size, style, name, gl_attrib)
{
    m_init = false;
    m_useOGL = true;
};

//----------------------------------------------------------------------------
//------------------------- public: enableOpenGL() ---------------------------
//----------------------------------------------------------------------------

void vuGLCanvas::enableOpenGL()
{
  m_useOGL = true;
}

//----------------------------------------------------------------------------
//------------------------- public: enableOpenGL() ---------------------------
//----------------------------------------------------------------------------

void vuGLCanvas::disableOpenGL()
{
  m_useOGL = false;
}

//----------------------------------------------------------------------------
//------------------------- protected: redraw() ------------------------------
//----------------------------------------------------------------------------

void vuGLCanvas::redraw()
{
	Refresh(false);
}

//----------------------------------------------------------------------------
//------------------------- protected: getWidth() ----------------------------
//----------------------------------------------------------------------------

int vuGLCanvas::getWidth() const
{
    return m_Width;
}

//----------------------------------------------------------------------------
//------------------------- protected: getHeight() ---------------------------
//----------------------------------------------------------------------------

int vuGLCanvas::getHeight() const
{
    return m_Height;
}

//----------------------------------------------------------------------------
//------------------------- protected: OnPaint() -----------------------------
//----------------------------------------------------------------------------

void vuGLCanvas::onPaint(wxPaintEvent& event)
{
    //Define a painting device context, as required by wxWindows.
    wxPaintDC dc(this);

    //In case the user called the redraw function before the gl context for
    //the canvas was initialized, exit the function.
    if (!GetContext()) return;

    //Set opengl to the proper gl context.
    SetCurrent();

    //If this is the first onPaint event, initialize opengl for the canvas.
    //This has to be done here because under some operating systems, such as
    //gtk, the gl context is not assigned until the window has been created.

    //changes by Steven Bergner 011002, perhaps the non-OpenGL refresh Problem can 
    //be solved better... so far this little change: (render() outside m_Init cond.)
    if (!m_init)
      {
        m_init = glInit();
	if(m_init) resize();
      }
    if (m_init) render();

    SwapBuffers();		//Swap the buffers.
    //else vuDrawTools::quitDC();		//release draw context
}

//----------------------------------------------------------------------------
//------------------------- protected: OnSize() ------------------------------
//----------------------------------------------------------------------------

void vuGLCanvas::onSize(wxSizeEvent& event)
{
    // this is also necessary to update the context on some platforms
    wxGLCanvas::OnSize(event);

    //Find out the size of the screen.
    GetClientSize(&m_Width, &m_Height);
#ifndef __WXMOTIF__
    if (GetContext())
#endif
    {
        if(m_init) {
	  SetCurrent();
	  //glViewport(0, 0, (GLint) m_Width, (GLint) m_Height);
	  resize();
	  redraw();
	}
    }
}

//----------------------------------------------------------------------------
//------------------------- protected: OnEraseBackground() -------------------
//----------------------------------------------------------------------------

void vuGLCanvas::onEraseBackground(wxEraseEvent& event) 
{};

