#ifndef _wxUIElements_vuFBRSubViewer_h_
#define _wxUIElements_vuFBRSubViewer_h_

#include "vuFBRSubCanvas.h"
#include <wx/dialog.h>
#include <wx/textctrl.h>
#include <wx/wx.h>

//! A sub viewer for Fourier Based Rendering (FBR) martin-2003-03-27

/*!
*/

template <int SIZE, class TYPE>
class vuFBRSubViewer : public vuBasicSubViewer
{
 public:
    vuFBRSubViewer(wxWindow *parent);
    ~vuFBRSubViewer();

    void setInteractive(vuSphericInteractive<SIZE,TYPE> *interactive);
 
 protected:
    //! returns an instance of vuSimpleFVRCanvas casted to (vuGLCanvas*)
    vuBasicSubViewerCanvas *getCanvas();

    //! defines the UI control elements
    void addLeftRight(wxSizer *sizer, wxWindow *control);

protected:
    vuFBRSubCanvas<SIZE,TYPE> *m_Canvas;

    //! wxWindows GUI
    wxChoice       *m_CHOICEmethod;
                
    //DECLARE_EVENT_TABLE()
};

template class vuFBRSubViewer<1,byte>;
template class vuFBRSubViewer<2,byte>;
template class vuFBRSubViewer<3,byte>;
template class vuFBRSubViewer<1,float>;
template class vuFBRSubViewer<2,float>;
template class vuFBRSubViewer<3,float>;

typedef vuFBRSubViewer<1,byte>  vuFBRSubViewer1B;
typedef vuFBRSubViewer<2,byte>  vuFBRSubViewer2B;
typedef vuFBRSubViewer<3,byte>  vuFBRSubViewer3B;
typedef vuFBRSubViewer<1,float> vuFBRSubViewer1F;
typedef vuFBRSubViewer<2,float> vuFBRSubViewer2F;
typedef vuFBRSubViewer<3,float> vuFBRSubViewer3F;

#endif /* _wxUIElements_vuFBRSubViewer_h_ */
