#include "vuFBRSubViewer.h"

#include <iostream>
#include "../vuUtilityWindow.h"
#include "../wxUtilities/vuBasicUtility.h"

#define WINDOW_TITLE "FBR"

enum {
  idCANVAS,
  idMETHOD
};

//****************************************************************************
//************************* The constructor **********************************
//****************************************************************************

template <int S, class T>
vuFBRSubViewer<S,T>::vuFBRSubViewer(wxWindow *parent)
    : vuBasicSubViewer(parent, WINDOW_TITLE)
{
  m_Canvas = new vuFBRSubCanvas<S,T>(this, idCANVAS);
  m_Canvas->SetSize(200,200);

  m_CHOICEmethod = NULL;
}

template <int S, class T>
vuFBRSubViewer<S,T>::~vuFBRSubViewer()
{
  m_Canvas       = NULL;

  m_CHOICEmethod = NULL;
}

template <int S, class T>
void vuFBRSubViewer<S,T>::setInteractive(vuSphericInteractive<S,T> *ia)
{
  m_Canvas->setInteractive(ia);
}

template <int S, class T>
vuBasicSubViewerCanvas *vuFBRSubViewer<S,T>::getCanvas()
{
  return m_Canvas;
}

template <int S, class T>
void vuFBRSubViewer<S,T>::addLeftRight(wxSizer *sizer, wxWindow *control)
{
  wxStaticBox      *borderBox   = NULL;
  wxStaticBoxSizer *borderSizer = NULL;
  wxFlexGridSizer  *flexGrid    = NULL;

  // --- file section ------------------------------------------------------

  borderBox   = new wxStaticBox(control, -1, "File", wxDefaultPosition,
				wxSize(-1,-1),wxCAPTION);
  borderSizer = new wxStaticBoxSizer(borderBox, wxVERTICAL);
  flexGrid    = new wxFlexGridSizer(2,5,5);

  // comparison method
  {
    m_CHOICEmethod = 
      new wxChoice(control, idMETHOD, wxDefaultPosition, wxSize(130,20),
		   0, NULL, wxCAPTION, wxDefaultValidator, "Method");

    m_CHOICEmethod->Append("Spatial");
    m_CHOICEmethod->Append("Spatial Delta");
    m_CHOICEmethod->Append("Freq. Ampl.");
    m_CHOICEmethod->Append("Freq. Ampl. Delta");
    m_CHOICEmethod->Append("Freq. Phase");
    m_CHOICEmethod->Append("Freq. Phase Delta");
    m_CHOICEmethod->Append("Freq. Real");
    m_CHOICEmethod->Append("Freq. Real Delta");
    m_CHOICEmethod->Append("Freq. Imag.");
    m_CHOICEmethod->Append("Freq. Imag. Delta");

    m_CHOICEmethod->SetSelection(0);
  }

  flexGrid->Add(80,10);
  flexGrid->Add(m_CHOICEmethod);
  
  borderSizer->Add(flexGrid);
  sizer->Add(borderSizer,0,wxEXPAND,5);
  sizer->Add(0,10);
}

//****************************************************************************
//************************* The vuFBRSubViewer event table ****************
//****************************************************************************

//BEGIN_EVENT_TABLE(vuFBRSubViewer, vuBasicSubViewer)
//END_EVENT_TABLE()
