#ifndef _wxUIElements_vuFBRSubCanvas_h_
#define _wxUIElements_vuFBRSubCanvas_h_

#include <wx/wx.h>
#include "vuBasicSubViewer.h"
#include "General/vuLightfield/vuFixelMap.h"
#include "Volume/Lightfield/Unimodal/Spheric/IBR/vuSphericInteractive.h"

//! Canvas for Fourier Based Rendering (FBR) martin-2003-03-27

/*!
*/

template <int SIZE, class TYPE>
class vuFBRSubCanvas : public vuBasicSubViewerCanvas
{
public:
    //!The constructor
    vuFBRSubCanvas(vuBasicSubViewer *parent, wxWindowID id=-1);
    //!The destructor.
    ~vuFBRSubCanvas();

    //! sets the rendering method
    /*! following methods are supported:
        0 ... render image (default)
	1 ... render image delta
	2 ... render frequency amplitude
	3 ... render frequency amplitude delta
	4 ... render frequency phase
	5 ... render frequency phase delta
        6 ... render frequency real part
        7 ... render frequency real part delta
        8 ... render frequency imaginary part
        9 ... render frequency imaginary part delta
     */
    void setRenderMethod(dword method);

    void setInteractive(vuSphericInteractive<SIZE,TYPE> *interactive);

    //! set image scale
    void setImageScale(float scale);

protected:
    //!Initializes openGL for the transfer function canvas
    bool glInit();
    //!Renders the transfer function.
    void render();
    //!Sets up the coordinates for the canvas.
    void resize();

    //! clear canvas
    void _clearCanvas();

    //! render image
    void _renderImage();

    void _copyDeltaImageToRGB(vuFixelMap1F *errorMap, vuFixelMap3F *rgbMap);

    void _renderImageOld();

    //! calculate the image difference
    bool _substract(vuFixelMap1F *srcImg, vuFixelMap1F* destImg);

    //!Helper function that posts the passed in event to the event handler
    void postEvent(wxEventType ev);

protected:
    vuSphericInteractive<SIZE,TYPE> *m_Interactive;

    dword            m_RenderMethod;
    vuFixelMap1F    *m_Image;
    vuFixelMap3F    *m_ImageRGB;
    float            m_ImageScale;
};

template class vuFBRSubCanvas<1,byte>;
template class vuFBRSubCanvas<2,byte>;
template class vuFBRSubCanvas<3,byte>;
template class vuFBRSubCanvas<1,float>;
template class vuFBRSubCanvas<2,float>;
template class vuFBRSubCanvas<3,float>;

typedef vuFBRSubCanvas<1,byte>  vuFBRSubCanvas1B;
typedef vuFBRSubCanvas<2,byte>  vuFBRSubCanvas2B;
typedef vuFBRSubCanvas<3,byte>  vuFBRSubCanvas3B;
typedef vuFBRSubCanvas<1,float> vuFBRSubCanvas1F;
typedef vuFBRSubCanvas<2,float> vuFBRSubCanvas2F;
typedef vuFBRSubCanvas<3,float> vuFBRSubCanvas3F;

#endif /* _wxUIElements_vuFBRSubCanvas_h_ */
