#include "vuFBRSubCanvas.h"
#include <GL/gl.h>
#include <GL/glu.h>
#include "vuSimpleFVRDialog.h"

// Constructor
template <int S, class T>
vuFBRSubCanvas<S,T>::vuFBRSubCanvas(vuBasicSubViewer *parent,wxWindowID id)
  : vuBasicSubViewerCanvas(parent,id)
{
  m_Image         = NULL;
  m_ImageRGB      = NULL;
  m_ImageScale    = 255.0f;

  m_RenderMethod  = 0; // spatial data

  m_Image = new vuFixelMap1F(200,200);

  m_Interactive = NULL;
}

// Deconstructor
template <int S, class T>
vuFBRSubCanvas<S,T>::~vuFBRSubCanvas()
{
  CHECKNDELETE(m_Image);
  CHECKNDELETE(m_ImageRGB);
  // m_Interactive is outside living
}

template <int S, class T>
void vuFBRSubCanvas<S,T>::setRenderMethod(dword method)
{
  m_RenderMethod = method;
  if (m_RenderMethod > 9) m_RenderMethod = 0;
}

template <int S, class T>
void vuFBRSubCanvas<S,T>::setImageScale(float scale)
{
  m_ImageScale = scale;
}

template <int S, class T>
void vuFBRSubCanvas<S,T>::setInteractive(vuSphericInteractive<S,T> *ia)
{
  m_Interactive = ia;
}

//----------------------------------------------------------------------------
//------------------------- protected: glInit() ------------------------------
//----------------------------------------------------------------------------

template <int S, class T>
bool vuFBRSubCanvas<S,T>::glInit(void)
{
  glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
  return true;
};

//----------------------------------------------------------------------------
//------------------------- protected: resize() ------------------------------
//----------------------------------------------------------------------------

template <int S, class T>
void vuFBRSubCanvas<S,T>::resize()
{
  if (m_Interactive) {
    vuSphericView<S,T> *view = m_Interactive->nearestView();
    if (view) view->glResize(getWidth(), getHeight());
  }
}

//----------------------------------------------------------------------------
//------------------------- protected: render() ------------------------------
//----------------------------------------------------------------------------

template <int S, class T>
void vuFBRSubCanvas<S,T>::render()
{
  if (m_Interactive) {
    vuSphericView<S,T> *view = m_Interactive->nearestView();
    if (view) view->glRender();
  }
}


//----------------------------------------------------------------------------
//------------------------- protected: postEvent() ---------------------------
//----------------------------------------------------------------------------

template <int S, class T>
void vuFBRSubCanvas<S,T>::postEvent(wxEventType ev)
{
  wxCommandEvent commandEvent(ev, GetId());
  commandEvent.SetEventObject(this);
  //commandEvent.SetClientData(&m_TFunc);
  GetEventHandler()->ProcessEvent(commandEvent);   
}
