/*!Basic class for a subwindow */
#ifndef _vuBasicSubWindow_h_
#define _vuBasicSubWindow_h_

#include "vuGLCanvas.h"
#include "../wxUtilities/vuBasicUtility.h"
#include "Volume/volume.h"

class vuBasicSubWindow : public vuGLCanvas
{
 public:
    //!constructor
    /*! \param parent parent window 
        \param Xsixe, Ysize the desired size of preview window
    */
    vuBasicSubWindow(vuBasicUtility *parent, int Xsize, int Ysize);
    //!destructor
    ~vuBasicSubWindow();

    /*! set the volume to display */
    void setVolume(vuVolume* vol);
    
    //! implementation of the virtual render function
    void render();
    
    //! our own init function
    bool glInit();

    //! mouse handler that performs the arc ball transformation
    void glOnMouse(wxMouseEvent &ev);
    
 protected:
    //! pointer to the window that owns this Preview (not used)
    vuBasicUtility *m_Parent;
    vuVolume       *m_Volume;

#ifdef WIN32
    int m_x, m_y;
#endif

DECLARE_EVENT_TABLE()

};

#endif
