#include "vuBasicSubWindow.h"
#include <math.h>
#include "vuLinAlg/vuMatrix.h"
#include "vuLinAlg/vuSpherical.h"

//----------------------------------------------------------------------------
//------------------------- vuPrewviewWin implementation ---------------------
//----------------------------------------------------------------------------

BEGIN_EVENT_TABLE(vuBasicSubWindow, vuGLCanvas)
  EVT_MOUSE_EVENTS(vuBasicSubWindow::glOnMouse)
END_EVENT_TABLE()

vuBasicSubWindow::vuBasicSubWindow(vuBasicUtility *parent,int Xsize,int Ysize)
  : vuGLCanvas(parent,-1,wxPoint(0,0),wxSize(Xsize, Ysize)), m_Parent(parent) 
{
  m_Volume = NULL;
}

vuBasicSubWindow::~vuBasicSubWindow()
{
}

void vuBasicSubWindow::setVolume(vuVolume* vol)
{
  m_Volume = vol;
}

void vuBasicSubWindow::render()
{
  if (m_Volume != NULL) {
    if (m_Volume->IsReRendering()) {
      m_Volume->render();
      m_Volume->setIsReRendering(false);
    }
  }
  else { // draw black screen
    static byte *background = NULL;

    if (background == NULL) {      
      background = new byte[16];
      for (dword i=0; i<16; i++) background[i] = 0;
    }

    glPixelZoom((float)getWidth()/4, (float)getHeight()/4);
    glDrawPixels(4, 4, GL_LUMINANCE, GL_UNSIGNED_BYTE, background);
  }
}

bool vuBasicSubWindow::glInit()
{
  if (m_Volume) {
    m_Volume->glResize(getWidth(), getHeight());
  }
  return true;
}

//----------------------------------------------------------------------------
//------------------------- protected: glOnMouse() ---------------------------
//----------------------------------------------------------------------------

void vuBasicSubWindow::glOnMouse(wxMouseEvent &ev)
{
}
