#ifndef _wxUIElements_vuBasicSubViewer_h_
#define _wxUIElements_vuBasicSubViewer_h_

#include "vuGLCanvas.h"
#include "General/vuMisc/vuString.h"
#include <wx/dialog.h>
#include <wx/wx.h>

//! A basic sub viewer for the utilities, martin-2003-03-27

/*! It mainly displays an arbitrary glCanvas and a bunch of UI control
    elements to the left or to the right of the canvas.

    The glCanvas and the UI elements can be defined by subclasses via 
    addCanvas() and addLeftRight(wxSizer,wxWindows) resp.

    The UI control elements can be shown or hidden by double-clicking
    the canvas with the left mouse key. By double-clicking the right
    mouse key the canvas and the parent.canvas can be made equal in
    size.
*/

class vuBasicSubViewerCanvas;

class vuBasicSubViewer : public wxDialog
{
 public:
    vuBasicSubViewer(wxWindow *parent, vuString title="");
    ~vuBasicSubViewer();

    //! this method creates the whole SubViewer
    //! \note this method MUST be called immediataly after instantiation
    void init(bool showControl=true);

    //! redraws the canvas
    void redraw();

    void glOnMouse(wxMouseEvent &event);

    // is the control gui visible?
    bool isControlVisible();

    // shows or hides the control gui (to the left or right of the canvas)
    void showControl(bool doShow=true);

 protected:
    // following methods should be overridden by subclasses:

    /*! returns a "newed" instance of a vuBasicSubViewerCanvas
      (subclass responsibility)
    */
    virtual vuBasicSubViewerCanvas *getCanvas() = 0;

    /*! adds all UI control elements that should appear to the left or to
        the right of the canvas (subclass responsibility)
    */
    virtual void addLeftRight(wxSizer *verSpacer, wxWindow *control) = 0;

 protected:
    void showHideControl();
    void makeCanvasSizeEqual();

 protected:
    //!Part of the wxWindows architecture -- there is no data to transfer.
    bool TransferDataToWindow() {return true;}
    //!Part of the wxWindows architecture -- there is no data to transfer
    bool TransferDataFromWindow() {return true;}

protected:
    //! wxWindows GUI
    wxBoxSizer *m_MainSizer;
    wxWindow   *m_ControlWindow;

    //!position of the control window
    /*  0 -> not visible,
       -1 -> left  of canvas
        1 -> right of canvas
    */
    int  m_ControlPosition;
    bool m_IsMakeCanvasSizeEqual;
};



class vuBasicSubViewerCanvas : public vuGLCanvas
{
 public:
  vuBasicSubViewerCanvas(vuBasicSubViewer *parent, wxWindowID id=-1);
  ~vuBasicSubViewerCanvas();

 protected:
  /**  passes the mouse event to OnMouse */
  virtual void OnMouse(wxMouseEvent &ev);
  virtual void OnChar(wxKeyEvent &ev) {};
  DECLARE_EVENT_TABLE()
};

#endif /* _wxUIElements_vuBasicSubViewer_h_ */
