#include "vuBasicSubViewer.h"

#include <iostream>
#include <wx/event.h>
#include "../vuUtilityWindow.h"
#include "../wxUtilities/vuBasicUtility.h"

#define SCREEN_WIDTH  1400
#define SCREEN_HEIGHT 1050

//****************************************************************************
//************************* The vuBasicSubViewer event table ****************
//****************************************************************************

BEGIN_EVENT_TABLE(vuBasicSubViewerCanvas, vuGLCanvas)
    EVT_MOUSE_EVENTS(vuBasicSubViewerCanvas::OnMouse)
    EVT_CHAR(vuBasicSubViewerCanvas::OnChar)
END_EVENT_TABLE();


//****************************************************************************
//************************* The constructor **********************************
//****************************************************************************

vuBasicSubViewer::vuBasicSubViewer(wxWindow *parent, vuString title)
    : wxDialog(parent,-1, title.c_str(),wxDefaultPosition, wxDefaultSize,
	       wxDEFAULT_DIALOG_STYLE|wxRESIZE_BORDER)
{
  m_ControlPosition       = 0; // control is not visible -> init()
  m_IsMakeCanvasSizeEqual = true;
  m_MainSizer             = NULL;
  m_ControlWindow         = NULL;
}

void vuBasicSubViewer::init(bool showControl)
{
  m_MainSizer     = new wxBoxSizer(wxHORIZONTAL);
  m_ControlWindow = new wxWindow(this, -1);

  wxBoxSizer *horSpacer = new wxBoxSizer(wxHORIZONTAL);
  wxBoxSizer *verSpacer = new wxBoxSizer(wxVERTICAL);

  verSpacer->Add(0,10);

  addLeftRight(verSpacer, m_ControlWindow);

  horSpacer->Add(10,0);
  horSpacer->Add(verSpacer);
  horSpacer->Add(10,0);
  horSpacer->Layout();

  // -- control window -------------------------------------------------------
  m_ControlWindow->SetSizer(horSpacer);
  horSpacer->Fit(m_ControlWindow);

  if (getCanvas()) m_MainSizer->Add(getCanvas(),1,wxEXPAND);

  if (showControl) {
    m_MainSizer->Add(m_ControlWindow);
    m_ControlPosition = 1; // control is to the right of the cavas
  }
  else {
    m_ControlWindow->Show(false);
    m_ControlPosition = 0;
  }

  //Set up the Dialog to use the sizers
  SetSizer(m_MainSizer);
  SetAutoLayout(true);
  m_MainSizer->Layout();
  m_MainSizer->Fit(this);
}

vuBasicSubViewer::~vuBasicSubViewer()
{
  m_MainSizer       = NULL;
  m_ControlWindow   = NULL;
}

void vuBasicSubViewer::redraw()
{
  if (getCanvas()) getCanvas()->redraw();
}

/* ************************************************************************* */
/* ********************************* callbacks ***************************** */
/* ************************************************************************* */

void vuBasicSubViewer::glOnMouse(wxMouseEvent &event)
{
  if (getCanvas() == NULL) return;
  
  if (event.LeftDClick()) {
    showHideControl();
    getCanvas()->redraw();
  }
  else if (event.RightDClick()) {
    makeCanvasSizeEqual();
    getCanvas()->redraw();
  }
}

bool vuBasicSubViewer::isControlVisible()
{
  return (m_ControlPosition != 0);
}

/* ************************************************************************* */
/* *** private functions *************************************************** */
/* ************************************************************************* */


void vuBasicSubViewer::showControl(bool doShow)
{
  if (!IsShown()) return;
  if (getCanvas() == NULL) return;
  
  dword width    = getCanvas()->getWidth();
  dword height   = getCanvas()->getHeight();
  dword ctrWidth = m_ControlWindow->GetSize().GetWidth();
  int   xPos     = GetPosition().x + 1;
  int   yPos     = GetPosition().y + 1;

  int oldPos     = m_ControlPosition;

  if (doShow == isControlVisible()) return;

  if (m_ControlPosition == 0)
    m_ControlPosition = ((xPos + width + ctrWidth) > SCREEN_WIDTH) ? -1 : 1;
  else 
    m_ControlPosition = 0;

  bool isVisible = (m_ControlPosition != 0);

  // set window position
  if (m_ControlPosition == -1) xPos -= ctrWidth;
  if (oldPos == -1)            xPos += ctrWidth;
  if (isVisible)              width += ctrWidth;
    
  SetSize(xPos,yPos, width,height);

  // show/hide control window
  m_ControlWindow->Show(isVisible);
    
  if (isVisible) {
    if (m_ControlPosition == 1) // 1 ->right of canvas
      m_MainSizer->Add(m_ControlWindow);
    else                        // -1 -> left of canvas
      m_MainSizer->Prepend(m_ControlWindow);
  }
  else {
    if (oldPos == 1) //  1 --> right of canvas
      m_MainSizer->Remove(1);
    else             // -1 --> left of canvs
      m_MainSizer->Remove(0);
  }  
}

// toggles between hiding and showing the control gui
void vuBasicSubViewer::showHideControl()
{
  bool doShow = (m_ControlPosition == 0);

  showControl(doShow);
}

void vuBasicSubViewer::makeCanvasSizeEqual()
{
  vuBasicUtility  *parent  = (vuBasicUtility *)GetParent();
  vuBasicGLCanvas *canvas  = NULL;
  dword           width    = 200;
  dword           height   = 200;
  dword           ctrWidth = 0;
  int             xPos     = GetPosition().x;
  int             yPos     = GetPosition().y;

  if (parent != NULL) canvas = (vuBasicGLCanvas *)parent->getCanvas();

  if (canvas != NULL && m_IsMakeCanvasSizeEqual) {
    width  = canvas->getWidth();
    height = canvas->getHeight();
    m_IsMakeCanvasSizeEqual = false;
  }
  else
    m_IsMakeCanvasSizeEqual = true;

  if (m_ControlPosition != 0)
    ctrWidth = m_ControlWindow->GetSize().GetWidth();

  if ((xPos + width + ctrWidth) > SCREEN_WIDTH)
    xPos = SCREEN_WIDTH - width - ctrWidth;

  if ((yPos + height) > SCREEN_HEIGHT)
    yPos = SCREEN_HEIGHT - height - 30;

  SetSize(xPos,yPos, width+ctrWidth, height);
}




/* ********************************************************************** */
/* *** vuBasicSubViewerCanvas ******************************************* */
/* ********************************************************************** */

vuBasicSubViewerCanvas::vuBasicSubViewerCanvas(vuBasicSubViewer *parent,
					       wxWindowID id) :
  vuGLCanvas(parent, id)
{
}

vuBasicSubViewerCanvas::~vuBasicSubViewerCanvas()
{
}


void vuBasicSubViewerCanvas::OnMouse(wxMouseEvent &event)
{
  ((vuBasicSubViewer *)GetParent())->glOnMouse(event);
}
