#ifndef _vuUtilityWindow_h_
#define _vuUtilityWindow_h_

//Decide on the base class of the utility windows.  MDI windows under the GTK
//toolkit do not behave how we want, so under this toolkit use a different
//type of window.

#if defined(__WXGTK__)

#include <wx/frame.h>
#define wxCHILDWINDOW wxFrame

#else

#include <wx/mdi.h>
#define wxCHILDWINDOW wxMDIChildFrame

#endif

//This header file defines the basic volume data class.
#include "Volume/volume.h"

//Defined in the "vuMainWindow.h" header file.
class vuMainWindow;

//! The interface for utility windows of the GUI Tool.  It must be implemented by all the windows.

/*! This class defines the interface that all the utility windows in the GUI
    Tool must implement.  At this level, this is just the architecture of the
    GUI Tool program.  The utility windows must have a common way to be
    initialized and to have general windowing control.  By making this a
    general interface, it keeps windows modular and makes it easy to add new
    windows to the GUI Tool.

    The utility windows are implemented differently depending on the windowing
    system.  In most systems, the utility windows are implemented as
    wxMDIChildWindows.  This is because the main window is an MDI parent
    window, and it is important to ensure that all the utility windows can
    be created within it.  In gtk, the wxWindow's implementation of the MDI
    architecture is not suitable to the gui tool, and so the main window and
    the utility windows are all implemented as separate windows, deriving
    from the wxFrame class.  Again, this ensures common behaviour among the
    utility windows.

    The utility window interface also defines the architecture for sharing the
    volume data within the GUI Tool.  The volume data is the primary resource
    of the program, and the concept the program is built around.  Because of
    this centrality, the volume data is owned by the main window, and the
    utility windows are given access to it.  This interface defines how the
    volume data is shared between the two classes.
*/

class vuUtilityWindow : public wxCHILDWINDOW
{
public:
    //!A virtual destructor.
    /*!Declare a virtual destructor for all utility windows to assure
       correct code for all windows.
    */
    virtual ~vuUtilityWindow() {};

    //!Static function that returns the data type that the utility accepts.
    /*!Each utility can only accept data files of a certain type.  This
       method returns the type of data file handled by the utility.  This
       data type is coded in the same was as in the vuFileHelper, by listing
       the branch of the volume tree corresponding to the data.  If the
       utility is passed other data, it will issue an error to the user.
       The getFileType method should be implemented as a static method.  This
       may not be the most elegant solution, but it's a quick and clean for
       our small purpose.
    */
    //virtual const char *getFileType()=0;

    //!The initialization method for the utility window.
    /*!It sets up all the user controls, sets their starting values and shows
       the window.  The controls define the interface that the user will have
       to the utility and it's APIs.

       The method is called by the vuMainWindow main window after the windowing
       API and main window have already been initialized, so the method can
       access windowing functions.

       A pointer to the opened instance of volume data is given.  This is the
       volume data that the utility will operate on.

       \param main Pointer to the vuMainWindow parent that's creating the instance.
       \param DataFile The name of the volume data file the utility will operate on.
       \return True if successful.
    */
    virtual bool init(vuMainWindow *main,const char* DataFile)=0;

    //!Closes the utility window, doing any necessary clean up.
    /*!This method is called when the vuMasterWindow parent has to close the
       utility window.  The UtilityWindow should do any clean up it wants to
       do here, such as saving any of its data.
    */
    virtual void close() = 0;

    //!Notifies the utility that the volume data has been changed and that it should update its view.
    /*!This is done when the volume data has been changed by another utility,
       and so any views of the data should be updated.  The volume data can be
       changed by another utility so that other views of it will become
       outdated.  This method allows the whole program to be synchronized to
       the change.
    */
    virtual void notifyDataChanged() = 0;

};


#endif
