#ifndef _vuUtilityFactory_h_
#define _vuUtilityFactory_h_

#include "vuUtilityWindow.h"
#include <wx/string.h>

//! The factory class for creating vuUtilityWindow implementations.

/*! The vuUtilityFactory class is responsible for creating/instantiating all
    the	vuUtilityWindow implementations.  It creates them by name using the
    create() method, then returns the implementation as a vuUtilityWindow
    class.  It can also list all the vuUtilityWindow implementations that it
    can create. The class is a singleton, so all the methods are static and the
    class doesn't have to be instantiated.
*/
class vuUtilityFactory
{
public:
    //! Creates vuUtilityWindow implementations by name.
    /*! The caller assumes control of the pointer and is responsible for
	    deleting it.  The method returns Null (0) if there are no
	    vuUtilityWindow implementations of the given name.

        \param name The name of the vuUtilityWindow implementation.
        \return A pointer to an instance of the new vuUtilityWindow implementation.
    */
    static vuUtilityWindow *create(const char *name);

    //! Returns true if the named utility is available from the factory.
    /*!
        \param name The name of the vuUtilityWindow implementation.
        \return True if the utility can be created by the factory. False otherwise.
    */
    static bool isAvailable(const char *name);

    //! Lists the available vuUtilityWindow implementations that the factory can create.
    /*! Allows the caller to check the functionality of the factory at runtime.
        This would be useful for creating a list of all possible 
	    vuUtilityWindow implementations available.
        \return A list of the available vuUtilityWindow implementations names.
    */
    static wxStringList listAvailable(const char* FileType);
};
#endif
