//
// IMPORTANT: This file is NO LONGER created automatically!!!
//
// If you develop new utilities, you HAVE TO make sure to put an adequate
// entry into this file! -ms-


// Following utilities are supported so far:
//    vuSplat
//    vuCellProjector
//    vuRaycast
//    vuMarchingCubes
//    vuBccSplat
//    vuBCCFirstHitRaycaster
//    vuBCCMarchingTetrahedra
//    vuBCCSheetSplatter
//    vuBCCRaycaster
//    vuSlicer
//    vuFVR
//    vuLightfield
//    vuSpecFVR
//    vuSpectral
//    vuSpecSplat
//
//    vuLightfieldBrowser

#include "vuUtilityFactory.h"
#include "wxUtilities/vuSplat/vuSplat.h"
#include "wxUtilities/vuCellProjector/vuCellProjector.h"
#include "wxUtilities/vuRaycast/vuRaycast.h"
#include "wxUtilities/vuMarchingCubes/vuMarchingCubes.h"
#include "wxUtilities/vuBccSplat/vuBccSplat.h"
#include "wxUtilities/vuBCCFirstHitRaycaster/vuBCCFirstHitRaycaster.h"
#include "wxUtilities/vuBCCMarchingTetrahedra/vuBCCMarchingTetrahedra.h"
#include "wxUtilities/vuBCCSheetSplatter/vuBCCSheetSplatter.h"
#include "wxUtilities/vuBCCRaycaster/vuBCCRaycaster.h"
#include "wxUtilities/vuSlicer/vuSlicer.h"
#include "wxUtilities/vuFVR/vuFVR.h"

#ifdef DO_SPECTRAL
#include "wxUtilities/vuSpecFVR/vuSpecFVR.h"
#include "wxUtilities/vuSpectral/vuSpectral.h"
#ifndef WIN32	// hack, until NVIDIA extensions are available under WIN32
#include "wxUtilities/vuSpecSplat/vuSpecSplat.h"
#endif
#endif

#include "wxUtilities/vuLightfield/vuBrowser/vuSphericBrowser1B.h"
#include "wxUtilities/vuLightfield/vuBrowser/vuSphericBrowser3B.h"
#include "wxUtilities/vuLightfield/vuBrowser/vuSphericBrowser1F.h"
#include "wxUtilities/vuLightfield/vuBrowser/vuSphericBrowser2F.h"
#include "wxUtilities/vuLightfield/vuBrowser/vuSphericBrowser3F.h"

#include "wxUtilities/vuLightfield/vuRevolver/vuSphericRevolver1B.h"
#include "wxUtilities/vuLightfield/vuRevolver/vuSphericRevolver3B.h"
#include "wxUtilities/vuLightfield/vuRevolver/vuSphericRevolver1F.h"
#include "wxUtilities/vuLightfield/vuRevolver/vuSphericRevolver2F.h"
#include "wxUtilities/vuLightfield/vuRevolver/vuSphericRevolver3F.h"

#include "wxUtilities/vuLightfield/vuFBR/vuSphericFBR2F.h"

#include "wxUtilities/vuLightfield/vuSimpleFBR/vuSimpleFBR1B.h"
#include "wxUtilities/vuLightfield/vuSimpleFBR/vuSimpleFBR3B.h"

#include "wxUtilities/vuShearWarp/vuShearWarp.h"
#include "wxUtilities/vuBCCShearWarp/vuBCCShearWarp.h"

#include "wxUtilities/vuFourier/vuStandardFVR/vuStandardFVR1F.h"
#include "wxUtilities/vuFourier/vuStandardFVR/vuStandardFVR3F.h"


vuUtilityWindow *vuUtilityFactory::create(const char *name)
{
    vuUtilityWindow *window=0;

    if (strcmp(name,"vuSplat")==0)
        window = new vuSplat();
    else if (strcmp(name,"vuCellProjector")==0)
        window = new vuCellProjector();
    else if (strcmp(name,"vuRaycast")==0)
        window = new vuRaycast();
    else if (strcmp(name,"vuMarchingCubes")==0)
        window = new vuMarchingCubes();
    else if (strcmp(name,"vuBccSplat")==0)
        window = new vuBccSplat();
    else if (strcmp(name,"vuBCCFirstHitRaycaster")==0)
        window = new vuBCCFirstHitRaycaster();
    else if (strcmp(name,"vuBCCMarchingTetrahedra")==0)
        window = new vuBCCMarchingTetrahedra();
    else if (strcmp(name,"vuBCCSheetSplatter")==0)
        window = new vuBCCSheetSplatter();
    else if (strcmp(name,"vuBCCRaycaster")==0)
        window = new vuBCCRaycaster();
    else if (strcmp(name,"vuSlicer")==0)
        window = new vuSlicer();
    else if (strcmp(name,"vuFVR")==0)
        window = new vuFVR();

#ifdef DO_SPECTRAL
    else if (strcmp(name,"vuSpecFVR")==0)
        window = new vuSpecFVR();
    else if (strcmp(name,"vuSpectral")==0)
        window = new vuSpectral();
#ifndef WIN32	// hack, until NVIDIA extensions are available under WIN32
    else if (strcmp(name,"vuSpecSplat")==0)
        window = new vuSpecSplat();
#endif
#endif

    else if (strcmp(name,"vuShearWarp")==0)
        window = new vuShearWarp();
    else if (strcmp(name,"vuBCCShearWarp")==0)
        window = new vuBCCShearWarp();


    else if (strcmp(name,"vuSphericBrowser1B")==0)
        window = new vuSphericBrowser1B();
    else if (strcmp(name,"vuSphericBrowser3B")==0)
        window = new vuSphericBrowser3B();
    else if (strcmp(name,"vuSphericBrowser1F")==0)
        window = new vuSphericBrowser1F();
    else if (strcmp(name,"vuSphericBrowser2F")==0)
        window = new vuSphericBrowser2F();
    else if (strcmp(name,"vuSphericBrowser3F")==0)
        window = new vuSphericBrowser3F();

    else if (strcmp(name,"vuSphericRevolver1B")==0)
        window = new vuSphericRevolver1B();
    else if (strcmp(name,"vuSphericRevolver3B")==0)
        window = new vuSphericRevolver3B();
    else if (strcmp(name,"vuSphericRevolver1F")==0)
        window = new vuSphericRevolver1F();
    else if (strcmp(name,"vuSphericRevolver2F")==0)
        window = new vuSphericRevolver2F();
    else if (strcmp(name,"vuSphericRevolver3F")==0)
        window = new vuSphericRevolver3F();

    else if (strcmp(name,"vuSphericFBR2F")==0)
        window = new vuSphericFBR2F();

    else if (strcmp(name,"vuSimpleFBR1B")==0)
        window = new vuSimpleFBR1B();
    else if (strcmp(name,"vuSimpleFBR3B")==0)
        window = new vuSimpleFBR3B();

    else if (strcmp(name,"vuStandardFVR1F")==0)
        window = new vuStandardFVR1F();
    else if (strcmp(name,"vuStandardFVR3F")==0)
        window = new vuStandardFVR3F();

    return window;
}

bool vuUtilityFactory::isAvailable(const char *name)
{
    if (strcmp(name,"vuSplat")==0)
        return true;
    if (strcmp(name,"vuCellProjector")==0)
        return true;
    else if (strcmp(name,"vuRaycast")==0)
        return true;
    else if (strcmp(name,"vuMarchingCubes")==0)
        return true;
    else if (strcmp(name,"vuBccSplat")==0)
        return true;
    else if (strcmp(name,"vuBCCFirstHitRaycaster")==0)
        return true;
    else if (strcmp(name,"vuBCCMarchingTetrahedra")==0)
        return true;
    else if (strcmp(name,"vuBCCSheetSplatter")==0)
        return true;
    else if (strcmp(name,"vuBCCRaycaster")==0)
        return true;
    else if (strcmp(name,"vuSlicer")==0)
        return true;
    else if (strcmp(name,"vuFVR")==0)
        return true;
    else if (strcmp(name,"vuLightfield")==0)
        return true;
#ifdef DO_SPECTRAL
    else if (strcmp(name,"vuSpecFVR")==0)
        return true;
    else if (strcmp(name,"vuSpectral")==0)
        return true;
#ifndef WIN32	// hack, until NVIDIA extensions are available under WIN32
    else if (strcmp(name,"vuSpecSplat")==0)
        return true;
#endif
#endif

    else if (strcmp(name,"vuShearWarp")==0)
        return true;
    else if (strcmp(name,"vuBCCShearWarp")==0)
        return true;

    else if (strcmp(name,"vuSphericBrowser1B")==0)
        return true;
    else if (strcmp(name,"vuSphericBrowser3B")==0)
        return true;
    else if (strcmp(name,"vuSphericBrowser1F")==0)
        return true;
    else if (strcmp(name,"vuSphericBrowser2F")==0)
        return true;
    else if (strcmp(name,"vuSphericBrowser3F")==0)
        return true;

    else if (strcmp(name,"vuSphericRevolver1B")==0)
        return true;
    else if (strcmp(name,"vuSphericRevolver3B")==0)
        return true;
    else if (strcmp(name,"vuSphericRevolver1F")==0)
        return true;
    else if (strcmp(name,"vuSphericRevolver2F")==0)
        return true;
    else if (strcmp(name,"vuSphericRevolver3F")==0)
        return true;

    else if (strcmp(name,"vuSphericFBR2F")==0)
        return true;

    else if (strcmp(name,"vuSimpleFBR1B")==0)
        return true;
    else if (strcmp(name,"vuSimpleFBR3B")==0)
        return true;

    else if (strcmp(name,"vuStandardFVR1F")==0)
        return true;
    else if (strcmp(name,"vuStandardFVR3F")==0)
        return true;

    else
        return false;
}

wxStringList vuUtilityFactory::listAvailable(const char* FileType)
{
    wxStringList utilities;

    if (strcmp(vuSplat::getFileType(),FileType)==0)
        utilities.Add("vuSplat");
    if (strcmp(vuSplat::getFileType(),FileType)==0)
        utilities.Add("vuCellProjector");
    if (strcmp(vuRaycast::getFileType(),FileType)==0)
        utilities.Add("vuRaycast");
    if (strstr(vuMarchingCubes::getFileType(),FileType)!=0) // We do things a
	    						    // little bit
							    // different
        utilities.Add("vuMarchingCubes");
    if (strcmp(vuBccSplat::getFileType(),FileType)==0)
        utilities.Add("vuBccSplat");
    if (strcmp(vuBCCFirstHitRaycaster::getFileType(),FileType)==0)
        utilities.Add("vuBCCFirstHitRaycaster");
    if (strcmp(vuBCCMarchingTetrahedra::getFileType(),FileType)==0)
        utilities.Add("vuBCCMarchingTetrahedra");
    if (strcmp(vuBCCSheetSplatter::getFileType(),FileType)==0)
        utilities.Add("vuBCCSheetSplatter");
    if (strcmp(vuBCCRaycaster::getFileType(),FileType)==0)
        utilities.Add("vuBCCRaycaster");
    if (strcmp(vuSlicer::getFileType(),FileType)==0)
        utilities.Add("vuSlicer");
    if (strcmp(vuFVR::getFileType(),FileType)==0)
        utilities.Add("vuFVR");

#ifdef DO_SPECTRAL
    if (strcmp(vuSpecFVR::getFileType(),FileType)==0)
        utilities.Add("vuSpecFVR");
    if (strcmp(vuSpectral::getFileType(),FileType)==0)
        utilities.Add("vuSpectral");
#ifndef WIN32	// hack, until NVIDIA extensions are available under WIN32
    if (strcmp(vuSpecSplat::getFileType(),FileType)==0)
        utilities.Add("vuSpecSplat");
#endif
#endif

    if (strcmp(vuShearWarp::getFileType(),FileType)==0)
        utilities.Add("vuShearWarp");
    if (strcmp(vuBCCShearWarp::getFileType(),FileType)==0)
        utilities.Add("vuBCCShearWarp");

    if (strcmp(vuSphericBrowser1B::getFileType(),FileType)==0)
        utilities.Add("vuSphericBrowser1B");
    if (strcmp(vuSphericBrowser3B::getFileType(),FileType)==0)
        utilities.Add("vuSphericBrowser3B");
    if (strcmp(vuSphericBrowser1F::getFileType(),FileType)==0)
        utilities.Add("vuSphericBrowser1F");
    if (strcmp(vuSphericBrowser2F::getFileType(),FileType)==0)
        utilities.Add("vuSphericBrowser2F");
    if (strcmp(vuSphericBrowser3F::getFileType(),FileType)==0)
        utilities.Add("vuSphericBrowser3F");

    if (strcmp(vuSphericRevolver1B::getFileType(),FileType)==0)
        utilities.Add("vuSphericRevolver1B");
    if (strcmp(vuSphericRevolver3B::getFileType(),FileType)==0)
        utilities.Add("vuSphericRevolver3B");
    if (strcmp(vuSphericRevolver1F::getFileType(),FileType)==0)
        utilities.Add("vuSphericRevolver1F");
    if (strcmp(vuSphericRevolver2F::getFileType(),FileType)==0)
        utilities.Add("vuSphericRevolver2F");
    if (strcmp(vuSphericRevolver3F::getFileType(),FileType)==0)
        utilities.Add("vuSphericRevolver3F");

    if (strcmp(vuSphericFBR2F::getFileType(),FileType)==0)
        utilities.Add("vuSphericFBR2F");

    if (strcmp(vuSimpleFBR1B::getFileType(),FileType)==0)
        utilities.Add("vuSimpleFBR1B");
    if (strcmp(vuSimpleFBR3B::getFileType(),FileType)==0)
        utilities.Add("vuSimpleFBR3B");

    if (strcmp(vuStandardFVR1F::getFileType(),FileType)==0)
        utilities.Add("vuStandardFVR1F");
    if (strcmp(vuStandardFVR3F::getFileType(),FileType)==0)
        utilities.Add("vuStandardFVR3F");

    return utilities;
}

