//!Creates a little subwindow showing a box from a certain perspective
/*!
  This widget is provides a means to control the camera perspective 
  from outside the rendering window. A little representation of the 
  dataset is shown. Currently this is a coloured cube with the measures
  of the bounding box, but maybe
*/
#ifndef _vuPreviewWin_h_
#define _vuPreviewWin_h_

#include "vuCamera.h"
#include "wxUIElements/vuGLCanvas.h"
#include "wxUtilities/vuBasicUtility.h"

class vuPreviewWin : public vuGLCanvas
{
 public:
    //!constructor
    /*! \param parent parent window 
       \param sixe_xy the desired size of preview window
    */
    vuPreviewWin(vuBasicUtility *parent, int size_x, int size_y);
    //!destructor
    ~vuPreviewWin();

    //! attaches a vuCamera that should be controled by the vuPreviewWin
    /*! \param cam pointer to the camera that should be manipulated */
    void attachCamera(vuCamera* cam);
    
    //! set the size of the cube that has to be shown
    /*! \param sx,sy,sz extents of the cube*/
    void setCubeSize(int sx, int sy, int sz);
    
    //! implementation of the virtual render function
    void render();
    
    //! our own init function
    bool glInit();

    //! mouse handler that performs the arc ball transformation
    void glOnMouse(wxMouseEvent &ev);
    
 protected:
    
    //! draw a representation of the dataset of given size
    /*! Currently this virtual function draws a cube. It is possible
        to plug in other objects using OpenGL functions. Projection and
        modelview matrix are already setup according to the camera. */
    virtual void drawRepresentation(float sx, float sy, float sz);
    
    //! pointer to the window that owns this Preview (not used)
    vuBasicUtility *m_Parent;

    //! center to ratate about
    vuVector		 center;

    //! reference to the camere that should be controled by the previewer
    vuCamera	 *m_Camera;

    //! 3D extension of the data set
    int m_MX, m_MY, m_MZ;

#ifdef WIN32
    int m_x, m_y;
#endif

DECLARE_EVENT_TABLE()

};

#endif
