#include <iostream.h>
#include "vuArcBall.h"
#include "vuPreviewWin.h"

//----------------------------------------------------------------------------
//------------------------- vuPrewviewWin implementation ---------------------
//----------------------------------------------------------------------------

BEGIN_EVENT_TABLE(vuPreviewWin, vuGLCanvas)
  EVT_MOUSE_EVENTS(vuPreviewWin::glOnMouse)
END_EVENT_TABLE()

vuPreviewWin::vuPreviewWin(vuBasicUtility *parent, int size_x, int size_y)
  : vuGLCanvas(parent,-1,wxPoint(0,0),wxSize(size_x,size_y)), m_Parent(parent) 
{
  m_Camera = NULL;
}

vuPreviewWin::~vuPreviewWin()
{
}

void vuPreviewWin::attachCamera(vuCamera* cam)
{
  m_Camera = cam;
}

void vuPreviewWin::setCubeSize(int sx, int sy, int sz)
{
  m_MX = sx;
  m_MY = sy;
  m_MZ = sz;
  center = vuVector(sx/2,sy/2,sz/2);
}

void vuPreviewWin::render()
{
  glClear(GL_COLOR_BUFFER_BIT);

  glDisable(GL_CULL_FACE);
  glEnable(GL_DEPTH_TEST);
  glDepthFunc(GL_LESS);
  //	glCullFace(GL_FRONT);			//what a shit
  //glCullFace(GL_BACK);			//what a shit
  glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);
  //glClear(GL_COLOR_BUFFER_BIT);
	
  //Set the opengl projection matrix.
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  m_Camera->glInit();
  //glOrtho(-m_Data->m_Camera.Width()/2,m_Data->m_Camera.Width()/2, 
  //	-m_Data->m_Camera.Height()/2, m_Data->m_Camera.Height()/2, 
  //	10000.0f, -10000.0f);
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();
  m_Camera->gluLookAt();
  //vuMatrix cam = m_Data->m_Camera.getViewMat();
  //glTranslatef(m_Data->center[0],m_Data->center[1],m_Data->center[2]);
  //glMultMatrixf(cam.getData());
  //glTranslatef(-m_Data->center[0],-m_Data->center[1],-m_Data->center[2]);
  //draw an axis aligned box
  drawRepresentation(m_MX, m_MY, m_MZ);
}

bool vuPreviewWin::glInit()
{
  return true;
}

//----------------------------------------------------------------------------
//------------------------- protected: glOnMouse() ---------------------------
//----------------------------------------------------------------------------

void vuPreviewWin::glOnMouse(wxMouseEvent &ev)
{
    if (ev.LeftDown() || ev.RightDown())
    {
        //Store the click position.
        m_x = (int) ev.GetX();
        m_y = (int) ev.GetY();
    }
    else if (ev.LeftIsDown() && ev.Moving())
    {
        //Rotate the volume
        vuVector t = m_Camera->getPosition()-center;
        float d = t.norm();
        m_Camera->translateXYZ(0.0f, 0.0f, d);
	t = m_Camera->getPosition();
	//use the arc ball
	vuArcBall ball;
	ball.attachCamera(*m_Camera);
	int winx,winy;
	GetSize(&winx,&winy);
	ball.setWinSize(winx,winy);
	ball.turn(m_x, m_y, ev.GetX(), ev.GetY());
        m_Camera->translateXYZ(0.0f, 0.0f, -d);
	m_Camera->init();
        redraw();

        //Store the click position.
        m_x = (int) ev.GetX();
        m_y = (int) ev.GetY();
    }
    else if (ev.RightIsDown() && ev.Moving())
    {
        //distance from the volume.
        float s = ((float)ev.GetY() - m_y)/1.0f;
        vuVector t = m_Camera->getPosition()-center;
        //float d = t.norm();
        m_Camera->translateXYZ(0.0f, 0.0f, -s);
        resize();
        redraw();

        //Store the click position.
        m_x = (int) ev.GetX();
        m_y = (int) ev.GetY();
    }
}


void vuPreviewWin::drawRepresentation(float sx, float sy, float sz)
{
  static GLfloat n[6][3] = {  /* Normals for the 6 faces of a cube. */
    {-1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {1.0, 0.0, 0.0},
    {0.0, -1.0, 0.0}, {0.0, 0.0, -1.0}, {0.0, 0.0, 1.0} };
  static GLint faces[6][4] = {  /* Vertex indices for the 6 faces of a cube. */
    {0, 1, 2, 3}, {3, 2, 6, 7}, {7, 6, 5, 4},
    {4, 5, 1, 0}, {5, 6, 2, 1}, {7, 4, 0, 3} };
  static GLfloat v[8][3];  /* Will be filled in with X,Y,Z vertexes. */
  
  /* Setup cube vertex data. */
  v[0][0] = v[1][0] = v[2][0] = v[3][0] = 0;
  v[4][0] = v[5][0] = v[6][0] = v[7][0] = sx;
  v[0][1] = v[1][1] = v[4][1] = v[5][1] = 0;
  v[2][1] = v[3][1] = v[6][1] = v[7][1] = sy;
  v[0][2] = v[3][2] = v[4][2] = v[7][2] = sz;
  v[1][2] = v[2][2] = v[5][2] = v[6][2] = 0;
  
  int i;
  for (i = 0; i < 6; i++) {
    glBegin(GL_QUADS);
    glNormal3fv(&n[i][0]);
    glColor3fv(v[faces[i][0]]);
    glVertex3fv(&v[faces[i][0]][0]);
    glColor3fv(v[faces[i][1]]);
    glVertex3fv(&v[faces[i][1]][0]);
    glColor3fv(v[faces[i][2]]);
    glVertex3fv(&v[faces[i][2]][0]);
    glColor3fv(v[faces[i][3]]);
    glVertex3fv(&v[faces[i][3]][0]);
    glEnd();
  }
}
