
/**  	Modified March 2002
	by Christopher Steinbach
	Modified to allow for faster blits

	Blit was sped up by an observed factor of 2.

	Modified March 2002
	by Christopher Steinbach
	Modified to use mutices to prevent synchronization errors.

	Modified to make everything non-static in an attempt
	to make the Draw tools work with threads.
*/

#ifndef _vuDrawTools_h_
#define _vuDrawTools_h_

//to include this, special WXdefines have to be made in the makefile
//this header is also used in the Volume subtree where we don't have
//such defines --> no GUI specific includes
//#include <wx/dc.h>

#include "vuSimpleTypes.h"

#include "vuThread.h"

/**
*/
//!This class provides basic drawing function using the GUI (wxWindows). This is an alternative to OpenGL rendering allowing more direct frame buffer access.
/*!
  This class has been created to provide access to the bit blit
  operations of the GUI. This is necessairy because OpenGLs
  glWritePixels is incredibly slow on PCs.

\todo The problem now is to make the blit used here effective. Therefore
      we may maintain one (or two) memory buffers which can be accessed
      directly from the render function. Then we have to find an effective
      way of blitting this via wxWindows (or in another way?).
\todo As an alternative to the glSwapBuffers() command it is desirable to maintain
      a frame buffer for an active window. This could avoid complete rerendering on
      simple frame redrawing.
      The Blit function has to be wrapped to display off-screen renderings. This
      will also be useful to maintaind a second frame buffer for fast screen refresh.
 */
class vuDrawTools
{
 public:
  //! attach a draw context */
  /*! \param pDC is a pointer to a wxDC but because there is no
	     association with wxWindows here, we have to cast it to void* */
  static void setDC(void* pDC);	//pointer to wxDC
  //! finish drawing actions for current device context
  static void quitDC();
  //! set the current drawing colour
  /*! \param r,g,b red, green, blue values from 0 to 255 */
  static void setColour(byte r, byte g, byte b);
  //! set the current background colour (for clearBG)
  /*! \param r,g,b red, green, blue values from 0 to 255 */
  static void setBGColour(byte r, byte g, byte b);
  //! set a Pixel with the current drawing colour
  static void setPixel(int x, int y);
  //! blit the framebuffer to the screen
  /*! As mentioned above. This function needs to be improved. Perhaps
      we do not allow an external framebuffer but instead give a handle
      to an internal one.
  */
  static void blit(const byte *buf, int sx, int sy, int px, int py);
  static void blit2(const byte *buf, int sx, int sy, int px, int py);
  static void partblit (const byte *buf, int sx, int sy, int length);
  static void finishpartblit ();
  static void setImgWidthHeight (int sx, int sy);
  static unsigned char * getData ();
//  static void blit(const byte *buf, int ammount_copied);
  //! clear the entire drawing area
  static void clearBG();
  //! some try to optimize the clearBG
  /*! ...but doesn't work and will be obsolete with an improved
      version of vuDrawTools
  */
  static void clearBGWithoutRect(int ox,int oy,int sx,int sy);
};
/*
class vuDrawToolsns
{
 public:
  //! attach a draw context
  ! \param pDC is a pointer to a wxDC but because there is no
	     association with wxWindows here, we have to cast it to void*
  void setDC(void* pDC);	//pointer to wxDC
  //! finish drawing actions for current device context
  void quitDC();
  //! set the current drawing colour
  ! \param r,g,b red, green, blue values from 0 to 255
  static void setColour(byte r, byte g, byte b);
  //! set the current background colour (for clearBG)
  ! \param r,g,b red, green, blue values from 0 to 255
  void setBGColour(byte r, byte g, byte b);
  //! set a Pixel with the current drawing colour
  void setPixel(int x, int y);
  //! blit the framebuffer to the screen
  ! As mentioned above. This function needs to be improved. Perhaps
      we do not allow an external framebuffer but instead give a handle
      to an internal one.

  void blit(const byte *buf, int sx, int sy, int px, int py);
  void blit2(const byte *buf, int sx, int sy, int px, int py);
  void partblit (const byte *buf, int sx, int sy, int length);
  void finishpartblit ();
  void setImgWidthHeight (int sx, int sy);
  unsigned char * getData ();
//  static void blit(const byte *buf, int ammount_copied);
  //! clear the entire drawing area
  void clearBG();
  //! some try to optimize the clearBG
  ! ...but doesn't work and will be obsolete with an improved
      version of vuDrawTools

  void clearBGWithoutRect(int ox,int oy,int sx,int sy);

 private:
  void* cDCns;
  void* imgns;

  vuMutex DrawToolMutexns;
};*/

#endif

