

#include "vuDrawTools.h"

#include <iostream.h>
#include <wx/dcclient.h>
#include <wx/pen.h>
#include <wx/bitmap.h>
#include <wx/image.h>

//############### internal variables #########################################
//!current device context for non-OGL drawing
//!this maybe gets complicated on multiple simultaneous drawing threads
static wxDC* cDC = NULL;
static wxImage* img = NULL;
vuMutex DrawToolMutex;
vuMutex SQMutex;

//----------------------------------------------------------------------------
//------------------------- setPixel(int x, int y) ---------------------------
//----------------------------------------------------------------------------

void vuDrawTools::setPixel(int x, int y)
{
//  DrawToolMutex.lock ();

  if(cDC)
    cDC->DrawPoint(x,y);

//DrawToolMutex.unlock ();
}

//----------------------------------------------------------------------------
//------------------------- setColour() --------------------------------------
//----------------------------------------------------------------------------

void vuDrawTools::setColour(byte r, byte g, byte b)
{
  //DrawToolMutex.lock ();

  if(cDC)
    //    cDC->SetBrush(wxBrush(wxColour(r,g,b),wxSOLID));
    cDC->SetPen(wxPen(wxColour(r,g,b),1,wxSOLID|wxDOT));

  //DrawToolMutex.unlock ();
}

//----------------------------------------------------------------------------
//------------------------- setBGColour() --------------------------------------
//----------------------------------------------------------------------------

void vuDrawTools::setBGColour(byte r, byte g, byte b)
{
  //DrawToolMutex.lock ();

  if(cDC)
    cDC->SetBackground(wxBrush(wxColour(r,g,b),wxSOLID));

 // DrawToolMutex.unlock ();
}

//----------------------------------------------------------------------------
//------------------------- clearBG() ----------------------------------------
//----------------------------------------------------------------------------

void vuDrawTools::clearBG()

{
  //DrawToolMutex.lock ();

  if(cDC)
    cDC->Clear();

  //DrawToolMutex.unlock ();
}

//----------------------------------------------------------------------------
//------------------------- blit() -------------------------------------------
//----------------------------------------------------------------------------

//#include <iostream.h>

void vuDrawTools::blit(const byte *buf, int sx, int sy, int px, int py)
{
  //DrawToolMutex.lock ();

  if(cDC && buf)
    {
      wxImage img(sx,sy, (unsigned char *) (buf), true);
      wxBitmap bmp(img);
      cDC->DrawBitmap(bmp, px, py);
    }

  //DrawToolMutex.unlock ();
}

void vuDrawTools::blit2(const byte *buf, int sx, int sy, int px, int py)
{
  //DrawToolMutex.lock ();

  if(cDC && buf)
    {
      wxBitmap bmp(*img);
      cDC->DrawBitmap(bmp, px, py);
    }

  //DrawToolMutex.unlock ();
}

void vuDrawTools::partblit (const byte *buf, int sx, int sy, int length)

{
}

void vuDrawTools::finishpartblit ()

{
}

void vuDrawTools::setImgWidthHeight (int sx, int sy)

{
	//DrawToolMutex.lock ();

	if (img == NULL)

	{
		img = new wxImage [1];

		if (img == NULL)
			return;
	}


	img->Rescale (sx, sy);

	//DrawToolMutex.unlock ();
}

unsigned char * vuDrawTools::getData ()

{
	return img->GetData ();
}

//----------------------------------------------------------------------------
//------------------------- setDC(wxDC*) -------------------------------------
//----------------------------------------------------------------------------
void vuDrawTools::setDC(void *pDC)
{
//  SQMutex.lock ();

//  DrawToolMutex.lock ();

  cDC = (wxDC*)pDC;

//  DrawToolMutex.unlock ();
}

//----------------------------------------------------------------------------
//------------------------- quitDC() -----------------------------------------
//----------------------------------------------------------------------------
void vuDrawTools::quitDC()
{
  cDC = NULL;

//  SQMutex.unlock ();
}

//----------------------------------------------------------------------------
//------------------------- clearBGWithoutRect()  ----------------------------
//----------------------------------------------------------------------------
void vuDrawTools::clearBGWithoutRect(int ox,int oy,int sx,int sy)
{
//  DrawToolMutex.lock ();

  if(cDC)
    {
      int w,h;
      cDC->GetSize(&w,&h);
            cDC->DrawRectangle(sx,oy,w-sx,h-oy);
	    /*
      cDC->SetClippingRegion(sx,oy,w-sx,h-oy);
      cDC->Clear();
      cDC->SetClippingRegion(0,oy+sy,sx,h-sy);
      cDC->Clear();
      cDC->DestroyClippingRegion();
	    */
    }

    //DrawToolMutex.unlock ();
}

//----------------------------------------------------------------------------
//-------------------------  -------------------
//----------------------------------------------------------------------------
//----------------------------------------------------------------------------
//------------------------- setPixel(int x, int y) ---------------------------
//----------------------------------------------------------------------------
/*
void vuDrawToolsns::setPixel(int x, int y)
{
  DrawToolMutexns.lock ();
  if(cDCns)
    cDCns->DrawPoint(x,y);
  DrawToolMutexns.unlock ();
}

//----------------------------------------------------------------------------
//------------------------- setColour() --------------------------------------
//----------------------------------------------------------------------------

void vuDrawToolsns::setColour(byte r, byte g, byte b)
{
  DrawToolMutexns.lock ();

  if(cDCns)
    //    cDC->SetBrush(wxBrush(wxColour(r,g,b),wxSOLID));
    cDCns->SetPen(wxPen(wxColour(r,g,b),1,wxSOLID|wxDOT));

  DrawToolMutexns.unlock ();
}

//----------------------------------------------------------------------------
//------------------------- setBGColour() --------------------------------------
//----------------------------------------------------------------------------

void vuDrawToolsns::setBGColour(byte r, byte g, byte b)
{
  DrawToolMutexns.lock ();

  if(cDCns)
    cDCns->SetBackground(wxBrush(wxColour(r,g,b),wxSOLID));

  DrawToolMutexns.unlock ();
}

//----------------------------------------------------------------------------
//------------------------- clearBG() ----------------------------------------
//----------------------------------------------------------------------------

void vuDrawToolsns::clearBG()

{
  DrawToolMutexns.lock ();

  if(cDCns)
    cDCns->Clear();

  DrawToolMutexns.unlock ();
}

//----------------------------------------------------------------------------
//------------------------- blit() -------------------------------------------
//----------------------------------------------------------------------------

//#include <iostream.h>

void vuDrawToolsns::blit(const byte *buf, int sx, int sy, int px, int py)
{
  DrawToolMutexns.lock ();
//	cout << "::blit " << endl;
  if(cDCns && buf)
    {
//      int mx, my;
		// faster this way, about 6 ms on Praha opposed to 11 ms for the old way.
      wxImage imgns(sx,sy, (unsigned char *) (buf), true);
//      memcpy(img.GetData(),buf,sx*sy*3);
//      img.SetData ((unsigned char*) (buf));
      wxBitmap bmp(imgns);
//      wxBitmap bmp ((void *) (buf), wxBITMAP_TYPE_BMP , sx, sy);//| wxBITMAP_TYPE_BMP_RESOURCE | wxBITMAP_TYPE_GIF | wxBITMAP_TYPE_XBM | wxBITMAP_TYPE_XPM  | wxBITMAP_TYPE_RESOURCE
      cDCns->DrawBitmap(bmp, px, py);
    }

  DrawToolMutexns.unlock ();
}

void vuDrawToolsns::blit2(const byte *buf, int sx, int sy, int px, int py)
{
  DrawToolMutexns.lock ();

  if(cDCns && buf)
    {
      wxBitmap bmp(*imgns);
      cDCns->DrawBitmap(bmp, px, py);
    }

  DrawToolMutexns.unlock ();
}

void vuDrawToolsns::partblit (const byte *buf, int sx, int sy, int length)

{
}

void vuDrawToolsns::finishpartblit ()

{
}

void vuDrawToolsns::setImgWidthHeight (int sx, int sy)

{
	DrawToolMutexns.lock ();

	if (imgns == NULL)

	{
		imgns = new wxImage [1];

		if (imgns == NULL)
			return;
	}


	imgns->Rescale (sx, sy);

	DrawToolMutexns.unlock ();
}

unsigned char * vuDrawToolsns::getData ()

{
	return imgns->GetData ();
}

//----------------------------------------------------------------------------
//------------------------- setDC(wxDC*) -------------------------------------
//----------------------------------------------------------------------------
void vuDrawToolsns::setDC(void *pDC)
{
  SQMutex.lock ();

  DrawToolMutexns.lock ();

  cDCns = (wxDC*)pDC;

  DrawToolMutexns.unlock ();
}

//----------------------------------------------------------------------------
//------------------------- quitDC() -----------------------------------------
//----------------------------------------------------------------------------
void vuDrawToolsns::quitDC()
{
  cDCns = NULL;

  SQMutex.unlock ();
}

//----------------------------------------------------------------------------
//------------------------- clearBGWithoutRect()  ----------------------------
//----------------------------------------------------------------------------
void vuDrawToolsns::clearBGWithoutRect(int ox,int oy,int sx,int sy)
{
  DrawToolMutexns.lock ();

  if(cDCns)
    {
      int w,h;
      cDCns->GetSize(&w,&h);
            cDCns->DrawRectangle(sx,oy,w-sx,h-oy);
    }

    DrawToolMutexns.unlock ();
}

//----------------------------------------------------------------------------
//-------------------------  -------------------
//----------------------------------------------------------------------------

*/



