#include "regular.h"
#include <stdio.h>

//----------------------------------------------------------------------------
//------------------------- protected read() ---------------------------------
//----------------------------------------------------------------------------

bool vu11::read(FILE *file)
{
    int ret = 0;
    int len = 0;

    bool success = vu1::read(file);
    if (!success) return false;

    //Read in the Dataset type, checking if it's regular
    ret = fscanf(file,"DATASET STRUCTURED_POINTS %n",&len);
    if (len < 26) return setInvalidFormatError();

    return true;
}

//----------------------------------------------------------------------------
//------------------------- protected write() --------------------------------
//----------------------------------------------------------------------------

bool vu11::write(FILE *file)
{
    int ret = 0;

    bool success = vu1::write(file);
    if (!success) return false;

    //Write the Dataset type
    ret = fprintf(file,"DATASET STRUCTURED_POINTS\n");
    
    if (ret > 0)
        return true;
    else
        return setWriteError();
}
