

#ifndef _VUVOLUMEREGULARUNIMODAL_H_
#define _VUVOLUMEREGULARUNIMODAL_H_

#include "../regular.h"
#include "vuString.h"

class vu111;
typedef vu111 vuVolumeRegularUnimodal;

//!The base class for regular unimodal volume data in the vuVolume data tree.
class vu111 : public vu11
{
public:
    //!Returns the name of the data set.
    /*!This is a short name to describe the data set, such as temperature
       or opacity.  It serves to differentiate different types of data within
       the same file.
    */
    const char *getDataName(void) const;

protected:
    //!Asserts that the file is unimodal data and reads the associated information.
    /*!This method reads in the general information for all unimodal 
       data sets. It also asserts whether the data is indeed unimodal
       or not.
       \return True if successful (data is unimodal), false otherwise.
    */
    virtual bool read(FILE *file);
    //!Writes the general unimodal data information to the file.
    /*!\return True if successful, false otherwise.
    */
    virtual bool write(FILE *file);

protected:
    //!The name of the data set.
    vuString m_DataName;    
};

#endif
