#ifndef _VUVOLUMEREGULARUNIMODAL4D_H_
#define _VUVOLUMEREGULARUNIMODAL4D_H_

#include "../unimodal.h"

class vu1113;
typedef vu1113 vuVolumeRegularUnimodal4d;

/** this is the base class for Regular, Unimodal, 4D datasets

this class will store and work with the size of the data sets in each of the four dimensions
*/
class vu1113 : public vu111
{
public:
	/** constructor

	This will set the size of each dimension to be zero
	*/
    vu1113();

    	/** copy constructor, performs a deep copy */
    vu1113(const vu1113& inst);

    	//! destructor
    virtual ~vu1113();

    	//! assignment operator
    vu1113& operator=(const vu1113& rhs);

    	/** this function will return the size of first dimension of the dataset
	(ie, how many increments we have along the first dimension) */
    dword getDim1Size() const;
    	//! this function will return the size of the dataset in the second dimension.
    dword getDim2Size() const;
	//! this function will return the size of the dataset in the third dimension
    dword getDim3Size() const;
    	//! this function will return the size of the dataset in the fourth dimension
    dword getDim4Size() const;

protected:
	//! the size of the first dimension of this dataset
    dword m_Dim1Size;
    	//! the size of the second dimension of this dataset
    dword m_Dim2Size;
    	//! the size of the third dimension of this dataset
    dword m_Dim3Size;
    	//! the size of the fourth dimension of this dataset
    dword m_Dim4Size;
};

#endif
