#ifndef _VUVOLUMEREGULARUNIMODAL3D_H_
#define _VUVOLUMEREGULARUNIMODAL3D_H_

#include "../unimodal.h"
#include "vuHistogram.h"
#include "vuMap.h"

class vu1112;
typedef vu1112 vuVolumeRegularUnimodal3d;

//!The base class for regular unimodal 3d data in the vuVolume data tree.
class vu1112 : public vu111
{
public:
    //!The default constructor.
    vu1112();
    //!The copy constructor.
    vu1112(const vu1112& inst);

    //!The assignment operator.
    vu1112& operator=(const vu1112& rhs);

    //!Returns the size of the data along the first dimension.
    dword getDim1Size(void) const;
    //!Returns the size of the data along the second dimension.
    dword getDim2Size(void) const;
    //!Returns the size of the data along the third dimension.
    dword getDim3Size(void) const;

    //!Returns the spacing of the 3d grid.
    /*!This is the spacing between the data values in each of the dimensions.
       This value is uniform in all dimensions since this is a regular grid.
    */
    dword getSpacing(void) const;

    //!Returns the origin of the data in the first dimension.
    int getDim1Origin(void) const;
    //!Returns the origin of the data in the second dimension.
    int getDim2Origin(void) const;
    //!Returns the origin of the data in the third dimension.
    int getDim3Origin(void) const;

    //just preliminarily added, this extension needs discussion ;-)
    /** Creates a histogram in hist.
	This is just a preliminary version of histogram creation. See
	class vuHistogram for a more detailed discussion. 
	\return false - could not create histogram type
    */
    virtual bool createHistogram(vuHistogram& hist) const { return false;};

    /** Remaps the intensities */
    virtual void remap(const vuMap& map) {};

    //!returns the center of the dataset (virtual in volume.h)
    vuVector getCenter() const {
	return vuVector((float)m_Dim1Size/2,(float)m_Dim2Size/2,(float)m_Dim3Size/2);
    }

protected:
    //!Asserts that the file is 3d data and reads the associated information.
    /*!This method reads in the general information for 3d data sets.
       It also asserts whether the data is indeed 3d or not.
       \return True if successful (data is regular), false otherwise.
    */
    virtual bool read(FILE *file);
    //!Writes the general 3d data information to the file.
    /*!\return True if successful, false otherwise.
    */
    virtual bool write(FILE *file);

protected:
    //!The size of the first dimension of the data set.
    dword m_Dim1Size;
    //!the sizeof the second dimension of the data set
    dword m_Dim2Size;
    //! the size of the third dimension of the data set
    dword m_Dim3Size;

    //!The spacing of the grid.
    dword m_Spacing;

    //!The origin of the first dimension of the data set.
    int m_Dim1Origin;
	//! The origin of the second dimensino of the data set
    int m_Dim2Origin;
    	//! the origin of the third dimension of the data set
    int m_Dim3Origin;

public:
    //!draws an OpenGl cube 
    void preview(int hint=0);

private:
    void drawBox(float sx, float sy, float sz);
};

#endif
