/**
 * @file	MarchingCubes.h
 *
 * Spezialisation of the marching cubes algorythm for the CG-TUWien volume data type.
 *
 * @author	Markus Trenkwalder
 * @date	16. Aug 2004, 19:44:21
 * @version	0.0.1
 *
 * $id: $
 *
 */
#ifndef _VUVOLUMEREGULARUNIMODAL3D1B2THRESMC_H_
#define _VUVOLUMEREGULARUNIMODAL3D1B2THRESMC_H_

#include "../threshold.h"

#include <GL/gl.h>
#include <GL/glu.h>
#define GLUT_DISABLE_ATEXIT_HACK
#include <GL/glut.h>

#include "vuImage.h"
#include "vuSimpleTypes.h"
#include "vuNormalTable.h"
#include "vuVector.h"

//using namespace ns_vu1112113;
#include "General/vuMarchingCubes/MarchingCubesBase.h"

class vu1112211;
typedef vu1112211 vuVolumeRegularUnimodal3d2BThresMarchingCubes;


/**
 * \brief Data specisific implementaition of the marching cubes algorithm.
 */
class vu1112211 : public vu111221, public MarchingCubesBase
{
public:
	//!Default constructor creating an empty instance.
	vu1112211();
	//!Copy constructor which does a deep copy.
	vu1112211(const vu1112211& inst);
	//!Destructor.
	virtual ~vu1112211();

	//!Assignment operator which does a deep copy.
	vu1112211& operator=(const vu1112211& rhs);

public:
	//!Set camera position.
	//void setViewVectors(const vuVector& view,const vuVector& up,const vuVector& right);
	//!Initializes open gl for rendering the volume data.
	//void initOpenGL(void);
	//!Implements the abstract render() method of the vuVolume base class.
	void render();

	//!Reimplements the read() method to do some extra volume data processing.
	virtual bool read();

};

#endif
