#include "MarchingCubes.h"
#include <fstream.h>
#include <math.h>

// Actual Mode: 3
#define DEBUG_MODE 99
#include "General/vuMarchingCubes/debug.h"

//----------------------------------------------------------------------------
//------------------------- Static texture variables -------------------------
//----------------------------------------------------------------------------
/*
static float texcoord0[2] = {0.0f, 0.0f};
static float texcoord1[2] = {0.0f, 1.0f};
static float texcoord2[2] = {1.0f, 1.0f};
static float texcoord3[2] = {1.0f, 0.0f};
*/

//----------------------------------------------------------------------------
//------------------------- The default constructor --------------------------
//----------------------------------------------------------------------------

vu1112211::vu1112211() // {{{
{
	DEBUG0("vu1112211::vu1112211()\n");
} // }}}

//----------------------------------------------------------------------------
//------------------------- The copy constructor -----------------------------
//----------------------------------------------------------------------------

vu1112211::vu1112211(const vu1112211& inst) : vu111221(inst) // {{{
{
	DEBUG0("vu1112211::vu1112211(const vu1112211& inst)\n");
} // }}}

//----------------------------------------------------------------------------
//------------------------- The destructor -----------------------------------
//----------------------------------------------------------------------------

vu1112211::~vu1112211() // {{{
{
	DEBUG0("vu1112211::~vu1112211()\n");
} // }}}

//----------------------------------------------------------------------------
//------------------------- The assignment operator --------------------------
//----------------------------------------------------------------------------

vu1112211& vu1112211::operator=(const vu1112211& rhs)
{
	DEBUG0("vu1112211& vu1112211::operator=(const vu1112211& rhs)\n");
	if (this != &rhs) {
		vu111221::operator=(rhs);
	}
	return *this;
}

//----------------------------------------------------------------------------
//------------------------- public setViewVectors() --------------------------
//----------------------------------------------------------------------------

/*
void vu1112211::setViewVectors(const vuVector& view,const vuVector& up,const vuVector& right)
{
}
*/

//----------------------------------------------------------------------------
//------------------------- public read() ------------------------------------
//----------------------------------------------------------------------------

bool vu1112211::read() // {{{
{
	DEBUG0("bool vu1112211::read()\n");

	ifstream in;

#ifdef IS_NOCREATE_NEEDED
	in.open(m_FileName, ios::in|ios::binary|ios::nocreate);
#else
	// The nocreate is not available on the IRIX boxes that we were compiling
	// this code on, so we had to remove this part from
	in.open(m_FileName, ios::in|ios::binary);
#endif
	DEBUG2("in.is_open() = "<<in.is_open()<<"\n");
	if (!in.is_open()) return false;

#if DEBUG_MODE <= 2
	//! First we do want to know how much data is in the file.
	in.seekg(0, ios::end);
	long len_is = in.tellg();
	in.seekg(0, ios::beg);
#endif

	//! After that we get the data size.
	char size_buf[6];
	in.read(size_buf, 6);
	if (in.fail()) return false;
	unsigned short* sizes = (unsigned short*)size_buf;
	Size(sizes[0], sizes[1], sizes[2]);
	DEBUG2("sizes = ("<<sizes[0]<<", "<<sizes[1]<<", "<<sizes[2]<<")\n");

	//! And calculate a correspinding file size.
	long page_size = sizes[0]*sizes[1];
	long data_size = page_size*sizes[2];
#if DEBUG_MODE <= 2
	int len_shld = data_size*2+6; // 6 is the header size.
#endif
	DEBUG2("len_shld vs. len_is: " << len_shld << " == " << len_is << "?\n");

	unsigned short buffer[page_size];
	long counter = 0;	// countes the number of values, written to _data
	StartProgress();
	SetProgressText("Reading data:");
	do {
		in.read((char*)buffer, page_size*2);
		if (in.fail()) return false;
		for(int i=0; i<page_size; ++i) _data[counter++] = buffer[i];
		DEBUG2("progress: " << (float)counter/(float)data_size*100.0 << "\n");
		UpdateProgress((int)((float)counter/(float)data_size*100.0));
	} while (counter < data_size && !in.fail());
	EndProgress();

	DEBUG2("data_size vs. counter: " << data_size << " == " << counter << "?\n");

	in.close();

	return true;
} // }}}


//----------------------------------------------------------------------------
//------------------------- public render() ----------------------------------
//----------------------------------------------------------------------------
void vu1112211::render(void) // {{{
{
	DEBUG0("void vu1112211::render(void)\n");
	glRender();
} // }}}


// vim:fdm=marker:fdc=3
