//!The base class for regular unimodal 3d 2 byte data in the vuVolume data tree.

#ifndef _VUVOLUMEREGULARUNIMODAL3D2B_H_
#define _VUVOLUMEREGULARUNIMODAL3D2B_H_

#include "../3d.h"
#include "../1B/1B.h"

class vu11122;
typedef vu11122 vuVolumeRegularUnimodal3d2B;

class vuConvert;

class vu11122 : public vu1112
{
    friend class vuConvert;
public:
    //!Reads volume data from the data file set with setFileName().
    /*!This implements the abstract read() method from the general Volume class.
       If the read is successful, the function returns true.  If the file does
       not exist or is in an invalid format, the function returns false.  In 
       this case, the error information is set for the instance.
       \return True if successful, false otherwise.
    */
    virtual bool read(void);
    //!Writes volume data to the data file set with setFileName().
    /*!This implements the abstract write() method from the general Volume class.
       \return True if successful, false otherwise.
    */
    virtual bool write(void);

    /** A friend to read fre.Z format from the visible human project. */
    friend bool readFreZ(vu11122 &volume, const vuString &filemask, 
			 int startID, int endID, int incID = 1);

    /*!laplacian weighted histogram and isosurface area
      see V.Pekar, R.Wienker, D.Hempel, "Fast Detection of Meaningful
      Isosurfaces for Volume Data Visualization", in Proccedings of
      IEEE Visualization 2001
      \param filename name of the textfile to write the histogram to
    */
    void generateLapWeightHistogram(const char* filename);

    //! returns the value at position x,y,z
    word getDataValue(unsigned int x, unsigned int y, unsigned int z);

    //!Empty implementation to satisfy virtual.
    virtual void setViewVectors (const vuVector &, const vuVector &, const vuVector &) {};
    //!Empty implementation to satisfy virtual.
    virtual void render() {};

    /** Creates a histogram in hist.
	This is just a preliminary version of histogram creation. See
	class vuHistogram for a more detailed discussion. 
	\return false - could not create histogram type
    */
    bool createHistogram(vuHistogram& hist) const;

    /** Remaps the intensities */
    void remap(const vuMap& map);

 protected:
    //!Asserts that the file is 2B data and reads the associated information.
    /*!This method reads in the general information for 2B data sets.
       It also asserts whether the data is indeed 2B or not.
       !!By now this is just a copy of the 1B function. This has to be fixed!!!
       \return True if successful (data is regular), false otherwise.
    */
    virtual bool read(FILE *file);
    //!Writes the general 3d data information to the file.
    /*!\return True if successful, false otherwise.
    */
    virtual bool write(FILE *file);

};

#endif
