#include "2B.h"
#include "vuVHImage.h"
#include <stdio.h>
#include <string.h>

//----------------------------------------------------------------------------
//------------------------- public read() ------------------------------------
//----------------------------------------------------------------------------

bool vu11122::read(void)
{
    if (m_FileName.isEmpty()) return setError("No file name specified.");
    FILE *file = fopen(m_FileName,"rb");
    if (file != NULL)
    {
        bool success = read(file);
        fclose(file);
        return success;
    }
    else
        return setError("Could not open the specified file.");
}

//----------------------------------------------------------------------------
//------------------------- public write() -----------------------------------
//----------------------------------------------------------------------------

bool vu11122::write(void)
{
    if (m_FileName.isEmpty()) return setError("No file name specified.");
    
    FILE *file = fopen(m_FileName,"wb");
    if (file != NULL)
    {
        bool success = write(file);
        fclose(file);
        return success;
    }
    else
        return setError("Could not open the specified file.");
}

//----------------------------------------------------------------------------
//------------------------- protected read() ---------------------------------
//----------------------------------------------------------------------------

/*!!By now this is just a copy of the 1B function. This has to be fixed!!!*/
bool vu11122::read(FILE *file)
{
    int ret = 0;
    dword size = 0;
    int len = 0;

    //Read in the base data.
    bool success = vu1112::read(file);
    if (!success) return false;

    //Read in the name of the data
    char dataName[64];
    ret = fscanf(file,"SCALARS %s ",dataName);
    if (ret != 1) return setInvalidFormatError();
    //Store the name of the data
    m_DataName = dataName;

    //Read in the type of data and the colour lookup table.
    fscanf(file,"word LOOKUP_TABLE default%n",&len);
    if ((len < 25) || (fgetc(file) != '\n')) return setInvalidFormatError();

    //check data size
    if (m_DataSize != (m_Dim1Size * m_Dim2Size * m_Dim3Size*2))
        return setInvalidFormatError();

    //Allocate memory for the volume data
    m_Data = new byte[m_DataSize];

    //Read in the volume data according to the format of the file
    if (m_Binary)
        size = fread(m_Data,1,m_DataSize,file);
    else
    {
        ret = 1;
        dword i = 0;
        while ((ret > 0) && (i < m_DataSize)) {
	    int n;
            ret = fscanf(file," %i", &n);
	    *((word*)&m_Data[i+=2]) = (word)n;
	}
        size = i;
    }
    
    //Make sure that the right amount of data was read in
    if (size != m_DataSize) return setInvalidFormatError();

    return true;
}

//----------------------------------------------------------------------------
//------------------------- protected write() --------------------------------
//----------------------------------------------------------------------------

bool vu11122::write(FILE *file)
{
    int ret;
    dword size = 0;

    m_Binary = true;

    bool success = vu1112::write(file);
    if (!success) return false;
    
    fprintf(file,"SCALARS ");

    //Write the name of the data
    if (!m_DataName.isEmpty())
        fprintf(file,"%s ",m_DataName.c_str());
    else
        fprintf(file,"data ");

    fprintf(file,"word\nLOOKUP_TABLE default\n");

    //Write the volume data according to it's format
    if (m_Binary)
        size = fwrite(m_Data,1,m_DataSize,file);
    else
    {
        ret = 1;
        dword i = 0;
        while ((ret > 0) && (i < m_DataSize/2))
            ret = fprintf(file," %d",((word*)m_Data)[i++]);
        size = i*2;
    }
    
    if (size == m_DataSize)
        return true;
    else
        return setWriteError();
}

word vu11122::getDataValue(unsigned int x, unsigned int y, unsigned int z)
{
  if ( (x<0) || (x>=m_Dim1Size) || (y<0) || (y>=m_Dim2Size) || (z<0) || (z>=m_Dim3Size) )
    return 0;
  else
    return m_Data[(x+y*m_Dim1Size+z*m_Dim1Size*m_Dim2Size)*2];
}

void vu11122::generateLapWeightHistogram(const char* filename)
{
    /*!laplacian weighted histogram and isosurface area
      see V.Pekar, R.Wienker, D.Hempel, "Fast Detection of Meaningful
      Isosurfaces for Volume Data Visualization", in Proccedings of
      IEEE Visualization 2001
    */

    unsigned long laplace_hist[256*256];
    unsigned long surface_area[256*256];
    //
    // generate laplacian weighted histogram
    //

    for (int i=0; i<256*256; i++)
      {
	laplace_hist[i] = 0;
	surface_area[i] = 0;
      }

    for (unsigned int k=0; k<m_Dim3Size; k++)
      for (unsigned int j=0; j<m_Dim2Size; j++)
	for (unsigned int i=0; i<m_Dim1Size; i++)
	  {
	    unsigned int val = getDataValue(i,j,k);
	    
	    laplace_hist[val] +=
	      ((getDataValue(i, j , k) - getDataValue(i+2, j, k)) - (getDataValue(i-2, j , k) - getDataValue(i, j, k))) +
	      ((getDataValue(i, j , k) - getDataValue(i, j+2, k)) - (getDataValue(i, j-2 , k) - getDataValue(i, j, k))) +
	      ((getDataValue(i, j , k) - getDataValue(i, j, k+2)) - (getDataValue(i, j , k-2) - getDataValue(i, j, k)));

	      if (val > getDataValue(i+1,j,k))
		surface_area[val] += 1;
	      if (val < getDataValue(i+1,j,k))
		surface_area[val] -= 1;
	      if (val > getDataValue(i-1,j,k))
		surface_area[val] += 1;
	      if (val < getDataValue(i-1,j,k))
		surface_area[val] -= 1;

	      if (val > getDataValue(i,j+1,k))
		surface_area[val] += 1;
	      if (val < getDataValue(i,j+1,k))
		surface_area[val] -= 1;
	      if (val > getDataValue(i,j-1,k))
		surface_area[val] += 1;
	      if (val < getDataValue(i,j-1,k))
		surface_area[val] -= 1;

	      if (val > getDataValue(i,j,k+1))
		surface_area[val] += 1;
	      if (val < getDataValue(i,j,k+1))
		surface_area[val] -= 1;
	      if (val > getDataValue(i,j,k-1))
		surface_area[val] += 1;
	      if (val < getDataValue(i,j,k-1))
		surface_area[val] -= 1;
	  }

    for (int i = 256*256-2; i>= 0; i--)
      {
	laplace_hist[i] += laplace_hist[i+1];
	surface_area[i] += surface_area[i+1];
      }

    cout << "Writing laplacian weighted histogram to file..." << endl;

    FILE *fp1, *fp2;
    
    fp1=fopen("lp_hist16.dat","w");
    fp2=fopen("lp_area_hist16.dat","w");
    
    // write header
    for (int i=0; i<256*256; i++)
      {
	fprintf(fp1, "%d %d\n", i, (int)laplace_hist[i]);
	if (surface_area[i] != 0)
	  fprintf(fp2, "%d %f\n", i, double(laplace_hist[i])/double(surface_area[i]));
      }
	
    fclose(fp1);
    fclose(fp2);
}

/** A friend to read fre.Z format from the visible human project. */
bool readFreZ(vu11122 &volume, const vuString &filemask, 
		     int startID, int endID, int incID)
{
    char filename[2048];
    if(endID<startID || startID<0) return false;
    sprintf(filename,filemask,startID);
    vuVHImage img(filename);
    if(!img.magicMatch()) return false;
    if(img.getWidth()>0 && img.getHeight()>0)
    {
	volume.m_Dim1Size = img.getWidth();
	volume.m_Dim2Size = img.getHeight();
	volume.m_Dim3Size = (endID-startID)/incID + 1;
	endID = startID + (volume.m_Dim3Size-1)*incID;
	volume.m_DataSize = volume.m_Dim1Size*
	    volume.m_Dim2Size*volume.m_Dim3Size*2;

	volume.m_Spacing = 1;
	
	volume.m_Dim1Origin = 0;
	volume.m_Dim2Origin = 0;
	volume.m_Dim3Origin = 0;
	volume.m_Data = new byte[volume.m_DataSize];

// 	cout << volume.m_Dim1Size << "x" 
// 	     << volume.m_Dim2Size << "x" 
// 	     << volume.m_Dim3Size << endl;

	int sliceID, nslice;
	for(sliceID = startID, nslice=0; sliceID<=endID; 
	    sliceID+=incID, nslice++)
	{
	    sprintf(filename,filemask,sliceID);
	    if(!img.loadSlice(filename)) return false;
	    memcpy(&volume.m_Data[volume.m_Dim1Size*volume.m_Dim2Size*2*nslice], 
	    	   img.getData(), volume.m_Dim1Size*volume.m_Dim2Size*2);
	}
    }	
    return true;
}

bool vu11122::createHistogram(vuHistogram& hist) const
{
    if(hist.getType() == vuHistogram::TYPE_INTENSITY) {
	hist.reset();
	const word *dat = (word*)m_Data;
	dword p;
	for(p=0; p<m_Dim1Size*m_Dim2Size*m_Dim3Size; p++, dat++)
	    hist.recordIntensity(*dat);
	return true;
    } else return false;
}

void vu11122::remap(const vuMap& map)
{
    dword i;
    word *dat = (word*)m_Data;
    for(i=m_Dim1Size*m_Dim2Size*m_Dim3Size; i>0; i--, dat++)
	*dat = map[*dat];
}

